/*
 * Decompiled with CFR 0.152.
 */
package zexplore.statusbar;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import zexplore.IconMap;
import zexplore.Server;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = -1059206854115611037L;
    private static final String gap = "  ";
    private static JLabel connectionStatusLabel = new JLabel("");
    private static JLabel executionTimeLabel = new JLabel("");

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.setDefaultStatus();
        this.add((Component)connectionStatusLabel, "West");
        this.add((Component)executionTimeLabel, "East");
    }

    public void setConnectionStatus(String string) {
        connectionStatusLabel.setText(gap + string);
        if (string.contains("Disconnected")) {
            connectionStatusLabel.setIcon(new IconMap().getIcon("disconnected"));
        } else if (string.contains("Connected") && string.contains("HTTPS")) {
            connectionStatusLabel.setIcon(new IconMap().getIcon("connected-secured"));
        } else if (string.contains("Connected") && !string.contains("HTTPS")) {
            connectionStatusLabel.setIcon(new IconMap().getIcon("connected"));
        }
    }

    public String getConnectionStatus() {
        return connectionStatusLabel.getText();
    }

    public void setExecutionTime(long l) {
        if (l == -1L) {
            executionTimeLabel.setText("");
        } else {
            executionTimeLabel.setText(l + " ms" + gap);
        }
    }

    public String getExecutionTime() {
        return executionTimeLabel.getText();
    }

    public void setDefaultStatus() {
        this.setConnectionStatus("Disconnected");
        this.setExecutionTime(-1L);
    }

    public void setServerStatus(Server server) {
        if (server != null) {
            String string = server.getServerFieldInfo("login");
            String string2 = server.getServerFieldInfo("server");
            String string3 = server.getServerFieldInfo("port");
            String string4 = server.getServerFieldInfo("protocol");
            String string5 = server.getVersion();
            String string6 = "Connected  " + string + " @ " + string2 + " : " + string3 + " (" + string4 + ") " + " [" + string5 + "] ";
            this.setConnectionStatus(string6);
        } else {
            this.setDefaultStatus();
        }
    }
}

