/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.file;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import zexplore.View;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.develop.DevelopTabPanel;
import zexplore.menubar.file.CustomFileFilter;
import zexplore.menubar.preferences.PreferencesMenu;

public class LanguageExportItem
extends JMenuItem {
    private static final long serialVersionUID = -5422314419580276106L;
    private static JFileChooser fileChooser = new JFileChooser();
    private static CustomFileFilter filter = new CustomFileFilter("java");

    public LanguageExportItem() {
        this.setText("Java               Ctrl+Shift+L");
        this.setMnemonic(76);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageExportItem.this.exportSelectedLanguageWorkflow();
            }
        });
    }

    public void exportSelectedLanguageWorkflow() {
        int n = ExecuteDevelopPane.developTabbedPane.getSelectedIndex();
        DevelopTabPanel developTabPanel = (DevelopTabPanel)ExecuteDevelopPane.developTabbedPane.getComponentAt(n);
        String string = ExecuteDevelopPane.developTabbedPane.getTitleAt(n);
        String string2 = PreferencesMenu.languagesMenu.getSelectedLanguage();
        String string3 = this.getExtension(string2);
        filter.setFileExtension(string3);
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle("Export " + string2 + " Workflow");
        fileChooser.setSelectedFile(new File(string + "." + string3, ""));
        int n2 = fileChooser.showSaveDialog(View.frame);
        if (n2 == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(developTabPanel.developPanel.developPane.getText());
                bufferedWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String getExtension(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("C#")) {
            string2 = "cs";
        } else if (string.equalsIgnoreCase("C")) {
            string2 = "c";
        } else if (string.equalsIgnoreCase("java")) {
            string2 = "java";
        } else if (string.equalsIgnoreCase("Perl")) {
            string2 = "pl";
        } else if (string.equalsIgnoreCase("Python")) {
            string2 = "py";
        } else if (string.equalsIgnoreCase("Ruby")) {
            string2 = "rb";
        }
        return string2;
    }
}

