/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.execute;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.Server;
import zexplore.View;
import zexplore.addedapisworkflows.addedapis.AddedApisTreePanel;
import zexplore.addedapisworkflows.workflows.WorkflowsTreePanel;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;

public class ExecuteTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 2295578573631308254L;
    private static int newTabIndex = 0;

    public ExecuteTabbedPane() {
        this.addNewTab();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                if (ExecuteTabbedPane.this.getTabCount() == ExecuteDevelopPane.developTabbedPane.getTabCount()) {
                    ExecuteDevelopPane.developTabbedPane.setSelectedIndex(ExecuteTabbedPane.this.getSelectedIndex());
                }
                if ((n = ExecuteTabbedPane.this.getSelectedIndex()) >= 0) {
                    ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteTabbedPane.this.getComponentAt(n);
                    AddedApisTreePanel.tree.setModel(executeTabPanel.inputPanel.treeModel);
                    Server server = executeTabPanel.getServer();
                    View.statusBar.setServerStatus(server);
                    if (server != null) {
                        APIExplorerPanel.apiDropDownComboBox.selectApiDocVersion(server.getApiDocVersion());
                    }
                } else {
                    AddedApisTreePanel.tree.setModel(null);
                    View.statusBar.setDefaultStatus();
                }
            }
        });
        this.addKeyListener(new KeyOperationsListener());
    }

    public void addNewTab() {
        String string = "New " + Integer.toString(++newTabIndex);
        final JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(string);
        jPanel.add(jLabel);
        ImageIcon imageIcon = new IconMap().getIcon("close");
        JButton jButton = new JButton(imageIcon);
        jButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconWidth()));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExecuteTabbedPane.this.removeSelectedTab(ExecuteTabbedPane.this.indexOfTabComponent(jPanel), true);
            }
        });
        jButton.addKeyListener(new KeyOperationsListener());
        jPanel.add(jButton);
        ExecuteTabPanel executeTabPanel = new ExecuteTabPanel();
        this.addTab(string, executeTabPanel);
        this.setTabComponentAt(this.getTabCount() - 1, jPanel);
        this.setSelectedIndex(this.getTabCount() - 1);
        if (this.getTabCount() > 1) {
            ExecuteTabPanel executeTabPanel2 = (ExecuteTabPanel)this.getComponentAt(this.getTabCount() - 2);
            executeTabPanel.setServer(executeTabPanel2.getServer());
            View.statusBar.setServerStatus(executeTabPanel.getServer());
        }
        AddedApisTreePanel.tree.setModel(null);
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void removeSelectedTab(int n, boolean bl) {
        this.removeWorkflow(n);
        this.remove(n);
        if (bl) {
            ExecuteDevelopPane.developTabbedPane.removeSelectedTab(n, false);
        }
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void renameTab(int n, String string) {
        JPanel jPanel = (JPanel)this.getTabComponentAt(n);
        JLabel jLabel = (JLabel)jPanel.getComponent(0);
        if (jLabel.getText().equals(string)) {
            return;
        }
        jLabel.setText(string);
        this.setTitleAt(n, string);
        ExecuteDevelopPane.developTabbedPane.renameTab(n, string);
    }

    private void removeWorkflow(int n) {
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)this.getComponentAt(n);
        int n2 = executeTabPanel.getWorkflowNodeIndex();
        if (n2 < 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)WorkflowsTreePanel.tree.getModel().getRoot();
        for (int i = n2 + 1; i < defaultMutableTreeNode.getChildCount(); ++i) {
            int n3 = WorkflowsTreePanel.tree.getExecuteTabPanelIndex(i);
            ExecuteTabPanel executeTabPanel2 = (ExecuteTabPanel)this.getComponentAt(n3);
            executeTabPanel2.setWorkflowNodeIndex(i - 1);
            WorkflowsTreePanel.tree.setExecuteTabPanelIndex(i - 1, n3);
        }
        WorkflowsTreePanel.tree.removeUserDefinedWorkflow(n2);
    }
}

