/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.develop;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.codegenerator.CodeGenerator;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.develop.DevelopTabPanel;

public class DevelopTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 2295578573631308254L;
    private static int newTabIndex = 0;

    public DevelopTabbedPane() {
        this.addNewTab();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DevelopTabbedPane.this.getTabCount() == ExecuteDevelopPane.executeTabbedPane.getTabCount()) {
                    int n = DevelopTabbedPane.this.getSelectedIndex();
                    ExecuteDevelopPane.executeTabbedPane.setSelectedIndex(n);
                    if (n >= 0 && DevelopTabbedPane.this.isShowing()) {
                        CodeGenerator.generateSampleCode();
                    }
                }
            }
        });
        this.addKeyListener(new KeyOperationsListener());
    }

    public void addNewTab() {
        String string = "New " + Integer.toString(++newTabIndex);
        final JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(string);
        jPanel.add(jLabel);
        ImageIcon imageIcon = new IconMap().getIcon("close");
        JButton jButton = new JButton(imageIcon);
        jButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconWidth()));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopTabbedPane.this.removeSelectedTab(DevelopTabbedPane.this.indexOfTabComponent(jPanel), true);
            }
        });
        jButton.addKeyListener(new KeyOperationsListener());
        jPanel.add(jButton);
        DevelopTabPanel developTabPanel = new DevelopTabPanel();
        this.addTab(string, developTabPanel);
        this.setTabComponentAt(this.getTabCount() - 1, jPanel);
        this.setSelectedIndex(this.getTabCount() - 1);
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void removeSelectedTab(int n, boolean bl) {
        this.remove(n);
        if (bl) {
            ExecuteDevelopPane.executeTabbedPane.removeSelectedTab(n, false);
        }
        if (this.isShowing()) {
            this.requestFocus();
        }
    }

    public void renameTab(int n, String string) {
        JPanel jPanel = (JPanel)this.getTabComponentAt(n);
        JLabel jLabel = (JLabel)jPanel.getComponent(0);
        if (jLabel.getText().equals(string)) {
            return;
        }
        jLabel.setText(string);
        this.setTitleAt(n, string);
        ExecuteDevelopPane.executeTabbedPane.renameTab(n, string);
    }
}

