/*
 * Decompiled with CFR 0.152.
 */
package zexplore.codegenerator;

import zexplore.codegenerator.LanguageCodeGenerator;

public class JavaGenerator
implements LanguageCodeGenerator {
    private static StringBuffer code = new StringBuffer();

    @Override
    public void beginCode(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, String string8) {
        code.setLength(0);
        code.append("import java.io.IOException;\n");
        code.append("import java.net.UnknownHostException;\n");
        code.append("import java.util.List;\n");
        code.append("\n");
        code.append("import netapp.manage.NaElement;\n");
        code.append("import netapp.manage.NaException;\n");
        code.append("import netapp.manage.NaServer;\n");
        code.append("\n");
        code.append("public class ApiClient {\n");
        code.append("\n");
        code.append("\tpublic static void main(String[] args) {\n");
        code.append("\t\ttry {\n");
        if (string == null || string.isEmpty()) {
            string = "<server name or IP address>";
        }
        if (string4 == null || string4.isEmpty()) {
            string4 = "<user name>";
        }
        string5 = string5 != null && string5.equals("DFM") ? "NaServer.SERVER_TYPE_DFM" : "NaServer.SERVER_TYPE_FILER";
        string6 = string6 != null && string6.equals("HTTP") ? "NaServer.TRANSPORT_TYPE_HTTP" : "NaServer.TRANSPORT_TYPE_HTTPS";
        if (string7 == null || string7.isEmpty()) {
            string7 = string5.equals("NaServer.SERVER_TYPE_DFM") ? (string6.equals("NaServer.TRANSPORT_TYPE_HTTPS") ? "8488" : "8088") : (string6.equals("NaServer.TRANSPORT_TYPE_HTTPS") ? "443" : "80");
        }
        code.append("\t\t\tNaServer s = new NaServer(\"" + string + "\", " + string2 + " , " + string3 + ");\n");
        code.append("\t\t\ts.setServerType(" + string5 + ");\n");
        code.append("\t\t\ts.setTransportType(" + string6 + ");\n");
        code.append("\t\t\ts.setPort(" + string7 + ");\n");
        code.append("\t\t\ts.setStyle(NaServer.STYLE_LOGIN_PASSWORD);\n");
        code.append("\t\t\ts.setAdminUser(\"" + string4 + "\", \"<password>\");\n");
        if (string8 != null && !string8.isEmpty()) {
            if (bl) {
                code.append("\t\t\ts.setVserver(\"" + string8 + "\");\n");
            } else {
                code.append("\t\t\ts.setVfilerTunneling(\"" + string8 + "\");\n");
            }
        }
        code.append("\n");
        code.append("\n");
    }

    @Override
    public String endCode() {
        code.append("\t\t} catch (NaException e) {\n");
        code.append("\t\t\thandleException(e);\n");
        code.append("\t\t} catch (UnknownHostException e) {\n");
        code.append("\t\t\thandleException(e);\n");
        code.append("\t\t} catch (IOException e) {\n");
        code.append("\t\t\thandleException(e);\n");
        code.append("\t\t}\n");
        code.append("\t}\n");
        code.append("\n");
        code.append("\tprivate static void handleException(Exception e) {\n");
        code.append("\t\tSystem.out.println(e.getMessage());\n");
        code.append("\t\te.printStackTrace();\t\t\n");
        code.append("\t}\n");
        code.append("}\n");
        return code.toString();
    }

    @Override
    public String beginAPI(int n, String string) {
        String string2 = "api";
        if (n > 0) {
            string2 = string2 + n;
        }
        code.append("\t\t\tNaElement " + string2 + " = new NaElement(\"" + string + "\");\n");
        return string2;
    }

    @Override
    public void endAPI(int n, String string) {
        String string2 = "xo";
        if (n > 0) {
            string2 = string2 + n;
        }
        String string3 = "children";
        if (n > 0) {
            string3 = string3 + n;
        }
        code.append("\n");
        code.append("\t\t\tNaElement " + string2 + " = s.invokeElem(" + string + ");\n");
        code.append("\t\t\tSystem.out.println(" + string2 + ".toPrettyString(\"\"));\n");
        code.append("\n");
        code.append("\n");
    }

    @Override
    public String addTypeParameter(String string, String string2, int n, int n2) {
        String string3 = "xi";
        if (n > 0) {
            string3 = string3 + "_" + n;
        }
        if (n2 > 0) {
            string3 = n > 0 ? string3 + "_" + n2 : string3 + n2;
        }
        code.append("\n");
        code.append("\t\t\tNaElement " + string3 + " = new NaElement(\"" + string2 + "\");\n");
        code.append("\t\t\t" + string + ".addNewChild(" + string3 + ");\n");
        code.append("\n");
        return string3;
    }

    @Override
    public void addSimpleParameter(String string, String string2, String string3) {
        if (string3.isEmpty()) {
            string3 = "<" + string2 + ">";
        }
        code.append("\t\t\t" + string + ".addNewChild(\"" + string2 + "\",\"" + string3 + "\");\n");
    }

    @Override
    public void addComment(String string) {
        code.append("\n");
        code.append("\t\t\t// " + string + "\n");
    }
}

