/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.apiexplorer.APITreePanel;
import zexplore.codegenerator.CodeGenerator;

public class GenerateButtonPanel
extends JPanel {
    private static final long serialVersionUID = -7382143104978300627L;
    private static JButton generateButton;

    public GenerateButtonPanel() {
        this.setLayout(new BorderLayout());
        generateButton = new JButton(new IconMap().getIcon("right-arrow"));
        String string = "Press to Generate codes for selected APIs.";
        generateButton.setToolTipText(string);
        generateButton.setContentAreaFilled(false);
        this.add((Component)generateButton, "Center");
        generateButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                generateButton.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                generateButton.setContentAreaFilled(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                GenerateButtonPanel.this.generate();
            }
        });
        generateButton.addKeyListener(new KeyOperationsListener());
    }

    public void generate() {
        TreePath[] treePathArray = APITreePanel.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length <= 0) {
            return;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (defaultMutableTreeNode.getLevel() != 2) continue;
            CodeGenerator.generateCode(defaultMutableTreeNode.toString(), APITreePanel.tree.apiParser);
        }
    }
}

