/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import zexplore.KeyOperationsListener;
import zexplore.View;
import zexplore.apiexplorer.APIExplorerPanel;

public class AddNewApiDocDialog
extends JDialog {
    private static final long serialVersionUID = 9061412228843932075L;
    private JFrame frame;
    private JPanel mainPanel;
    private AddNewApiDocDialog dialog;
    private JPanel apiDocPathServerTypePanel;
    private JPanel apiDocPathPanel;
    private JLabel apiDocPathLabel;
    private JTextComponent apiDocPathTextField;
    private JButton apiDocPathBrowseButton;
    private boolean isValidPath = false;
    private JPanel serverTypeRadioPanel;
    private JRadioButton ontapClusterVserverModeRadioButton;
    private JRadioButton ontap7ModeRadioButton;
    private JRadioButton dfmRadioButton;
    private ButtonGroup serverTypeRadioButtonGroup;
    private JPanel apiVersionPanel;
    private JLabel apiVersionLabel;
    private JTextComponent apiVersionTextField;
    private boolean isValidVersion = false;
    private JPanel rememberJCheckBoxDoneCancelButtonPanel;
    private JCheckBox rememberPathCheckBox;
    private JPanel doneCancelbuttonPanel;
    private JButton doneButton;
    private JButton cancelButton;
    private List<String> docNames = new ArrayList<String>();
    private boolean docNameOverwrite = false;

    public AddNewApiDocDialog() {
        super(View.frame, "Add New Api Document", true);
        this.frame = View.frame;
        this.dialog = this;
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 0, 2));
        this.apiDocPathPanel = this.getApiDocPathPanel();
        this.serverTypeRadioPanel = this.getServerTypeRadioPanel();
        this.apiDocPathServerTypePanel = new JPanel(new BorderLayout());
        this.apiDocPathServerTypePanel.add((Component)this.apiDocPathPanel, "North");
        this.apiDocPathServerTypePanel.add((Component)this.serverTypeRadioPanel, "South");
        this.mainPanel.add((Component)this.apiDocPathServerTypePanel, "North");
        this.apiVersionPanel = this.getApiVersionPanel();
        this.mainPanel.add((Component)this.apiVersionPanel, "Center");
        this.rememberJCheckBoxDoneCancelButtonPanel = new JPanel(new BorderLayout());
        this.rememberJCheckBoxDoneCancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.mainPanel.add((Component)this.rememberJCheckBoxDoneCancelButtonPanel, "South");
        this.rememberPathCheckBox = new JCheckBox("Remember the path of the Api Document during subsequent launches");
        this.rememberJCheckBoxDoneCancelButtonPanel.add((Component)this.rememberPathCheckBox, "North");
        this.doneCancelbuttonPanel = this.getDoneCancelButtonPanel();
        this.rememberJCheckBoxDoneCancelButtonPanel.add((Component)this.doneCancelbuttonPanel, "South");
        this.dialog.getContentPane().add(this.mainPanel);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
        this.dialog.addKeyListener(new KeyOperationsListener(this.dialog));
    }

    private JPanel getApiDocPathPanel() {
        this.apiDocPathLabel = new JLabel("Path:");
        this.apiDocPathLabel.setToolTipText("Set the path for loading new Api Document");
        this.apiDocPathLabel.addKeyListener(new KeyOperationsListener(this.dialog));
        this.apiDocPathTextField = new JTextField(40);
        this.apiDocPathTextField.setToolTipText("Set the path for loading new Api Document");
        this.addControlKeyListener(this.apiDocPathTextField);
        this.apiDocPathTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        final Border border = this.apiDocPathTextField.getBorder();
        this.apiDocPathTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = AddNewApiDocDialog.this.apiDocPathTextField.getText().trim();
                if (string.isEmpty()) {
                    AddNewApiDocDialog.this.doneButton.setEnabled(false);
                    AddNewApiDocDialog.this.apiDocPathTextField.setBorder(border);
                } else {
                    AddNewApiDocDialog.this.checkFile(string);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                String string = AddNewApiDocDialog.this.apiDocPathTextField.getText().trim();
                if (string.isEmpty()) {
                    AddNewApiDocDialog.this.doneButton.setEnabled(false);
                    AddNewApiDocDialog.this.apiDocPathTextField.setBorder(border);
                } else {
                    AddNewApiDocDialog.this.checkFile(string);
                }
            }
        });
        this.apiDocPathBrowseButton = new JButton("Browse");
        this.apiDocPathBrowseButton.setToolTipText("Browse the path for loading new Api Document");
        this.apiDocPathBrowseButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.apiDocPathBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Browse new Api Document");
                int n = jFileChooser.showOpenDialog(View.frame);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getPath();
                    AddNewApiDocDialog.this.apiDocPathTextField.setText(string);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Api Document "));
        jPanel.setToolTipText("Set the path for loading new Api Document");
        jPanel.addKeyListener(new KeyOperationsListener(this.dialog));
        jPanel.add(this.apiDocPathLabel);
        jPanel.add(this.apiDocPathTextField);
        jPanel.add(this.apiDocPathBrowseButton);
        return jPanel;
    }

    private JPanel getServerTypeRadioPanel() {
        this.ontapClusterVserverModeRadioButton = new JRadioButton("Data ONTAP - Cluster Mode/Vserver", true);
        this.ontapClusterVserverModeRadioButton.setToolTipText("Select the server type corresponding to the selected Api Document");
        this.ontapClusterVserverModeRadioButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.ontapClusterVserverModeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddNewApiDocDialog.this.apiVersionLabel.setText("<major_version>.<minor_version> (e.g. 1.16)");
                AddNewApiDocDialog.this.apiVersionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Ontap Api Version "));
            }
        });
        this.ontap7ModeRadioButton = new JRadioButton("Data ONTAP - 7 Mode", false);
        this.ontap7ModeRadioButton.setToolTipText("Select the Server Type corresponding to the selected Api Document");
        this.ontap7ModeRadioButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.ontap7ModeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddNewApiDocDialog.this.apiVersionLabel.setText("<major_version>.<minor_version> (e.g. 1.16)");
                AddNewApiDocDialog.this.apiVersionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Ontap Api Version "));
            }
        });
        this.dfmRadioButton = new JRadioButton("DataFabric Manager server", false);
        this.dfmRadioButton.setToolTipText("Select the Server Type corresponding to the selected Api Document");
        this.dfmRadioButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.dfmRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddNewApiDocDialog.this.apiVersionLabel.setText("<major_version>.<minor_version> (e.g. 5.1)");
                AddNewApiDocDialog.this.apiVersionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " DataFabric Manager server Version "));
            }
        });
        this.serverTypeRadioButtonGroup = new ButtonGroup();
        this.serverTypeRadioButtonGroup.add(this.ontapClusterVserverModeRadioButton);
        this.serverTypeRadioButtonGroup.add(this.ontap7ModeRadioButton);
        this.serverTypeRadioButtonGroup.add(this.dfmRadioButton);
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setToolTipText("Select the Server Type corresponding to the selected Api Document");
        jPanel.add(this.ontapClusterVserverModeRadioButton);
        jPanel.add(this.ontap7ModeRadioButton);
        jPanel.add(this.dfmRadioButton);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Server Type "));
        return jPanel;
    }

    private JPanel getApiVersionPanel() {
        this.apiVersionLabel = new JLabel("<major_version>.<minor_version> (e.g. 1.16)");
        this.apiVersionLabel.setToolTipText("Api Version corresponding to the selected Api Document");
        this.apiVersionLabel.addKeyListener(new KeyOperationsListener(this.dialog));
        this.apiVersionTextField = new JTextField(4);
        final Border border = this.apiVersionTextField.getBorder();
        this.apiVersionTextField.setToolTipText("Api Version corresponding to the selected Api Document");
        this.addControlKeyListener(this.apiVersionTextField);
        this.apiVersionTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        this.apiVersionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = AddNewApiDocDialog.this.apiVersionTextField.getText().trim();
                if (string.isEmpty()) {
                    AddNewApiDocDialog.this.doneButton.setEnabled(false);
                    AddNewApiDocDialog.this.apiVersionTextField.setBorder(border);
                } else {
                    AddNewApiDocDialog.this.checkVersion(string);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                String string = AddNewApiDocDialog.this.apiVersionTextField.getText().trim();
                if (string.isEmpty()) {
                    AddNewApiDocDialog.this.doneButton.setEnabled(false);
                    AddNewApiDocDialog.this.apiVersionTextField.setBorder(border);
                } else {
                    AddNewApiDocDialog.this.checkVersion(string);
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setToolTipText("Api Version corresponding to the selected Api Document");
        jPanel.add((Component)this.apiVersionLabel, "West");
        jPanel.add((Component)this.apiVersionTextField, "East");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Ontap Api Version "));
        return jPanel;
    }

    private JPanel getDoneCancelButtonPanel() {
        this.doneButton = new JButton("Done");
        this.doneButton.setToolTipText("Press to confirm the Server Type and Api Version corresponding to the Api Document");
        JPanel jPanel = new JPanel();
        jPanel.add(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddNewApiDocDialog.this.done();
            }
        });
        this.doneButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.doneButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Press to cancel loading new Api Version");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddNewApiDocDialog.this.dispose();
            }
        });
        this.cancelButton.addKeyListener(new KeyOperationsListener(this.dialog));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 10, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        return jPanel3;
    }

    private void done() {
        String string = this.createDocName();
        if (string == null) {
            return;
        }
        String string2 = this.apiDocPathTextField.getText().trim();
        if (!APIExplorerPanel.apiDropDownComboBox.readFileSetParser(string, string2)) {
            return;
        }
        this.docNames.add(string);
        if (string.contains("Cluster-Mode")) {
            if ((string = string.replace("Cluster-Mode", "Vserver")) == null) {
                return;
            }
            if (!APIExplorerPanel.apiDropDownComboBox.readFileSetParser(string, string2)) {
                return;
            }
            this.docNames.add(string);
        }
        this.dialog.dispose();
    }

    private String createDocName() {
        int n;
        int n2;
        String string = null;
        String string2 = this.apiVersionTextField.getText();
        String string3 = null;
        if (!this.dfmRadioButton.isSelected()) {
            string = "Ontapi " + string2;
            string3 = "Ontap (7-Mode)";
            if (this.ontapClusterVserverModeRadioButton.isSelected()) {
                string = string + " Cluster-Mode";
                string3 = "Ontap (Cluster-Mode)";
            } else {
                String[] stringArray = string2.split("\\.");
                n2 = Integer.parseInt(stringArray[0]);
                n = Integer.parseInt(stringArray[1]);
                if (n2 != 1 || n >= 15) {
                    string = string + " 7-Mode";
                }
            }
        } else {
            string = "DFM " + string2;
            string3 = "DataFabric Manager server";
        }
        int n3 = APIExplorerPanel.apiDropDownComboBox.getItemCount();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!APIExplorerPanel.apiDropDownComboBox.getItemAt(n2).equals(string)) continue;
            if (APIExplorerPanel.apiDropDownComboBox.apiDocList.getDocList().contains(string)) {
                JOptionPane.showMessageDialog(View.frame, "Api version " + string2 + " for " + string3 + " is already present.\nPlease specify a different Api version.", "Invalid Input", 2);
                return null;
            }
            n = JOptionPane.showConfirmDialog(View.frame, "Api version " + string2 + " for " + string3 + " is already present.\nDo you want to overwrite " + string + "?", "Invalid Input", 0);
            if (n == 0) {
                this.docNameOverwrite = true;
                continue;
            }
            this.docNameOverwrite = false;
            return null;
        }
        return string;
    }

    public List<String> getDocNames() {
        return this.docNames;
    }

    public String getDocPath() {
        return this.apiDocPathTextField.getText().trim();
    }

    public boolean shouldRememberPath() {
        return this.rememberPathCheckBox.isSelected();
    }

    public boolean shouldOverwriteDocName() {
        return this.docNameOverwrite;
    }

    private void popupEmptyPathWarning() {
        JOptionPane.showMessageDialog(View.frame, "Api Document path cannot be empty. \nPlease provide valid path.", "Invalid Path", 2);
    }

    private void popupInvalidPathWarning(String string) {
        JOptionPane.showMessageDialog(View.frame, "Could not find Api Document at: " + this.apiDocPathTextField.getText().trim() + "\nPlease provide valid path.", "Invalid Path", 2);
    }

    private void popupEmptyVersionWarning() {
        JOptionPane.showMessageDialog(View.frame, "Api version can not be empty. \nPlease provide valid version.", "Invalid Version", 2);
    }

    private void popupInvalidVersiontWarning(String string) {
        JOptionPane.showMessageDialog(View.frame, "Invalid Api version specified: " + string + "\nPlease provide valid version.", "Invalid Version", 2);
    }

    private void addControlKeyListener(JTextComponent jTextComponent) {
        jTextComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (AddNewApiDocDialog.this.doneButton.isEnabled()) {
                        AddNewApiDocDialog.this.done();
                    } else if (!AddNewApiDocDialog.this.isValidPath) {
                        String string = AddNewApiDocDialog.this.apiDocPathTextField.getText().trim();
                        if (string.isEmpty()) {
                            AddNewApiDocDialog.this.popupEmptyPathWarning();
                        } else {
                            AddNewApiDocDialog.this.popupInvalidPathWarning(string);
                        }
                    } else if (!AddNewApiDocDialog.this.isValidVersion) {
                        String string = AddNewApiDocDialog.this.apiVersionTextField.getText().trim();
                        if (string.isEmpty()) {
                            AddNewApiDocDialog.this.popupEmptyVersionWarning();
                        } else {
                            AddNewApiDocDialog.this.popupInvalidVersiontWarning(string);
                        }
                    }
                }
            }
        });
    }

    private void checkFile(String string) {
        this.doneButton.setEnabled(false);
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            this.apiDocPathTextField.setBorder(BorderFactory.createEtchedBorder(Color.GREEN, Color.LIGHT_GRAY));
            this.isValidPath = true;
            if (this.isValidVersion) {
                this.doneButton.setEnabled(true);
            }
        } else if (file.isDirectory()) {
            this.apiDocPathTextField.setBorder(BorderFactory.createEtchedBorder(Color.ORANGE, Color.YELLOW));
            this.isValidPath = false;
        } else {
            int n = file.getPath().lastIndexOf(File.separatorChar);
            if (n < 0) {
                this.isValidPath = false;
                return;
            }
            String string2 = file.getPath().substring(0, n);
            String string3 = file.getPath().substring(n + 1, file.getPath().length());
            File file2 = new File(string2);
            boolean bl = false;
            if (file2.exists() && file2.isDirectory()) {
                File[] fileArray;
                for (File file3 : fileArray = file2.listFiles()) {
                    String string4 = file3.getName();
                    if (!string4.contains(string3)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.apiDocPathTextField.setBorder(BorderFactory.createEtchedBorder(Color.ORANGE, Color.YELLOW));
            } else {
                this.apiDocPathTextField.setBorder(BorderFactory.createEtchedBorder(Color.RED, Color.PINK));
            }
            this.isValidPath = false;
        }
    }

    private void checkVersion(String string) {
        this.doneButton.setEnabled(false);
        String string2 = this.apiVersionTextField.getText().trim();
        if (string2.endsWith(".") || string2.startsWith(".") || string2.startsWith("0")) {
            this.setIncorrectVersionParameters();
            return;
        }
        String[] stringArray = string2.split("\\.");
        if (stringArray.length < 2) {
            this.setIncorrectVersionParameters();
            return;
        }
        try {
            for (String string3 : stringArray) {
                if (Integer.parseInt(string3) >= 0) continue;
                this.setIncorrectVersionParameters();
                return;
            }
            this.setCorrectVersionParameters();
            if (this.isValidPath) {
                this.doneButton.setEnabled(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setIncorrectVersionParameters();
        }
    }

    private void setIncorrectVersionParameters() {
        this.apiVersionTextField.setBorder(BorderFactory.createEtchedBorder(Color.RED, Color.PINK));
        this.isValidVersion = false;
    }

    private void setCorrectVersionParameters() {
        this.apiVersionTextField.setBorder(BorderFactory.createEtchedBorder(Color.GREEN, Color.LIGHT_GRAY));
        this.isValidVersion = true;
    }
}

