/*
 * Decompiled with CFR 0.152.
 */
package zexplore;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public final class IconMap {
    private static final HashMap<String, ImageIcon> buttonIconMap = new HashMap();

    public IconMap() {
        try {
            this.loadButtonIcons();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public final ImageIcon getIcon(String string) {
        return buttonIconMap.get(string);
    }

    public Image getImage(String string) throws FileNotFoundException {
        URL uRL = this.getClass().getResource("/img/" + string);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        return image;
    }

    private void loadButtonIcons() throws FileNotFoundException {
        buttonIconMap.put("connect", this.loadImage("lightning.png"));
        buttonIconMap.put("connected", this.loadImage("lock.png"));
        buttonIconMap.put("connected-secured", this.loadImage("lock-secured.png"));
        buttonIconMap.put("search", this.loadImage("search.png"));
        buttonIconMap.put("disconnect", this.loadImage("lightning--minus.png", 12, 12));
        buttonIconMap.put("disconnected", this.loadImage("lock-broken.png"));
        buttonIconMap.put("options", this.loadImage("gear.png"));
        buttonIconMap.put("close", this.loadImage("cross-circle.png"));
        buttonIconMap.put("nextJob", this.loadImage("control.png", 12, 12));
        buttonIconMap.put("lastJob", this.loadImage("control-180.png", 12, 12));
        buttonIconMap.put("nextNode", this.loadImage("arrow-270-medium.png"));
        buttonIconMap.put("lastNode", this.loadImage("arrow-090-medium.png"));
        buttonIconMap.put("open", this.loadImage("folder-horizontal-open.png"));
        buttonIconMap.put("copy", this.loadImage("receipts--pencil.png"));
        buttonIconMap.put("category", this.loadImage("layers.png"));
        buttonIconMap.put("api", this.loadImage("globe-small.png"));
        buttonIconMap.put("input_optional", this.loadImage("arrow-000-medium.png"));
        buttonIconMap.put("input_mandatory", this.loadImage("arrow-000-medium-red.png"));
        buttonIconMap.put("output_optional", this.loadImage("arrow-180-medium.png"));
        buttonIconMap.put("output_mandatory", this.loadImage("arrow-180-medium-red.png"));
        buttonIconMap.put("type", this.loadImage("control-stop-square-small.png"));
        buttonIconMap.put("typedef_optional", this.loadImage("tag-label.png"));
        buttonIconMap.put("typedef_mandatory", this.loadImage("tag-label-red.png"));
        buttonIconMap.put("desc", this.loadImage("sticky-note-text.png"));
        buttonIconMap.put("language", this.loadImage("script-text.png"));
        buttonIconMap.put("tick", this.loadImage("tick.png"));
        buttonIconMap.put("new", this.loadImage("add-new.png"));
        buttonIconMap.put("save", this.loadImage("disk.png"));
        buttonIconMap.put("save-all", this.loadImage("multi-disk.png"));
        buttonIconMap.put("import", this.loadImage("import.png"));
        buttonIconMap.put("export", this.loadImage("export.png"));
        buttonIconMap.put("export-path", this.loadImage("export-path.png"));
        buttonIconMap.put("exit", this.loadImage("exit.png"));
        buttonIconMap.put("execute", this.loadImage("execute.png"));
        buttonIconMap.put("right-arrow", this.loadImage("arrow-000-yellow.png"));
        buttonIconMap.put("left-arrow", this.loadImage("arrow-180-yellow.png"));
        buttonIconMap.put("up-arrow", this.loadImage("arrow-090-yellow.png"));
        buttonIconMap.put("down-arrow", this.loadImage("arrow-270-yellow.png"));
        buttonIconMap.put("certified_workflow", this.loadImage("flag-green.png"));
        buttonIconMap.put("user_workflow", this.loadImage("flag-blue.png"));
    }

    private ImageIcon loadImage(String string) throws FileNotFoundException {
        Image image = this.getImage(string);
        return new ImageIcon(image);
    }

    private ImageIcon loadImage(String string, int n, int n2) throws FileNotFoundException {
        Image image = this.getImage(string);
        return new ImageIcon(image.getScaledInstance(n, n2, 4));
    }
}

