/*
 * Decompiled with CFR 0.152.
 */
package zexplore;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingWorker;
import model.generator.ZephyrCodeGen;
import util.Base64;
import zexplore.ConnectionInfo;
import zexplore.CustomSocketFactory;
import zexplore.Job;
import zexplore.JobSpawner;
import zexplore.preferences.PreferenceConstant;
import zexplore.preferences.ZapiPreferences;

public class ExecuteJob
extends SwingWorker<Job, Void> {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String input;
    private final String connectURL;
    private final String protocol;
    private String output;
    private long executeTime;
    private String HTTPResponse;
    private final Job job;
    private final JobSpawner spawner;
    private final Vector<String> responses;
    private BufferedReader connReader;
    private DataOutputStream connWriter;
    private final boolean iteratorComprehensionEnabled;
    private final int iteratorFetchSize;

    public ExecuteJob(Job job, JobSpawner jobSpawner) {
        int n = ZapiPreferences.getInt(PreferenceConstant.EXEC_COUNT);
        ZapiPreferences.putInt(PreferenceConstant.EXEC_COUNT, ++n);
        ConnectionInfo connectionInfo = job.getConnectionInfo();
        this.host = connectionInfo.getHost();
        this.port = connectionInfo.getPort();
        this.username = connectionInfo.getUsername();
        this.password = connectionInfo.getPassword();
        this.input = job.getInput();
        this.job = job;
        this.spawner = jobSpawner;
        this.HTTPResponse = "";
        this.connectURL = connectionInfo.getConnectionType().getURL();
        this.protocol = connectionInfo.getConnectionType().getProtocol();
        this.responses = new Vector();
        this.iteratorComprehensionEnabled = ZapiPreferences.getBoolean(PreferenceConstant.ENABLE_ITERATORS);
        this.iteratorFetchSize = ZapiPreferences.getInt(PreferenceConstant.ITERATOR_FETCH_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Job doInBackground() {
        String string;
        try {
            long l = System.currentTimeMillis();
            this.setupAuthenticator();
            this.job.setSuccess(true);
            string = this.protocol + "://" + this.host + ":" + this.port + this.connectURL;
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = this.openConnection(uRL, this.protocol);
            int n = this.writeConnection(httpURLConnection, this.input);
            boolean bl = true;
            boolean bl2 = false;
            String string2 = "";
            if (n != 200) {
                System.err.println("Method failed: " + httpURLConnection.getResponseMessage());
                this.responses.add(httpURLConnection.getResponseMessage());
                bl = false;
                bl2 = true;
            } else {
                string2 = this.readConnection(httpURLConnection);
                this.HTTPResponse = this.getHTTPHeader(httpURLConnection);
                bl = ZephyrCodeGen.isResponseOk(string2);
                this.responses.add(string2);
            }
            if (bl && this.iteratorComprehensionEnabled && ZephyrCodeGen.isIterator(this.input) && ZephyrCodeGen.moreElements(string2)) {
                String string3;
                String string4 = ZephyrCodeGen.getTag(string2);
                do {
                    if ((n = this.writeConnection(httpURLConnection = this.openConnection(uRL, this.protocol), string3 = ZephyrCodeGen.createNextPayload(this.input, string4, this.iteratorFetchSize))) != 200) {
                        System.err.println("Method failed: " + httpURLConnection.getResponseMessage());
                        bl2 = true;
                        string2 = httpURLConnection.getResponseMessage();
                        this.responses.add(string2);
                        continue;
                    }
                    string2 = this.readConnection(httpURLConnection);
                    this.responses.add(string2);
                } while (ZephyrCodeGen.moreElements(string2));
                string3 = ZephyrCodeGen.createEndPayload(this.input, string4);
                httpURLConnection = this.openConnection(uRL, this.protocol);
                n = this.writeConnection(httpURLConnection, string3);
                if (n != 200) {
                    System.err.println("Method failed: " + httpURLConnection.getResponseMessage());
                    bl2 = true;
                    this.responses.add(httpURLConnection.getResponseMessage());
                } else {
                    string2 = this.readConnection(httpURLConnection);
                    this.responses.add(string2);
                }
            }
            httpURLConnection.disconnect();
            long l2 = System.currentTimeMillis();
            this.executeTime = l2 - l;
            if (!bl2) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string5 : this.responses) {
                    if (ZapiPreferences.getBoolean(PreferenceConstant.FORMAT_OUTPUT)) {
                        stringBuffer.append(ZephyrCodeGen.beautifyXML(string5));
                        continue;
                    }
                    stringBuffer.append(string5);
                }
                this.output = stringBuffer.toString().trim();
            }
            this.output = this.responses.lastElement();
            return this.output;
        }
        catch (Throwable throwable) {
            this.job.setSuccess(false);
            this.output = "Fatal protocol violation: " + throwable.getMessage();
            System.err.println(this.output);
        }
        finally {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            string = simpleDateFormat.format(date);
            this.job.setOutput(this.output);
            this.job.setEndTime(string);
            this.job.setExecuteTime(this.executeTime);
            this.job.setHTTPHeader(this.HTTPResponse.trim());
            return this.job;
        }
    }

    @Override
    protected void done() {
        try {
            Job job = (Job)this.get();
            this.spawner.jobComplete(job);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
    }

    private String getHTTPHeader(URLConnection uRLConnection) {
        String string = "";
        Map<String, List<String>> map = uRLConnection.getHeaderFields();
        Set<String> set = map.keySet();
        for (String string2 : set) {
            List<String> list = map.get(string2);
            if (string2 != null) {
                string = string + string2;
            }
            for (String string3 : list) {
                if (string2 != null) {
                    string = string + "  ";
                }
                string = string + string3;
            }
            string = string + "\n";
        }
        return string;
    }

    private HttpURLConnection openConnection(URL uRL, String string) throws Exception {
        if (string.equals("http")) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string2 = this.username + ":" + this.password;
            httpURLConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(string2.getBytes()));
            return httpURLConnection;
        }
        if (string.equals("https")) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            String string3 = this.username + ":" + this.password;
            httpsURLConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(string3.getBytes()));
            httpsURLConnection.setHostnameVerifier(new VerifyEverythingHostnameVerifier());
            return httpsURLConnection;
        }
        throw new Exception("invalid protocol specified: " + string);
    }

    private int writeConnection(HttpURLConnection httpURLConnection, String string) throws IOException {
        httpURLConnection.setDoOutput(true);
        this.connWriter = new DataOutputStream(httpURLConnection.getOutputStream());
        this.connWriter.writeBytes(string);
        return httpURLConnection.getResponseCode();
    }

    private String readConnection(HttpURLConnection httpURLConnection) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        this.connReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string = this.connReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }

    private void setupAuthenticator() {
        TrustManager[] trustManagerArray = new TrustManager[]{new TrustEverythingTrustManager()};
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(new CustomSocketFactory(sSLContext));
    }

    public class VerifyEverythingHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }

    public class TrustEverythingTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }
}

