/*
 * Decompiled with CFR 0.152.
 */
package model.validator.rules;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.ZephyrDesc;
import model.ZephyrDescList;
import model.ZephyrKeyword;
import model.validator.ErrorMessage;
import model.validator.MessageType;
import model.validator.ValidatorMessage;

public class AbstractRule {
    static final Pattern DESC_RANGE_PATTERN = Pattern.compile("Range\\s*:\\s*(\\[[^\\]]+\\])");
    static final Pattern PARSE_RANGE_PATTERN = Pattern.compile("(?:^|\\[)(\\-?(?:\\d+|2\\^\\d+(?:-1)?))\\s*(?:-|\\.\\.)\\s*(\\-?(?:\\d+|2\\^\\d+(?:-1)?))(?:\\]|$)");
    static final Pattern PARSE_RANGE_ARG = Pattern.compile("(-?\\d+)|(-)?2\\^(\\d+)(-1)?");
    static final int PARSE_RANGE_LITERAL_GROUP = 1;
    static final int PARSE_RANGE_EXP_NEGATE_GROUP = 2;
    static final int PARSE_RANGE_EXP_GROUP = 3;
    static final int PARSE_RANGE_EXP_MIN_ONE_GROUP = 4;

    void checkParam(ZephyrDesc zephyrDesc, List<ValidatorMessage> list) {
        Object object;
        Object object2;
        Object object3;
        ZephyrDescList zephyrDescList = zephyrDesc.getChildren(ZephyrKeyword.DESC);
        boolean bl = true;
        for (Serializable serializable : zephyrDescList) {
            object3 = DESC_RANGE_PATTERN.matcher(((ZephyrDesc)serializable).getValue());
            if (((Matcher)object3).find()) {
                object2 = ((Matcher)object3).group(1);
                object = PARSE_RANGE_PATTERN.matcher((CharSequence)object2);
                if (((Matcher)object).matches()) continue;
                list.add(new ErrorMessage((ZephyrDesc)serializable, MessageType.RANGE_INCORRECTLY_FORMATTED, new Object[0]));
                continue;
            }
            bl = false;
        }
        boolean bl2 = true;
        if (!bl) {
            Serializable serializable;
            serializable = zephyrDesc.getChildren(ZephyrKeyword.TYPE);
            if (serializable.size() < 1) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_TYPE, zephyrDesc.getValue()));
            } else if (serializable.size() > 1) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MULTIPLE_TYPES, zephyrDesc.getValue()));
            } else {
                object3 = (ZephyrDesc)serializable.get(0);
                object2 = ((ZephyrDesc)object3).getChildren(ZephyrKeyword.RANGE);
                if (object2.size() < 1) {
                    bl2 = false;
                } else if (object2.size() > 1) {
                    list.add(new ErrorMessage(zephyrDesc, MessageType.MULTIPLE_RANGES, new Object[0]));
                } else {
                    object = (ZephyrDesc)object2.get(0);
                    Matcher matcher = PARSE_RANGE_PATTERN.matcher(((ZephyrDesc)object).getValue());
                    if (!matcher.matches()) {
                        list.add(new ErrorMessage((ZephyrDesc)object, MessageType.RANGE_INCORRECTLY_FORMATTED, new Object[0]));
                    }
                }
            }
        }
        if (!bl2 && !bl) {
            list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_RANGE, new Object[0]));
        }
    }
}

