/*
 * Decompiled with CFR 0.152.
 */
package model.validator;

import java.util.ArrayList;
import java.util.List;
import model.Visitor;
import model.ZephyrDesc;
import model.validator.ValidatorMessage;
import model.validator.rules.ApiRule;
import model.validator.rules.EmptyNodeRule;
import model.validator.rules.ErrorRule;
import model.validator.rules.FamilyRule;
import model.validator.rules.Rule;
import model.validator.rules.TypedefRule;

public class CoreValidator {
    private static final int PASS_COUNT = 2;

    public List<ValidatorMessage> check(ZephyrDesc zephyrDesc) {
        final Rule[] ruleArray = new Rule[]{new EmptyNodeRule(), new TypedefRule(), new ApiRule(), new FamilyRule(), new ErrorRule()};
        final ArrayList<ValidatorMessage> arrayList = new ArrayList<ValidatorMessage>();
        final int[] nArray = new int[]{1};
        while (nArray[0] <= 2) {
            zephyrDesc.visit(new Visitor(){

                @Override
                public void visit(ZephyrDesc zephyrDesc, int n) {
                    for (Rule rule : ruleArray) {
                        rule.check(arrayList, zephyrDesc, nArray[0]);
                    }
                }
            });
            nArray[0] = nArray[0] + 1;
        }
        return arrayList;
    }
}

