/*
 * Decompiled with CFR 0.152.
 */
package model.generator;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.ZephyrDesc;
import model.ZephyrDescList;
import model.ZephyrKeyword;
import model.generator.ArrayParam;
import model.generator.Generator;
import model.generator.Param;
import model.generator.ParameterType;
import model.generator.SimpleParam;
import model.generator.TypeParam;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.util.XMLErrorHandler;
import org.xml.sax.SAXException;

public class ZephyrCodeGen {
    public static String generateCode(Generator generator, ZephyrDesc zephyrDesc, ZephyrDesc zephyrDesc2, boolean bl, boolean bl2) throws Exception {
        Map<String, ZephyrDesc> map = ZephyrCodeGen.cacheTypeDefs(zephyrDesc);
        String string = zephyrDesc2.getValue();
        String string2 = zephyrDesc2.getChildValue(ZephyrKeyword.DESC);
        Object object = generator.beginOutput();
        ZephyrDescList zephyrDescList = zephyrDesc2.getChildren(ZephyrKeyword.INPUT);
        List<Param> list = ZephyrCodeGen.generateParams(zephyrDescList, bl2, map);
        boolean bl3 = generator.isSingleLineMode(list);
        Object object2 = generator.beginAPI(object, string, string2, bl);
        if (bl3) {
            generator.addParameters(list);
        } else if (zephyrDescList != null) {
            for (ZephyrDesc zephyrDesc3 : zephyrDescList) {
                ZephyrCodeGen.addParameter(generator, zephyrDesc2, object2, string, zephyrDesc3, bl, bl2, map);
            }
        }
        generator.endAPI(object);
        generator.endOutput(object);
        return generator.generateText(object);
    }

    private static List<Param> generateParams(List<ZephyrDesc> list, boolean bl, Map<String, ZephyrDesc> map) {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        if (list != null) {
            for (ZephyrDesc zephyrDesc : list) {
                boolean bl2;
                ZephyrDescList zephyrDescList = zephyrDesc.getChildren(ZephyrKeyword.OPTIONAL);
                boolean bl3 = bl2 = zephyrDescList != null && !zephyrDescList.isEmpty();
                if (bl2 && (!bl2 || !bl)) continue;
                ZephyrCodeGen.buildParam(arrayList, zephyrDesc, bl, map);
            }
        }
        return arrayList;
    }

    private static void buildParam(List<Param> list, ZephyrDesc zephyrDesc, boolean bl, Map<String, ZephyrDesc> map) {
        ParameterType parameterType;
        String string = zephyrDesc.getChildValue(ZephyrKeyword.TYPE);
        string = string.trim();
        boolean bl2 = false;
        if (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            bl2 = true;
        }
        if ((parameterType = ParameterType.getParameterType(string)) != ParameterType.TYPEDEF) {
            list.add(new SimpleParam(zephyrDesc.getValue(), parameterType.getSampleValue()));
        } else {
            ZephyrDescList zephyrDescList;
            Object object;
            if (bl2) {
                object = new ArrayParam(zephyrDesc.getValue(), zephyrDesc.getParent().getValue());
                list.add((Param)object);
                list = ((TypeParam)object).params;
            }
            if ((zephyrDescList = ((ZephyrDesc)(object = map.get(string))).getChildren(ZephyrKeyword.ELEMENT)) == null || zephyrDescList.size() == 0) {
                ZephyrCodeGen.addSimpleAlias(list, zephyrDesc, ((ZephyrDesc)object).getChildValue(ZephyrKeyword.TYPE));
            } else {
                TypeParam typeParam = new TypeParam(zephyrDesc.getValue(), zephyrDesc.getParent().getValue());
                list.add(typeParam);
                TypeParam typeParam2 = new TypeParam(string, zephyrDesc.getParent().getValue());
                typeParam.params.add(typeParam2);
                list = typeParam2.params;
                for (ZephyrDesc zephyrDesc2 : zephyrDescList) {
                    ZephyrCodeGen.buildParam(list, zephyrDesc2, bl, map);
                }
            }
        }
    }

    private static void addSimpleAlias(List<Param> list, ZephyrDesc zephyrDesc, String string) {
        ParameterType parameterType;
        if ((string = string.trim()).endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
        }
        if ((parameterType = ParameterType.getParameterType(string)) != ParameterType.TYPEDEF) {
            list.add(new SimpleParam(zephyrDesc.getValue(), parameterType.getSampleValue()));
        }
    }

    private static void addParameter(Generator generator, ZephyrDesc zephyrDesc, Object object, String string, ZephyrDesc zephyrDesc2, boolean bl, boolean bl2, Map<String, ZephyrDesc> map) throws Exception {
        boolean bl3;
        ZephyrDescList zephyrDescList = zephyrDesc2.getChildren(ZephyrKeyword.OPTIONAL);
        boolean bl4 = bl3 = zephyrDescList != null && !zephyrDescList.isEmpty();
        if (!bl3 || bl3 && bl2) {
            ParameterType parameterType;
            if (bl) {
                generator.addComment(object, zephyrDesc2.getChildValue(ZephyrKeyword.DESC));
            }
            String string2 = zephyrDesc2.getChildValue(ZephyrKeyword.TYPE);
            string2 = string2.trim();
            boolean bl5 = false;
            if (string2.endsWith("[]")) {
                string2 = string2.substring(0, string2.length() - 2);
                bl5 = true;
            }
            if ((parameterType = ParameterType.getParameterType(string2)) != ParameterType.TYPEDEF) {
                generator.addSimpleParameter(object, zephyrDesc2.getValue(), parameterType.getSampleValue());
            } else {
                ZephyrDesc zephyrDesc3 = map.get(string2);
                String string3 = zephyrDesc3.getChildValue(ZephyrKeyword.TYPE);
                if (string3 != null && (string3.equals("string") || string3.equals("integer") || string3.equals("boolean"))) {
                    parameterType = ParameterType.getParameterType(string3);
                    generator.addSimpleParameter(object, zephyrDesc2.getValue(), parameterType.getSampleValue());
                } else {
                    Object object2 = generator.addTypeParameter(object, zephyrDesc2.getValue());
                    ZephyrCodeGen.addTypeElement(generator, zephyrDesc, object2, string, string2, bl5, zephyrDesc2, bl, bl2, map);
                }
            }
        }
    }

    private static void addTypeElement(Generator generator, ZephyrDesc zephyrDesc, Object object, String string, String string2, boolean bl, ZephyrDesc zephyrDesc2, boolean bl2, boolean bl3, Map<String, ZephyrDesc> map) throws Exception {
        ZephyrDesc zephyrDesc3 = map.get(string2);
        ZephyrDescList zephyrDescList = zephyrDesc3.getChildren(ZephyrKeyword.ELEMENT);
        if (zephyrDescList == null || zephyrDescList.size() == 0) {
            ZephyrCodeGen.addParameter(generator, zephyrDesc, object, string, zephyrDesc3, bl2, bl3, map);
        } else {
            object = generator.addTypeParameter(object, string2);
            for (ZephyrDesc zephyrDesc4 : zephyrDescList) {
                ZephyrCodeGen.addParameter(generator, zephyrDesc, object, string, zephyrDesc4, bl2, bl3, map);
            }
        }
    }

    private static Map<String, ZephyrDesc> cacheTypeDefs(ZephyrDesc zephyrDesc) {
        HashMap<String, ZephyrDesc> hashMap = new HashMap<String, ZephyrDesc>();
        ZephyrCodeGen.getTypeDefs(zephyrDesc, 0, hashMap);
        return hashMap;
    }

    public static void getTypeDefs(ZephyrDesc zephyrDesc, int n, Map<String, ZephyrDesc> map) {
        if (zephyrDesc.getKeyword() == ZephyrKeyword.TYPEDEF) {
            map.put(zephyrDesc.getValue(), zephyrDesc);
        }
        ZephyrDescList zephyrDescList = zephyrDesc.getChildren();
        for (ZephyrDesc zephyrDesc2 : zephyrDescList) {
            ZephyrCodeGen.getTypeDefs(zephyrDesc2, n + 1, map);
        }
    }

    public static String beautifyXML(String string) throws IOException, DocumentException, SAXException {
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter(stringWriter, OutputFormat.createPrettyPrint());
        xMLWriter.write(document);
        xMLWriter.flush();
        return stringWriter.toString();
    }

    public static Document parseNonvalidating(String string) throws SAXException, DocumentException {
        SAXReader sAXReader = new SAXReader();
        string = string.replace("xmlns='http://www.netapp.com/filer/admin'", "");
        String string2 = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        sAXReader.setFeature(string2, false);
        XMLErrorHandler xMLErrorHandler = new XMLErrorHandler();
        sAXReader.setErrorHandler(xMLErrorHandler);
        StringReader stringReader = new StringReader(string);
        return sAXReader.read(stringReader);
    }

    public static String createNextPayload(String string, String string2, int n) throws SAXException, DocumentException {
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        Element element = (Element)document.getRootElement().elements().get(0);
        String string3 = element.getName().replace("-start", "-next");
        Namespace namespace = DocumentHelper.createNamespace("", "http://www.netapp.com/filer/admin");
        QName qName = DocumentHelper.createQName("netapp", namespace);
        Document document2 = DocumentHelper.createDocument();
        Element element2 = document2.addElement(qName);
        element2.addAttribute("version", "1.0");
        Element element3 = element2.addElement(string3);
        Element element4 = element3.addElement("maximum");
        element4.setText("" + n);
        Element element5 = element3.addElement("tag");
        element5.setText(string2);
        return document2.asXML();
    }

    public static boolean isIterator(String string) throws SAXException, DocumentException {
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        Element element = (Element)document.getRootElement().elements().get(0);
        return element.getName().endsWith("-iter-start");
    }

    public static String getTag(String string) throws Exception {
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        Element element = document.getRootElement().element("results").element("tag");
        if (element != null) {
            return element.getTextTrim();
        }
        throw new Exception("tag not found in response payload");
    }

    public static boolean isResponseOk(String string) throws Exception {
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        Element element = document.getRootElement().element("results");
        if (element != null) {
            return element.attributeValue("status").equals("passed");
        }
        return false;
    }

    public static boolean moreElements(String string) throws Exception {
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        Element element = document.getRootElement().element("results").element("records");
        if (element != null) {
            return !element.getTextTrim().equals("0");
        }
        return false;
    }

    public static String createEndPayload(String string, String string2) throws SAXException, DocumentException {
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        Element element = (Element)document.getRootElement().elements().get(0);
        String string3 = element.getName().replace("-start", "-end");
        Namespace namespace = DocumentHelper.createNamespace("", "http://www.netapp.com/filer/admin");
        QName qName = DocumentHelper.createQName("netapp", namespace);
        Document document2 = DocumentHelper.createDocument();
        Element element2 = document2.addElement(qName);
        element2.addAttribute("version", "1.0");
        Element element3 = element2.addElement(string3);
        Element element4 = element3.addElement("tag");
        element4.setText(string2);
        return document2.asXML();
    }
}

