/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import model.ZephyrDesc;
import model.ZephyrDescList;
import model.ZephyrKeyword;
import model.validator.ErrorMessage;
import model.validator.MessageType;
import model.validator.ValidatorMessage;

public class ZephyrDocReader {
    private List<ValidatorMessage> msgs = new ArrayList<ValidatorMessage>();
    private String filename;
    private String ontapiVersion;
    private int currentLine;
    private BufferedReader reader;
    private ZephyrDesc root;
    private File file;
    private List<ZephyrDesc> apiList;

    public ZephyrDocReader(String string) {
        this.filename = string;
    }

    public ZephyrDocReader(File file) {
        this.file = file;
    }

    public ZephyrDocReader(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setOntapiVersion(String string) {
        this.ontapiVersion = string;
    }

    public void parseInput() throws FileNotFoundException, IOException, IllegalArgumentException {
        Object object9;
        Object object22;
        Iterator iterator;
        Object object32;
        Object object42;
        ZephyrDesc zephyrDesc5;
        Object object5;
        this.msgs.clear();
        this.currentLine = 0;
        this.apiList = new ArrayList<ZephyrDesc>();
        if (this.reader == null) {
            if (this.file == null) {
                this.file = new File(this.filename);
                object5 = new FileReader(this.file);
                this.reader = new BufferedReader((Reader)object5);
            } else {
                this.reader = new BufferedReader(new FileReader(this.file));
            }
        }
        this.root = new ZephyrDesc(ZephyrKeyword.ROOT, this.currentLine, new ZephyrKeyword[0]);
        this.fillZephyrElement(this.root);
        object5 = new ZephyrDesc(ZephyrKeyword.ROOT, this.currentLine, new ZephyrKeyword[0]);
        ZephyrDesc zephyrDesc2 = null;
        ZephyrDesc zephyrDesc3 = null;
        ZephyrDesc zephyrDesc4 = null;
        ZephyrKeyword zephyrKeyword = null;
        for (ZephyrDesc zephyrDesc5 : this.root.getChildren()) {
            if (zephyrDesc5.getKeyword() == ZephyrKeyword.CATEGORY) {
                zephyrDesc2 = zephyrDesc5;
                zephyrKeyword = ZephyrKeyword.CATEGORY;
                continue;
            }
            if (zephyrDesc5.getKeyword() == ZephyrKeyword.API) {
                zephyrDesc3 = zephyrDesc5;
                zephyrKeyword = ZephyrKeyword.API;
                zephyrDesc2.addChild(zephyrDesc5);
                continue;
            }
            if (zephyrDesc5.getKeyword() == ZephyrKeyword.ELEMENT) {
                if (zephyrKeyword != ZephyrKeyword.API) continue;
                zephyrDesc4 = zephyrDesc5;
                zephyrKeyword = ZephyrKeyword.ELEMENT;
                zephyrDesc3.addChild(zephyrDesc5);
                continue;
            }
            if (zephyrDesc5.getKeyword() != ZephyrKeyword.RANGE || zephyrKeyword != ZephyrKeyword.ELEMENT) continue;
            zephyrKeyword = ZephyrKeyword.RANGE;
            zephyrDesc4.addChild(zephyrDesc5);
        }
        Object object6 = this.root.getChildren(ZephyrKeyword.CATEGORY);
        Collections.sort(object6);
        zephyrDesc5 = new ZephyrDesc(ZephyrKeyword.CATEGORY, 1, ZephyrKeyword.TYPEDEF);
        zephyrDesc5.setValue("Typedefs");
        ZephyrDescList zephyrDescList = this.root.getChildren(ZephyrKeyword.TYPEDEF);
        for (Object object42 : zephyrDescList) {
            zephyrDesc5.addChild((ZephyrDesc)object42);
            this.root.getChildren().remove(object42);
        }
        Object object7 = ((AbstractSequentialList)object6).iterator();
        while (object7.hasNext()) {
            object42 = (ZephyrDesc)object7.next();
            zephyrDescList = ((ZephyrDesc)object42).getChildren(ZephyrKeyword.TYPEDEF);
            for (Object object32 : zephyrDescList) {
                zephyrDesc5.addChild((ZephyrDesc)object32);
                ((ZephyrDesc)object42).getChildren().remove(object32);
            }
            ZephyrDescList zephyrDescList2 = ((ZephyrDesc)object42).getChildren(ZephyrKeyword.API);
            object32 = zephyrDescList2.iterator();
            while (object32.hasNext()) {
                iterator = (ZephyrDesc)object32.next();
                zephyrDescList = ((ZephyrDesc)((Object)iterator)).getChildren(ZephyrKeyword.TYPEDEF);
                for (Object object22 : zephyrDescList) {
                    zephyrDesc5.addChild((ZephyrDesc)object22);
                    ((ZephyrDesc)((Object)iterator)).getChildren().remove(object22);
                }
                object9 = ((ZephyrDesc)((Object)iterator)).getChildren();
                object22 = ((AbstractSequentialList)object9).iterator();
                while (object22.hasNext()) {
                    ZephyrDesc zephyrDesc6 = (ZephyrDesc)object22.next();
                    zephyrDescList = zephyrDesc6.getChildren(ZephyrKeyword.TYPEDEF);
                    for (Object object8 : zephyrDescList) {
                        zephyrDesc5.addChild((ZephyrDesc)object8);
                        zephyrDesc6.getChildren().remove(object8);
                    }
                }
            }
        }
        zephyrDescList = zephyrDesc5.getChildren();
        Collections.sort(zephyrDescList);
        zephyrDesc5.setChildren(zephyrDescList);
        object7 = ((AbstractSequentialList)object6).iterator();
        while (object7.hasNext()) {
            object42 = (ZephyrDesc)object7.next();
            int n = 0;
            object32 = new ZephyrDescList();
            for (Object object9 : ((ZephyrDesc)object42).getChildren()) {
                if (((ZephyrDesc)object9).getKeyword() == ZephyrKeyword.API) {
                    object22 = ((ZephyrDesc)((ZephyrDesc)object9).getChildren(ZephyrKeyword.STATUS).getFirst()).toString();
                    if (((String)object22).equals("unsupported") || ((String)object22).equals("debug") || ((String)object22).equals("internal") || ((String)object22).equals("test")) continue;
                    if (((ZephyrDesc)object9).getChildren(ZephyrKeyword.FAMILY).isEmpty() && !this.filename.contains("cluster")) {
                        ((LinkedList)object32).add(object9);
                        ++n;
                    }
                    for (Object object10 : ((ZephyrDesc)object9).getChildren(ZephyrKeyword.FAMILY)) {
                        Object object112;
                        Object object8;
                        object8 = ((ZephyrDesc)object10).toString();
                        if (this.ontapiVersion.contains("Vserver") && ((String)object8).contains("ontap-vserver")) {
                            ((LinkedList)object32).add(object9);
                            ++n;
                        } else if (this.filename.contains("cluster") && !this.ontapiVersion.contains("Vserver") && ((String)object8).contains("ontap-cluster")) {
                            ((LinkedList)object32).add(object9);
                            ++n;
                        } else if (!this.filename.contains("cluster") && (((String)object8).contains("ontap-c") || ((String)object8).contains("vfiler") || ((String)object8).contains("filer"))) {
                            ((LinkedList)object32).add(object9);
                            ++n;
                        }
                        object8 = ((String)object8).replaceAll("ontap-d", "");
                        if (((String)object8).startsWith(",")) {
                            object8 = ((String)object8).replaceFirst(",", "");
                        }
                        ((ZephyrDesc)object10).setValue((String)object8);
                        ZephyrDescList zephyrDescList3 = ((ZephyrDesc)object9).getChildren(ZephyrKeyword.NAMESPACE);
                        for (Object object112 : zephyrDescList3) {
                            if (!((ZephyrDesc)object112).getValue().equals("netcache") || !((LinkedList)object32).remove(object9)) continue;
                            --n;
                        }
                        ZephyrDescList zephyrDescList4 = ((ZephyrDesc)object9).getChildren(ZephyrKeyword.DOMAIN);
                        object112 = zephyrDescList4.iterator();
                        while (object112.hasNext()) {
                            ZephyrDesc zephyrDesc7 = (ZephyrDesc)object112.next();
                            if (!zephyrDesc7.getValue().equals("netcache") || !((LinkedList)object32).remove(object9)) continue;
                            --n;
                        }
                    }
                    continue;
                }
                if (((ZephyrDesc)object9).getKeyword() != ZephyrKeyword.SYNOPSIS && ((ZephyrDesc)object9).getKeyword() != ZephyrKeyword.DISCUSSION) continue;
                ((LinkedList)object32).add(object9);
            }
            if (n <= 0) continue;
            ((ZephyrDesc)object42).setChildren((ZephyrDescList)object32);
            ((ZephyrDesc)object5).addChild((ZephyrDesc)object42);
        }
        this.root = object5;
        this.root.addChild(zephyrDesc5);
        object7 = new ZephyrDesc(ZephyrKeyword.ERRDEFS, 1, ZephyrKeyword.ERRDEF);
        ((ZephyrDesc)object7).setValue("Error Definitions");
        this.root.addChild((ZephyrDesc)object7);
        object6 = this.root.getChildren(ZephyrKeyword.CATEGORY);
        object42 = ((AbstractSequentialList)object6).iterator();
        while (object42.hasNext()) {
            ZephyrDesc zephyrDesc8 = (ZephyrDesc)object42.next();
            object32 = zephyrDesc8.getChildren(ZephyrKeyword.ERRDEF);
            iterator = ((AbstractSequentialList)object32).iterator();
            while (iterator.hasNext()) {
                object9 = (ZephyrDesc)iterator.next();
                zephyrDesc8.getChildren().remove(object9);
                ((ZephyrDesc)object7).addChild((ZephyrDesc)object9);
            }
        }
    }

    public ZephyrDesc getRoot() {
        return this.root;
    }

    public void print(PrintStream printStream) {
        this.print(printStream, this.getRoot(), "");
    }

    protected String getLineError(String string) {
        return "Error on line " + this.currentLine + ": " + string;
    }

    protected void print(PrintStream printStream, ZephyrDesc zephyrDesc, String string) {
        ZephyrKeyword zephyrKeyword = zephyrDesc.getKeyword();
        String string2 = zephyrDesc.getValue();
        printStream.println(string + "@" + zephyrKeyword.toString().toLowerCase() + " " + string2);
        ZephyrDescList zephyrDescList = zephyrDesc.getChildren();
        for (ZephyrDesc zephyrDesc2 : zephyrDescList) {
            this.print(printStream, zephyrDesc2, string + "    ");
        }
    }

    protected ZephyrDesc createZephyrDesc(ZephyrKeyword zephyrKeyword, String string) {
        ZephyrDesc zephyrDesc = null;
        switch (zephyrKeyword) {
            case DESC: 
            case DISCUSSION: 
            case ERRNO: 
            case ERRNUM: 
            case NAMESPACE: 
            case STATUS: 
            case SYNOPSIS: 
            case VFILER: 
            case FAMILY: 
            case STREAMING: 
            case JAVA: 
            case LICENSE: 
            case DOMAIN: 
            case ATTRIBUTE: 
            case VERSION: 
            case TEST: 
            case ENCRYPTED: 
            case OPTIONAL: 
            case VALIDATE: 
            case READONLY: 
            case RANGE: 
            case DOC: 
            case SCOPE: 
            case NONEMPTY: {
                zephyrDesc = new ZephyrDesc(zephyrKeyword, this.currentLine, new ZephyrKeyword[0]);
                break;
            }
            case API: {
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.API, this.currentLine, ZephyrKeyword.ERRNO, ZephyrKeyword.DESC, ZephyrKeyword.STATUS, ZephyrKeyword.NAMESPACE, ZephyrKeyword.INPUT, ZephyrKeyword.OUTPUT, ZephyrKeyword.ELEMENT, ZephyrKeyword.TYPEDEF, ZephyrKeyword.DOMAIN, ZephyrKeyword.VERSION, ZephyrKeyword.STREAMING, ZephyrKeyword.VFILER, ZephyrKeyword.ATTRIBUTE, ZephyrKeyword.JAVA, ZephyrKeyword.TEST, ZephyrKeyword.LICENSE, ZephyrKeyword.FAMILY, ZephyrKeyword.READONLY);
                break;
            }
            case TYPE: {
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.TYPE, this.currentLine, ZephyrKeyword.RANGE);
                break;
            }
            case CATEGORY: {
                for (ZephyrDesc zephyrDesc2 : this.root.getChildren()) {
                    if (zephyrDesc2.getKeyword() != ZephyrKeyword.CATEGORY || !zephyrDesc2.getValue().equals(string)) continue;
                    this.msgs.add(new ErrorMessage(zephyrDesc2, MessageType.DUPLICATE_CATEGORY, string));
                    return zephyrDesc2;
                }
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.CATEGORY, this.currentLine, ZephyrKeyword.SYNOPSIS, ZephyrKeyword.DISCUSSION, ZephyrKeyword.API, ZephyrKeyword.TYPEDEF, ZephyrKeyword.ERRDEF);
                break;
            }
            case ELEMENT: {
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.ELEMENT, this.currentLine, ZephyrKeyword.TYPE, ZephyrKeyword.DESC, ZephyrKeyword.OPTIONAL, ZephyrKeyword.ENCRYPTED, ZephyrKeyword.VALIDATE, ZephyrKeyword.NONEMPTY, ZephyrKeyword.SCOPE);
                break;
            }
            case INPUT: {
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.INPUT, this.currentLine, ZephyrKeyword.TYPE, ZephyrKeyword.DESC, ZephyrKeyword.OPTIONAL, ZephyrKeyword.ENCRYPTED, ZephyrKeyword.DOC, ZephyrKeyword.RANGE, ZephyrKeyword.VALIDATE, ZephyrKeyword.NONEMPTY, ZephyrKeyword.SCOPE);
                break;
            }
            case OUTPUT: {
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.OUTPUT, this.currentLine, ZephyrKeyword.TYPE, ZephyrKeyword.DESC, ZephyrKeyword.OPTIONAL, ZephyrKeyword.ENCRYPTED, ZephyrKeyword.RANGE, ZephyrKeyword.VALIDATE, ZephyrKeyword.SCOPE);
                break;
            }
            case TYPEDEF: {
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.TYPEDEF, this.currentLine, ZephyrKeyword.TYPE, ZephyrKeyword.DESC, ZephyrKeyword.ELEMENT, ZephyrKeyword.OPTIONAL, ZephyrKeyword.NAMESPACE, ZephyrKeyword.VALIDATE, ZephyrKeyword.SCOPE);
                break;
            }
            case ERRDEF: {
                zephyrDesc = new ZephyrDesc(ZephyrKeyword.ERRDEF, this.currentLine, ZephyrKeyword.DESC, ZephyrKeyword.ERRNUM);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getLineError("unsupported keyword: " + (Object)((Object)zephyrKeyword)));
            }
        }
        if (zephyrDesc != null) {
            zephyrDesc.appendValue(string);
        }
        return zephyrDesc;
    }

    /*
     * Unable to fully structure code
     */
    private ZephyrDesc fillZephyrElement(ZephyrDesc var1_1) throws IOException {
        v0 = var2_2 = var1_1.getKeyword() != ZephyrKeyword.ROOT;
        block0: while (true) {
            if ((var3_3 = this.readLine()) == null) {
                return null;
            }
            var4_4 = this.parseLine(var3_3);
            if (var4_4 == null) {
                if (var3_3.startsWith("@")) {
                    this.msgs.add(new ErrorMessage(var1_1, MessageType.UNKNOWN_ELEMENT, new Object[]{var3_3}));
                    var2_2 = false;
                } else if (var3_3.startsWith("*") && var3_3.endsWith("*/")) {
                    var2_2 = false;
                }
                if (!var2_2 || var3_3.length() <= 0) continue;
                var1_1.appendValue(" " + var3_3);
                continue;
            }
            while (true) {
                if (var4_4 != null) ** break;
                continue block0;
                if (!var1_1.isValidChild(var4_4)) {
                    return var4_4;
                }
                if (var4_4.getKeyword() != ZephyrKeyword.CATEGORY || !var1_1.getChildren().contains(var4_4)) {
                    var1_1.addChild(var4_4);
                }
                if (var4_4.getKeyword() == ZephyrKeyword.API) {
                    this.apiList.add(var4_4);
                }
                if (var4_4.getKeyword() == ZephyrKeyword.TEST) {
                    var1_1.removeChild(var4_4);
                }
                if (var4_4.getKeyword() == ZephyrKeyword.READONLY) {
                    var1_1.removeChild(var4_4);
                }
                if (var4_4.getKeyword() == ZephyrKeyword.TYPE && (var6_6 = (var5_5 = var4_4.getValue()).split(",")).length > 1) {
                    var7_7 = var6_6[0].trim();
                    var4_4.setValue(var7_7);
                    for (var8_8 = 1; var8_8 < var6_6.length; ++var8_8) {
                        if (var6_6[var8_8].trim().equalsIgnoreCase("optional")) {
                            var1_1.addChild(this.createZephyrDesc(ZephyrKeyword.OPTIONAL, ""));
                            continue;
                        }
                        if (var6_6[var8_8].trim().equalsIgnoreCase("encrypted")) {
                            var1_1.addChild(this.createZephyrDesc(ZephyrKeyword.ENCRYPTED, ""));
                            continue;
                        }
                        if (var6_6[var8_8].trim().equalsIgnoreCase("validate")) {
                            var1_1.addChild(this.createZephyrDesc(ZephyrKeyword.VALIDATE, ""));
                            continue;
                        }
                        if (var6_6[var8_8].trim().equalsIgnoreCase("nonempty")) {
                            var1_1.addChild(this.createZephyrDesc(ZephyrKeyword.NONEMPTY, ""));
                            continue;
                        }
                        this.msgs.add(new ErrorMessage(var4_4, MessageType.UNKNOWN_MODIFIER, new Object[]{var6_6[var8_8].trim()}));
                    }
                }
                if (var4_4.getKeyword() == ZephyrKeyword.ERRDEF && (var6_6 = (var5_5 = var4_4.getValue()).split("\\s+")).length > 1) {
                    var4_4.setValue(var6_6[0].trim());
                    var4_4.addChild(this.createZephyrDesc(ZephyrKeyword.ERRNUM, var6_6[1].trim()));
                }
                var4_4 = this.fillZephyrElement(var4_4);
            }
            break;
        }
    }

    private ZephyrDesc parseLine(String string) {
        if (string.startsWith("@")) {
            String[] stringArray = this.split(string);
            try {
                ZephyrKeyword zephyrKeyword = ZephyrKeyword.valueOf(stringArray[0].toUpperCase());
                return this.createZephyrDesc(zephyrKeyword, stringArray[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private String[] split(String string) {
        int n = string.indexOf(32);
        int n2 = string.indexOf(9);
        int n3 = n;
        if (n < 0) {
            n3 = n2;
        } else if (n2 < 0) {
            n3 = n;
        } else if (n > n2) {
            n3 = n2;
        }
        String string2 = "";
        String string3 = "";
        if (n3 > -1) {
            string2 = string.substring(1, n3);
            string3 = string.substring(n3).trim();
        } else {
            string2 = string.substring(1);
        }
        return new String[]{string2, string3};
    }

    private String readLine() throws IOException {
        String string;
        do {
            ++this.currentLine;
            string = this.reader.readLine();
            if (string != null) continue;
            return null;
        } while ((string = string.trim()).length() == 0 || string.startsWith("#"));
        if (string.startsWith("*")) {
            string = string.substring(1).trim();
        }
        return string;
    }

    public void reset() {
        if (this.reader != null) {
            try {
                this.reader.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.root = null;
        this.apiList = null;
    }

    public ZephyrDesc filter(String string) throws PatternSyntaxException {
        if (this.root == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(string);
        ZephyrDesc zephyrDesc = new ZephyrDesc(ZephyrKeyword.ROOT, this.root.getLineNumber(), new ZephyrKeyword[0]);
        for (ZephyrDesc zephyrDesc2 : this.apiList) {
            if (!pattern.matcher(zephyrDesc2.getValue()).find()) continue;
            zephyrDesc.addChild(zephyrDesc2);
        }
        return zephyrDesc;
    }

    public Collection<? extends ValidatorMessage> getMessages() {
        return this.msgs;
    }
}

