/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class ScriptRunnerAction
extends DefaultSyntaxAction {
    protected static ScriptEngineManager sem;
    private ScriptEngine engine;
    private String scriptExtension;

    public ScriptRunnerAction() {
        super("SCRIPT_EXECUTE");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        try {
            ScriptEngine eng = this.getEngine(target);
            if (eng != null) {
                this.getEngine(target).eval(target.getText());
            }
        }
        catch (ScriptException ex) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(target), "Error executing script:\n" + ex.getMessage(), "Script Error", 0);
            ActionUtils.setCaretPosition(target, ex.getLineNumber(), ex.getColumnNumber());
        }
    }

    private ScriptEngine getEngine(JTextComponent target) {
        int result;
        if (this.engine == null) {
            if (sem == null) {
                sem = new ScriptEngineManager();
            }
            this.engine = sem.getEngineByExtension(this.scriptExtension);
        }
        if (this.engine == null && (result = JOptionPane.showOptionDialog(target, "Script Engine for [" + this.scriptExtension + "] not found. Disable this Action?", "jsyntaxpane", 0, 0, null, null, null)) == 0) {
            this.setEnabled(false);
        }
        return this.engine;
    }

    public void setScriptExtension(String value) {
        this.scriptExtension = value;
    }
}

