/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.netapp.zapi.parser.Api;
import com.netapp.zapi.parser.ApiFilter;
import com.netapp.zapi.parser.Field;
import com.netapp.zapi.parser.FieldFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ZapidocFilter {
    private final Set<ApiFilter> apiFilters = new HashSet<ApiFilter>();
    private final Set<FieldFilter> fieldFilters = new HashSet<FieldFilter>();

    public void addApiFilter(ApiFilter apiFilter) {
        this.apiFilters.add(apiFilter);
    }

    public void addFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilters.add(fieldFilter);
    }

    public Collection<ApiFilter> getApiFilters() {
        return Collections.unmodifiableSet(this.apiFilters);
    }

    public Collection<FieldFilter> getFieldFilters() {
        return Collections.unmodifiableSet(this.fieldFilters);
    }

    public boolean includeApi(Api api) {
        for (ApiFilter f : this.apiFilters) {
            if (f.apply(api)) continue;
            return false;
        }
        return true;
    }

    public boolean includeField(Field field) {
        for (FieldFilter f : this.fieldFilters) {
            if (f.apply(field)) continue;
            return false;
        }
        return true;
    }
}

