/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.netapp.zapi.generator.GeneratorFactory;
import com.netapp.zapi.generator.NameGenerator;
import com.netapp.zapi.parser.Category;
import com.netapp.zapi.parser.Field;
import com.netapp.zapi.parser.IncompatibleFieldsException;
import com.netapp.zapi.parser.IncompatibleTypesException;
import com.netapp.zapi.parser.MsgKey;
import com.netapp.zapi.parser.Namespace;
import com.netapp.zapi.parser.Tag;
import com.netapp.zapi.parser.ZapidocParser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class Type
implements Comparable<Type> {
    protected String name;
    protected ZapidocParser parser;
    protected Category category;
    protected String desc;
    protected Namespace namespace;
    protected Set<Field> fields = new TreeSet<Field>();

    protected Type(ZapidocParser parser, String name) {
        this.parser = parser;
        if (parser != null) {
            this.category = parser.getCurrentCategory();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Category getCategory() {
        return this.category;
    }

    protected void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    void setNamespace(String namespaceName) {
        this.setNamespace(this.parser.getNamespace(namespaceName));
    }

    void setNamespace(Namespace namespace) {
        if (this.namespace != null && this.namespace == namespace) {
            this.parser.appendWarning(MsgKey.ZAPI_PARSER_REDEFINE_NAMESPACE_SAME, this.toString(), this.namespace);
            return;
        }
        if (this.namespace != null) {
            this.parser.appendError(MsgKey.ZAPI_PARSER_REDEFINE_NAMESPACE, this.toString(), this.namespace, namespace);
            return;
        }
        this.namespace = namespace;
        this.parser.setLastNamespace(namespace);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    abstract void populate(Queue<Tag> var1);

    public Collection<Field> getFields() {
        return this.fields;
    }

    public Collection<Type> getReferencedTypes() {
        HashSet<Type> references = new HashSet<Type>();
        for (Field f : this.fields) {
            Type destType = f.getTypedefType();
            if (destType == null || destType.isPrimitive()) continue;
            references.add(destType);
        }
        return references;
    }

    public Collection<Type> getAllReferencedTypes() {
        HashSet<Type> references = new HashSet<Type>();
        this.getAllReferencedTypes(references);
        return references;
    }

    protected void getAllReferencedTypes(Collection<Type> types) {
        for (Field f : this.fields) {
            Type destType = f.getTypedefType();
            if (destType == null || destType.isPrimitive() || types.contains(destType)) continue;
            types.add(destType);
            destType.getAllReferencedTypes(types);
        }
    }

    public boolean isAlias() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Type getRootType() {
        return this;
    }

    protected void addWordReplacements(GeneratorFactory<?, ?, ?, ?> generatorFactory) {
        generatorFactory.getDescriptionGenerator().addWordReplacement(this.name, ((NameGenerator)generatorFactory.getTypeGenerator(this)).getNameGenerated());
        for (Field field : this.getFields()) {
            field.addWordReplacements(generatorFactory);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.namespace).append(this.category).append(this.name).toHashCode();
    }

    @Override
    public int compareTo(Type obj) {
        return new CompareToBuilder().append(this.namespace, obj.namespace).append(this.category, obj.category).append(this.name, obj.name).toComparison();
    }

    abstract void assertEquivalentTo(Type var1) throws IncompatibleTypesException;

    void assertEquivalientTo(Type that, Collection<Field> thisFields, Collection<Field> thatFields) throws IncompatibleTypesException {
        ImmutableMap<String, Field> fieldsByName = Maps.uniqueIndex(thatFields, Field.GET_NAME);
        for (Field thisField : thisFields) {
            Field thatField = fieldsByName.get(thisField.getName());
            if (thatField == null) {
                throw new IncompatibleTypesException(this, that, String.format("Field %s.%s not found in %s declaration of same name: %s", this.getQualifiedName(), thisField.getName(), this.getClass().getSimpleName(), that.getQualifiedName()));
            }
            try {
                thisField.assertEquivalentTo(thatField);
            }
            catch (IncompatibleFieldsException e) {
                throw new IncompatibleTypesException(this, that, e.getLocalizedMessage(), e);
            }
        }
    }

    public String getQualifiedName() {
        return this.category.getName() + "::" + this.name;
    }
}

