/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.netapp.nmsdk.common.util.CollectionUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class InternableFields {
    public static final InternableFields EMPTY_INTERNABLE_FIELDS = new InternableFields();
    private static final Function<String, String> TRIM_FUNCTION = new Function<String, String>(){

        @Override
        public String apply(String input) {
            return input.trim();
        }
    };
    private Table<String, String, Collection<String>> fields = HashBasedTable.create();

    private InternableFields() {
    }

    private void add(String typeName, String fieldName, Collection<String> internableValues) {
        this.fields.put(typeName, fieldName, internableValues);
    }

    public Collection<String> getInternableValues(String typeName, String fieldName) {
        return this.fields.get(typeName, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternableFields load(List<File> internablePropertiesFiles) throws IOException {
        InternableFields internableFields = new InternableFields();
        for (File file : internablePropertiesFiles) {
            Properties properties = new Properties();
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                properties.load(reader);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String[] typeAndField = ((String)entry.getKey()).split("\\.");
                    if (typeAndField.length != 2) {
                        throw new IOException(String.format("Type and field name must be in format \"<type>.<field>\".  Found: \"%s\"", entry.getKey()));
                    }
                    List<String> values = ((String)entry.getValue()).trim().isEmpty() ? Collections.emptyList() : CollectionUtils.transform(Arrays.asList(((String)entry.getValue()).split(",")), new ArrayList(), TRIM_FUNCTION);
                    internableFields.add(typeAndField[0], typeAndField[1], values);
                }
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return internableFields;
    }
}

