/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.xml;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.netapp.nmsdk.common.xml.JaxpContext;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private XmlUtils() {
    }

    public static String toString(Source xmlSource) {
        try {
            StreamResult streamResult = new StreamResult(new StringWriter());
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, streamResult);
            return streamResult.getWriter().toString();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static String toString(Node node) {
        return XmlUtils.toString(new DOMSource(node));
    }

    public static void copy(XMLEventReader reader, DocumentFragment documentFragment, Predicate<XMLEvent> terminationPredicate) throws XMLStreamException {
        Document document = documentFragment.getOwnerDocument();
        Element fragmentContainerElement = document.createElement("fragment-container");
        XmlUtils.copy(reader, fragmentContainerElement, terminationPredicate);
        NodeList childNodes = fragmentContainerElement.getChildNodes();
        ArrayList<Element> childElements = new ArrayList<Element>(childNodes.getLength());
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            childElements.add((Element)node);
        }
        for (Element childElement : childElements) {
            documentFragment.appendChild(childElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(XMLEventReader reader, Node node, Predicate<XMLEvent> terminationPredicate) throws XMLStreamException {
        XMLEventWriter xmlEventWriter = XMLOutputFactory.newInstance().createXMLEventWriter(new DOMResult(node));
        try {
            XMLEvent event = reader.nextEvent();
            while (!terminationPredicate.apply(event) && reader.hasNext()) {
                xmlEventWriter.add(event);
                event = reader.nextEvent();
            }
            xmlEventWriter.flush();
        }
        finally {
            xmlEventWriter.close();
        }
    }

    public static class Transform {
        private static final ThreadLocal<Transformer> IDENTITY_TRANSFORMER = new ThreadLocal<Transformer>(){

            @Override
            protected Transformer initialValue() {
                try {
                    return JaxpContext.transform().transformerFactory().newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    throw Throwables.propagate(e);
                }
                catch (TransformerFactoryConfigurationError e) {
                    throw Throwables.propagate(e);
                }
            }
        };

        private Transform() {
        }

        public static Transformer identityTransformer() {
            return IDENTITY_TRANSFORMER.get();
        }
    }

    public static class Stax {
        public static final EventFilter WHITESPACE_FILTER = new EventFilter(){

            @Override
            public boolean accept(XMLEvent event) {
                return !event.isCharacters() || !event.asCharacters().isWhiteSpace();
            }
        };

        private Stax() {
        }

        public static <T extends XMLEvent> T consumeUntil(XMLEventReader reader, Predicate<XMLEvent> predicate) throws XMLStreamException {
            XMLEvent event = reader.nextEvent();
            while (!predicate.apply(event)) {
                event = reader.nextEvent();
            }
            return (T)event;
        }

        public static class Predicates {
            private Predicates() {
            }

            public static Predicate<XMLEvent> matchingEndElement(final StartElement startElement) {
                return new Predicate<XMLEvent>(){
                    int endElementsOutstanding = 1;

                    @Override
                    public boolean apply(XMLEvent event) {
                        if (event.isStartElement() && startElement.getName().equals(event.asStartElement().getName())) {
                            ++this.endElementsOutstanding;
                        } else if (event.isEndElement() && startElement.getName().equals(event.asEndElement().getName())) {
                            --this.endElementsOutstanding;
                        }
                        return this.endElementsOutstanding == 0;
                    }
                };
            }
        }
    }
}

