/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.xml;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLTransformChainer {
    private XMLTransformChainer() {
    }

    public static void applyTransforms(Reader reader, Writer writer, Transformer ... transformers) {
        if (transformers.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Reader currentReader = reader;
            for (int i = 0; i < transformers.length - 1; ++i) {
                Transformer transformer = transformers[i];
                PipedWriter pipedWriter = new PipedWriter();
                PipedReader pipedReader = new PipedReader(pipedWriter);
                new TransformerThread(i, transformer, currentReader, pipedWriter).start();
                currentReader = pipedReader;
            }
            Transformer lastTransformer = transformers[transformers.length - 1];
            lastTransformer.transform(new StreamSource(currentReader), new StreamResult(writer));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class TransformerThread
    extends Thread {
        private Transformer transformer;
        private Reader reader;
        private Writer writer;

        private TransformerThread(int number, Transformer transformer, Reader reader, Writer writer) {
            super("Transformer-Thread-" + number);
            this.transformer = transformer;
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        public void run() {
            try {
                this.transformer.transform(new StreamSource(this.reader), new StreamResult(this.writer));
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

