/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util.fault;

import com.netapp.nmsdk.common.MsgKey;
import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.nmsdk.common.util.StringUtils;
import com.netapp.nmsdk.common.util.fault.FaultFactory;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FaultInjectionManager {
    private static final NALogger logger = NALogger.getLogger(FaultInjectionManager.class);
    private static final Pattern SPEC_REGEX = Pattern.compile("([^:]+):(.+)");
    public static final String CLASS_METHOD = "class";
    public static final String FACTORY_METHOD = "factory";
    public static final String SYSTEM_PROPERTY = "com.netapp.nmsdk.common.util.FaultClassPath";
    public static final String FAULT_MAP_FILE = "faults.properties";
    private static final FaultInjectionManager INSTANCE;
    private final Properties configuration = new Properties();
    private final URLClassLoader baseLoader;
    private final Map<ClassLoader, ClassLoader> chainedLoaders = new HashMap<ClassLoader, ClassLoader>();

    @SuppressWarnings(value={"DP"})
    public FaultInjectionManager(String[] paths, String propertiesFile) throws IOException {
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            urls[i] = new File(paths[i]).toURI().toURL();
        }
        this.baseLoader = new URLClassLoader(urls, null);
        InputStream stream = this.baseLoader.getResourceAsStream(propertiesFile);
        if (stream == null) {
            throw new FileNotFoundException(propertiesFile);
        }
        this.configuration.load(stream);
    }

    public <T> T createObject(Class<T> clazz, String ... keys) throws InstantiationException, IllegalAccessException {
        for (String key : keys) {
            T result;
            if (key == null) continue;
            String fullKey = key + "." + clazz.getName();
            logger.debug((MessageKey)MsgKey.UTIL_FAULT_KEY_LOOKUP, fullKey);
            String value = this.configuration.getProperty(fullKey);
            if (StringUtils.isEmpty(value) || (result = this.createReplacementObject(clazz, value)) == null) continue;
            return result;
        }
        return clazz.newInstance();
    }

    @SuppressWarnings(value={"DP"})
    public ClassLoader getClassLoader(ClassLoader parent) {
        ClassLoader loader = this.chainedLoaders.get(parent);
        if (loader == null) {
            loader = new URLClassLoader(this.baseLoader.getURLs(), parent);
            this.chainedLoaders.put(parent, loader);
        }
        return loader;
    }

    private <T> T createReplacementObject(Class<T> clazz, String spec) throws InstantiationException, IllegalAccessException {
        Matcher m = SPEC_REGEX.matcher(spec);
        if (!m.matches()) {
            logger.error((MessageKey)MsgKey.UTIL_FAULT_BAD_SPEC, spec, clazz.getName());
            return null;
        }
        String method = m.group(1);
        String newClassName = m.group(2);
        ClassLoader loader = this.getClassLoader(clazz.getClassLoader());
        Class<?> newClass = null;
        try {
            newClass = loader.loadClass(newClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error((MessageKey)MsgKey.UTIL_FAULT_CLASS_NOT_FOUND, clazz.getName(), newClassName);
            return null;
        }
        if (CLASS_METHOD.equalsIgnoreCase(method)) {
            if (!clazz.isAssignableFrom(newClass)) {
                logger.error((MessageKey)MsgKey.UTIL_FAULT_CLASS_NOT_SUBCLASS, clazz.getName(), newClass.getName());
                return null;
            }
            logger.info((MessageKey)MsgKey.UTIL_FAULT_INJECTING_CLASS, clazz.getName(), newClass.getName());
            return newClass.asSubclass(clazz).newInstance();
        }
        if (FACTORY_METHOD.equalsIgnoreCase(method)) {
            FaultFactory factory;
            if (!FaultFactory.class.isAssignableFrom(newClass)) {
                logger.error((MessageKey)MsgKey.UTIL_FAULT_FACTORY_NOT_INSTANCE, clazz.getName(), newClass.getName());
                return null;
            }
            try {
                logger.info((MessageKey)MsgKey.UTIL_FAULT_INJECTING_FACTORY_CLASS, clazz.getName(), newClass.getName());
                factory = newClass.asSubclass(FaultFactory.class).newInstance();
            }
            catch (InstantiationException e) {
                logger.error((MessageKey)MsgKey.UTIL_FAULT_FACTORY_INSTANTIATION_ERROR, e, newClass.getName(), e.getLocalizedMessage());
                return null;
            }
            catch (IllegalAccessException e) {
                logger.error((MessageKey)MsgKey.UTIL_FAULT_FACTORY_INSTANTIATION_ERROR, e, newClass.getName(), e.getLocalizedMessage());
                return null;
            }
            return factory.createObject(clazz, loader);
        }
        logger.error((MessageKey)MsgKey.UTIL_FAULT_BAD_SPEC_METHOD, method, clazz.getName());
        return null;
    }

    public static FaultInjectionManager getInstance() {
        return INSTANCE;
    }

    public static boolean isActive() {
        return INSTANCE != null;
    }

    static {
        FaultInjectionManager manager = null;
        String classpath = System.getProperty(SYSTEM_PROPERTY);
        if (!StringUtils.isEmpty(classpath)) {
            String[] paths = classpath.split(File.pathSeparator);
            try {
                manager = new FaultInjectionManager(paths, FAULT_MAP_FILE);
                logger.info(MsgKey.UTIL_FAULT_INITIALIZED);
            }
            catch (Exception e) {
                logger.error((MessageKey)MsgKey.UTIL_FAULT_ERROR_INITIALIZING, e, e.getLocalizedMessage());
            }
        }
        INSTANCE = manager;
    }
}

