/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class WildcardTypeImpl
implements WildcardType {
    private final Type[] lowerBounds;
    private final Type[] upperBounds;
    private final String string;

    WildcardTypeImpl() {
        this.lowerBounds = new Type[0];
        this.upperBounds = new Type[]{Object.class};
        this.string = "?";
    }

    WildcardTypeImpl(Type[] lowerBounds, Type[] upperBounds) {
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
        StringBuilder b = new StringBuilder("?");
        if (lowerBounds.length > 0) {
            String prefix = " super ";
            for (Type t : lowerBounds) {
                b.append(prefix);
                if (t instanceof Class) {
                    b.append(((Class)t).getName());
                } else {
                    b.append(t);
                }
                prefix = " & ";
            }
        } else {
            String prefix = " extends ";
            for (Type t : upperBounds) {
                if (Object.class.equals((Object)t)) continue;
                b.append(prefix);
                if (t instanceof Class) {
                    b.append(((Class)t).getName());
                } else {
                    b.append(t);
                }
                prefix = " & ";
            }
        }
        this.string = b.toString();
    }

    @Override
    @SuppressWarnings(value={"EI"})
    public Type[] getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    @SuppressWarnings(value={"EI"})
    public Type[] getUpperBounds() {
        return this.upperBounds;
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WildcardType)) {
            return false;
        }
        return this.string.equals(o.toString());
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

