/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import com.netapp.nmsdk.common.MsgKey;
import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.nmsdk.common.util.CollectionUtils;
import com.netapp.nmsdk.common.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Utils {
    private static final NALogger logger = NALogger.getLogger(Utils.class);
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final Pattern NUMBER_PATTERN;

    protected Utils() {
    }

    public static String nullSafeString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static String prettyString(Throwable t) {
        return t.getLocalizedMessage() != null ? t.getLocalizedMessage() : t.toString();
    }

    public static String reflectiveToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "String[value=" + (String)o + "]";
        }
        ToStringStyle toStringStyle = new ToStringStyle(){
            {
                this.setUseShortClassName(true);
                this.setUseIdentityHashCode(false);
            }

            @Override
            public void append(StringBuffer buffer, String fieldName, Object fieldValue, Boolean fullDetail) {
                if (fieldValue instanceof String || fieldValue instanceof Integer || fieldValue instanceof Boolean || fieldValue instanceof Long) {
                    super.append(buffer, fieldName, fieldValue, fullDetail);
                } else {
                    super.append(buffer, fieldName, Utils.reflectiveToString(fieldValue, this), fullDetail);
                }
            }
        };
        return Utils.reflectiveToString(o, toStringStyle);
    }

    private static String reflectiveToString(Object object, ToStringStyle toStringStyle) {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(object, toStringStyle, null, Object.class, false, false);
        reflectionToStringBuilder.setExcludeFieldNames(new String[]{"password"});
        return reflectionToStringBuilder.toString();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static long unsigned32LE(byte[] b, int offset) {
        return (0xFF & b[offset + 0]) << 0 | (0xFF & b[offset + 1]) << 8 | (0xFF & b[offset + 2]) << 16 | (0xFF & b[offset + 3]) << 24;
    }

    public static int unsigned16LE(byte[] b, int offset) {
        return (0xFF & b[offset + 0]) << 0 | (0xFF & b[offset + 1]) << 8;
    }

    public static long unsigned32BE(byte[] b, int offset) {
        return (0xFF & b[offset + 0]) << 24 | (0xFF & b[offset + 1]) << 16 | (0xFF & b[offset + 2]) << 8 | (0xFF & b[offset + 3]) << 0;
    }

    public static int unsigned16BE(byte[] b, int offset) {
        return (0xFF & b[offset + 0]) << 8 | (0xFF & b[offset + 1]) << 0;
    }

    public static short unsigned8(byte b) {
        return (short)(0xFF & b);
    }

    public static String byteArrayToHexString(byte[] byteArray, int offset, int length) {
        return Utils.byteArrayToHexString(byteArray, 0, offset, length);
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        return Utils.byteArrayToHexString(byteArray, 0, 0, byteArray.length);
    }

    public static String byteArrayToHexString(byte[] byteArray, int grouping) {
        return Utils.byteArrayToHexString(byteArray, grouping, 0, byteArray.length);
    }

    public static String byteArrayToHexString(byte[] byteArray, int grouping, int offset, int length) {
        StringBuffer hexString = new StringBuffer(byteArray.length);
        for (int i = offset; i < offset + length; ++i) {
            if (grouping > 0 && i != 0 && i % grouping == 0) {
                hexString.append(" ");
            }
            String hex = Integer.toHexString(256 + (byteArray[i] & 0xFF)).substring(1);
            hexString.append((hex.length() < 2 ? "0" : "") + hex);
        }
        return hexString.toString();
    }

    public static String byteToHexString(byte b) {
        String hex = Integer.toHexString(256 + (b & 0xFF)).substring(1);
        return (hex.length() < 2 ? "0" : "") + hex;
    }

    public static String numberToStringNoCommas(Object number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static String getCanonicalLocalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static List<InetAddress> getLocalHostAddresses() throws SocketException {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                if (addresses == null) continue;
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    list.add(address);
                }
            }
        }
        return list;
    }

    public static boolean isLocalhost(String host) {
        try {
            for (InetAddress localHostAddress : Utils.getLocalHostAddresses()) {
                if (!Utils.hostEquals(localHostAddress, host)) continue;
                return true;
            }
            return false;
        }
        catch (SocketException e) {
            logger.warn((MessageKey)MsgKey.UTIL_LOCAL_HOST_ADDRESSES, e);
            return false;
        }
    }

    public static boolean hostEquals(InetAddress addr1, String host2) {
        try {
            InetAddress addr2 = InetAddress.getByName(host2);
            boolean areEquals = addr1.equals(addr2);
            logger.internalTrace("Utils.hostEquals(" + addr1 + ", " + host2 + " [" + addr2.getHostAddress() + "]) = " + Boolean.toString(areEquals));
            return areEquals;
        }
        catch (UnknownHostException e) {
            logger.warn((MessageKey)MsgKey.UTIL_UNKNOWN_HOST, e.getLocalizedMessage());
            return false;
        }
    }

    public static boolean hostEquals(String host1, String host2) {
        if (host1.equals(host2)) {
            return true;
        }
        try {
            InetAddress addr1 = InetAddress.getByName(host1);
            return Utils.hostEquals(addr1, host2);
        }
        catch (UnknownHostException e) {
            logger.warn((MessageKey)MsgKey.UTIL_UNKNOWN_HOST, e.getLocalizedMessage());
            return false;
        }
    }

    @Deprecated
    public static boolean isEmpty(String s) {
        return StringUtils.isBlank(s);
    }

    public static boolean isEmpty(Collection<?> c) {
        return CollectionUtils.isEmpty(c);
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return CollectionUtils.isEmpty(m);
    }

    public static boolean isEmpty(Object[] a) {
        return CollectionUtils.isEmpty(a);
    }

    @Deprecated
    public static String[] findRegExMatches(String patternStr, CharSequence input) {
        return StringUtils.findRegExMatches(patternStr, input);
    }

    @Deprecated
    public static boolean containsAny(String s, String ... substrings) {
        return StringUtils.containsAny(s, substrings);
    }

    public static String getCurrentDateUsingFormat(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format((Object)new Date());
    }

    public static String getFileName(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("File path cannot be null.");
        }
        String retVal = null;
        retVal = Utils.getEndSubstring(filePath, System.getProperty("file.separator"));
        if (retVal != null) {
            return retVal;
        }
        retVal = Utils.getEndSubstring(filePath, "/");
        if (retVal != null) {
            return retVal;
        }
        retVal = Utils.getEndSubstring(filePath, "\\");
        if (retVal != null) {
            return retVal;
        }
        return filePath;
    }

    private static String getEndSubstring(String str1, String str2) {
        int ndx = str1.lastIndexOf(str2);
        if (ndx >= 0) {
            return str1.substring(ndx + 1);
        }
        return null;
    }

    public static boolean integerInRange(int i, int lowval, int highval) {
        return i >= lowval && i <= highval;
    }

    public static Calendar calendarFromDate(Date d) {
        if (d == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        return calendar;
    }

    public static boolean integerInRange(String value, int lowval, int highval) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        try {
            int i = Integer.parseInt(value);
            return Utils.integerInRange(i, lowval, highval);
        }
        catch (NumberFormatException nfe) {
            if (Utils.isNumeric(value)) {
                return false;
            }
            throw nfe;
        }
    }

    public static boolean isDirectory(File file) {
        boolean isDirectory = false;
        if (file.exists() && file.isDirectory()) {
            isDirectory = true;
        }
        return isDirectory;
    }

    public static boolean isExactlyOneTrue(boolean ... b) {
        boolean found = false;
        for (boolean testBoolean : b) {
            if (!testBoolean) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    public static boolean equalAndRealValues(Object arg1, Object arg2) {
        if (arg1 != null && arg2 != null) {
            return arg1.equals(arg2);
        }
        return false;
    }

    public static boolean isNumeric(String value) {
        Matcher myMatcher = NUMBER_PATTERN.matcher(value);
        return myMatcher.matches();
    }

    public static String niceThrowableMessage(Throwable t) {
        return t.getLocalizedMessage() != null ? t.getLocalizedMessage() : t.toString();
    }

    public static String niceThrowableMessageWithStacktrace(Throwable t) {
        String msg = Utils.niceThrowableMessage(t);
        StringWriter out = new StringWriter();
        t.printStackTrace(new PrintWriter(out));
        String newline = System.getProperty("line.separator");
        return msg + newline + out;
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
        NUMBER_PATTERN = Pattern.compile("[+-]?[0-9]+");
    }
}

