/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Size
implements Comparable<Size> {
    private long value;
    private Unit unit;
    private static final Pattern SIZE_STRING_PATTERN = Pattern.compile("(\\d[\\d,]+)\\s*([a-zA-Z]{0,2})");

    public Size(long value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public long getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Size convertTo(Unit destUnit) {
        return new Size(this.valueIn(destUnit), destUnit);
    }

    public long valueIn(Unit destUnit) {
        return this.value * this.unit.multiplier / destUnit.multiplier;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Size)) {
            return false;
        }
        Size rhs = (Size)object;
        return this.value == rhs.valueIn(this.unit);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.valueIn(Unit.B)).toHashCode();
    }

    public String toString() {
        return String.format("%,d%s", new Object[]{this.value, this.unit});
    }

    @Override
    public int compareTo(Size other) {
        return (int)(this.valueIn(Unit.B) - other.valueIn(Unit.B));
    }

    public static Size fromString(String string) {
        Matcher matcher = SIZE_STRING_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        return new Size(Long.parseLong(matcher.group(1).replace(",", "")), matcher.group(2).isEmpty() ? Unit.B : Unit.valueOf(matcher.group(2).toUpperCase()));
    }

    public static enum Unit {
        B(1L),
        KB(1024L),
        MB(1024L * Unit.KB.multiplier),
        GB(1024L * Unit.MB.multiplier),
        TB(1024L * Unit.GB.multiplier),
        PB(1024L * Unit.TB.multiplier),
        EB(1024L * Unit.PB.multiplier);

        private long multiplier;

        private Unit(long multiplier) {
            this.multiplier = multiplier;
        }
    }
}

