/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import com.netapp.nmsdk.common.MsgKey;
import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.nmsdk.common.util.CacheMBean;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class Cache<K, V>
implements CacheMBean {
    private static final String[] STRING_CAST = new String[0];
    private static final NALogger logger = NALogger.getLogger(Cache.class);
    private static final int SCAVENGE_SECONDS = 300;
    private static final ScavengerThread SCAVENGER = new ScavengerThread();
    private final String name;
    private final Map<K, Reference<V>> cache;
    private volatile Date lastScavengeTime;
    private volatile long hitCount;
    private volatile long missCount;
    private volatile long lifetimeCount;

    public Cache() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NN"})
    public Cache(String name) {
        this.name = name;
        this.cache = new HashMap<K, Reference<V>>();
        Cache.SCAVENGER.add(this);
        ScavengerThread scavengerThread = SCAVENGER;
        synchronized (scavengerThread) {
            SCAVENGER.notify();
        }
    }

    public synchronized void put(K key, V value) {
        Reference<V> ref = this.cache.get(key);
        if (ref == null || ref.get() != value) {
            this.cache.put(key, new SoftReference<V>(value));
            ++this.lifetimeCount;
        }
    }

    public V get(Object key) {
        Reference<V> ref = this.cache.get(key);
        V value = null;
        if (ref != null) {
            value = ref.get();
        }
        this.hitCount += value != null ? 1L : 0L;
        this.missCount += value == null ? 1L : 0L;
        return value;
    }

    public V remove(Object key) {
        Reference<V> ref = this.cache.remove(key);
        V value = null;
        if (ref != null) {
            value = ref.get();
        }
        return value;
    }

    public int size() {
        return this.cache.size();
    }

    @Override
    public synchronized void scavenge() {
        int removed = 0;
        Iterator<Reference<V>> iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            Reference<V> ref = iter.next();
            if (ref.get() != null) continue;
            iter.remove();
            ++removed;
        }
        if (removed > 0) {
            logger.debug((MessageKey)MsgKey.UTIL_CACHE_SCAVENGE_COUNT, removed, this);
        }
        this.lastScavengeTime = new Date();
    }

    @Override
    public int getCurrentCount() {
        return this.cache.size();
    }

    @Override
    public long getLifetimeCount() {
        return this.lifetimeCount;
    }

    @Override
    public long getHitCount() {
        return this.hitCount;
    }

    @Override
    public long getMissCount() {
        return this.missCount;
    }

    @Override
    @SuppressWarnings(value={"EI"})
    public Date getLastScavengeTime() {
        return this.lastScavengeTime;
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }

    @Override
    public void resetCounters() {
        this.lifetimeCount = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
    }

    @Override
    public String[] getKeys() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<K, Reference<V>> entry : this.cache.entrySet()) {
            if (entry.getValue().get() == null) continue;
            set.add(entry.getKey().toString());
        }
        return set.toArray(STRING_CAST);
    }

    private void jmxRegister() {
        if (this.name == null) {
            return;
        }
        try {
            logger.debug((MessageKey)MsgKey.UTIL_CACHE_JMX_STARTING, this);
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = new ObjectName(this.name);
            mbeanServer.registerMBean(this, beanName);
        }
        catch (Exception ex) {
            logger.debug((MessageKey)MsgKey.UTIL_CACHE_JMX_START_EXCEPTION, (Throwable)ex, this.name, ex.getLocalizedMessage());
        }
    }

    public String toString() {
        return this.name != null ? this.name : "Unknown";
    }

    static {
        SCAVENGER.setDaemon(true);
        SCAVENGER.start();
    }

    protected static class ScavengerThread
    extends Thread {
        private final Queue<Cache<?, ?>> cacheQueue = new ConcurrentLinkedQueue();
        private final List<Reference<Cache<?, ?>>> cacheList = new LinkedList();

        private ScavengerThread() {
            super("CacheScavenger");
        }

        private void add(Cache<?, ?> cache) {
            this.cacheQueue.add(cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                this.doRun();
                ScavengerThread scavengerThread = this;
                synchronized (scavengerThread) {
                    try {
                        this.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void doRun() {
            logger.debug(MsgKey.UTIL_CACHE_BEGIN_SCAVENGE);
            long time = System.currentTimeMillis();
            int scavengeCount = 0;
            Cache<?, ?> cache = this.cacheQueue.poll();
            while (cache != null) {
                if (((Cache)cache).name != null) {
                    ((Cache)cache).jmxRegister();
                }
                this.cacheList.add(new WeakReference(cache));
                cache = this.cacheQueue.poll();
            }
            Iterator<Reference<Cache<?, ?>>> iter = this.cacheList.iterator();
            while (iter.hasNext()) {
                Reference<Cache<?, ?>> ref = iter.next();
                cache = ref.get();
                if (cache == null) {
                    iter.remove();
                    continue;
                }
                cache.scavenge();
                ++scavengeCount;
            }
            time = System.currentTimeMillis() - time;
            logger.debug((MessageKey)MsgKey.UTIL_CACHE_END_SCAVENGE, scavengeCount, time);
        }
    }
}

