package noris::Nagios::WebLogin::Plugin::Projectile;

use strict;
use warnings;
use utf8;

use base 'noris::Nagios::WebLogin::Agent';

sub logout {
    my $agent = shift;
    $agent->click_button( input => $agent->form_number(1)->find_input( undef, 'image', 10 ) );
}

1;

=head1 NAME

noris::Nagios::WebLogin::Plugin::Projectile - Definiert die Funktionen für Projectile 

=head1 SYNOPSE

    use noris::Nagios::WebLogin::Plugin::Projectile;

=head1 BESCHREIBUNG

Dieses Modul definiert die Dummy Funktionen von noris::Nagios::WebLogin::Agent.
Diese sind auf "Projectile" zugeschnitten.

=head1 UNTERSTÜTZE FUNKTIONEN

=over 4

=item logout()

Wenn diese Funktion aufgerufen wird, loggt sich der Client von der Webseite aus.
Diese ist auf Projectile zugeschnitten.

    use noris::Nagios::WebLogin::Plugin::Projectile;

    # nutzt noris::Nagios::WebLogin::Agent was wiederum WWW::Mechanize nutzt
    my $agent = noris::Nagios::WebLogin::Plugin::Projectile->new();

    $agent->logout(); # Loggt sich von Projectile aus

=back

