﻿#============================================================#
#                                                            #
# apitest.ps1                                                #
#                                                            #
# Exploratory application for testing Data ONTAP APIs.       #
# It lets you call any Data ONTAP API with name-value pair   #
#  of arguments.                                             #
#                                                            #
# Copyright 2002-2009 NetApp, Inc. All rights                #
# reserved. Specifications subject to change without notice. # 
#                                                            #
# This SDK sample code is provided AS IS, with no support or #
# warranties of any kind, including but not limited to       #
# warranties of merchantability or fitness of any kind,      #
# expressed or implied.  This code is subject to the license #
# agreement that accompanies the SDK.                        #
#                                                            #
# Usage:apitest [options] <host> <user> <password>           #
#       <ONTAPI-name> [<param-name> <value> ...]             #
#============================================================#

function PrintUsage
{
        write $("Usage: apitest.ps1 [options] <host> <user> <password> <ONTAPI-name> [<param-name> <value> ...]`n");
        write $("Options:");
        write $("`t -t {type} `t Server type(type = filer, dfm, agent)");
        write $("`t -v {vfiler name}  Vfiler name, if the API has to be 
                executed in the context of a vfiler");
        write $("`t -r `t Use RPC transport");
        write $("`t -s `t Use SSL");
        write $("`t -p {port} `t Override port to use");
        write $("`t -c {timeout} `t Connection timeout value in seconds");
        write $("`t -i `t API specified as XML input, on the command line");
        write $("`t -I `t API specified as XML input, on standard input");
        write $("`t -x `t Show the XML input and output");
        write $("`t -X `t Show the raw XML input and output");
        write $("`t -h `t Use Host equiv authentication mechanism");
        write $("`n`t Do not provide username and password for -h and -r options");
        write $("`nExamples:");
        write $("`t apitest sweetpea root tryme system-get-version");
        write ("`t apitest amana root meat quota-report volume vol0`n");
        exit(1);
}

# function which tries to load ManageONTAP.dll library which is typically at 
# <sdk-install-root>\lib\DotNet directory.
function LoadAssembly
{
    $cur = (pwd).path;
    $library = $cur + "\ManageOntap.dll"

    if((test-path $library) -eq $true) {
        [System.Reflection.Assembly] $Assembly = 
        [System.Reflection.Assembly]::LoadFrom($library);
        return;
    }
    $library = "..\..\..\lib\DotNet\ManageOntap.dll";
    if((test-path $library) -eq $true) {
        $parent = `split-path -path $cur`;
        $parent = `split-path -path $parent`;
        $parent = `split-path -path $parent`;
        $parent = $parent + "\lib\DotNet";
        $library = $parent + "\ManageOntap.dll";
        [System.Reflection.Assembly] $Assembly = 
        [System.Reflection.Assembly]::LoadFrom($library);
    }
    else {
        Write("ERROR:Unable to find ManageONTAP.dll.");
        exit(1);
    }
    trap [Exception] { 
      write-error $("ERROR:" + $_.Exception.Message); 
      exit(1); 
   }
}      

Invoke-Expression LoadAssembly;

# Check for valid no. of command line arguments
if ($ARGS.Length -lt  3) {
Invoke-Expression PrintUsage;
}

# Declaration of NaServer and NaElement classes which are used 
# to invoke Data ONTAP APIs.
[NetApp.Manage.NaServer] $s;
[NetApp.Manage.NaElement] $xi;
[NetApp.Manage.NaElement] $xo;

$transportType = "HTTP";
$serverType = "FILER";
$authStyle = "LOGIN_PASSWORD"

[int]$index = 0;
$showXML = 0;
$inputXML = 0;
[int]$port = -1;
[int]$timeOut = 0;
[int]$status = 0;
[int]$useRPC = 0;
[int]$useHostsEquiv = 0;
[String] $vfiler = "";
[String] $type = "";
[String] $readXML = "";

#Parse the command line arguments
while ($index -lt $ARGS.Length -and $ARGS[$index][0] -eq "-") {
    switch ($ARGS[$index][1]) {
        "t" {
                $type = $ARGS[$index+1];
                if ($type -eq "dfm") {
                    $serverType = "DFM";
                }
                elseif ($type -eq "agent"){
                    $serverType = "AGENT";
                }
                elseif ($type -eq "filer") {
                    $serverType = "FILER";
                }
                else{
                    Write("`nERROR: Invalid Option for Server type.");
                    Invoke-Expression PrintUsage;
                }
                $index = $index + 2;
            }
        "v" {
                $vfiler = $ARGS[$index+1];
                $index = $index + 2;
            }
        "r" {
                $authStyle = "RPC";
                $useRPC = 1;
                $index++;
            }
        "s" {
                $transportType = "HTTPS";
                $index++;
            }
        "i" {
                if($ARGS[$index][1] -ceq "i"){
                    $inputXML = 1;
                }
                else {
                    $inputXML = 2;
                }
                $index++;                            
            }
        "x" {
                if($ARGS[$index][1] -ceq "x") {
                    $showXML = 1;
                }
                else {
                    $showXML = 2;
                }
                $index++;
            }
        "h" {
                $authStyle = "HOSTSEQUIV";
                $useHostsEquiv = 1;
                $index++;
            }
        "p" {
                [int] $port = $ARGS[$index+1];
                if($port -le 0) {
                    Write $("`nERROR: Invalid port number.");
                    exit(1);
                }
                trap [Exception] { 
                    write-error $("ERROR: Invalid port number. " + $_.Exception.Message); 
                    exit(1); 
                }
                $index = $index + 2;
            }
        "c" {
                $timeOut = $ARGS[$index+1];
                if($timeOut -le 1) {
                    write $("`nERROR: Invalid timeout value.");
                    exit(1);
                 }
                 $index = $index + 2;
            }
            default {
                Write $("`nERROR: Invalid Option.");
                Invoke-Expression PrintUsage;   
            }
        } 
} 

    if ($authStyle -eq "LOGIN_PASSWORD" -and $ARGS.Length -lt 4) {
                Invoke-Expression PrintUsage;
    }

    if ($useHostsEquiv -eq 1 -and $useRPC -eq 1) {
                Write ("`nERROR: Invalid usage of authentication style.
                Do not use -r option and -h option together.`n");
                exit(1);
    }
    if ($authStyle -eq "LOGIN_PASSWORD") {
            
                if ($index -eq $ARGS.Length)
                {
                    Write ("`nERROR: Host not specified.");
                    Invoke-Expression PrintUsage;
                }
                if (($index+1) -eq $ARGS.Length) {
                    Write ("`nERROR: User not specified.");
                    Invoke-Expression PrintUsage;
                }
                elseif (($index+2) -eq $ARGS.Length) {
                    Write("`nERROR: Password not specified.");
                    Invoke-Expression PrintUsage;
                }
    }

    if ($port -eq -1) {
        if($serverType -eq "DFM") {
            if($transportType -eq "HTTP") {
                $port = 8088;
            }
            else {
                $port = 8488;
            }
        }
        elseif($serverType -eq "AGENT") {
            if($transportType -eq "HTTP") {
                $port = 4092;
            }
            else {
                $port = 4093;
            }
        }
        else {
            if($transportType -eq "HTTP") {
                $port = 80;
            }
            else {
                $port = 443;
            }
    }
}
                        
if ($vfiler -ne "") {
    $s = New-Object NetApp.Manage.NaServer($ARGS[$index], 1, 7);
    $s.SetVfilerTunneling($vfiler);
}
else {
    $s = New-Object NetApp.Manage.NaServer($ARGS[$index], 1, 0);
} 

$s.ServerType = $serverType;
$s.TransportType = $transportType;
$s.Style = $authStyle;
    
if ($authStyle -eq  "LOGIN_PASSWORD") {
    $s.SetAdminUser($ARGS[++$index],$ARGS[++$index]);
}
    
$s.Port = $port;

if ($timeOut -gt 0) {
    $s.TimeOut = $timeOut;
}

if ($inputXML -eq 0) {
    if (($index+1) -eq $ARGS.Length) {
        Write("`nERROR: API not specified.");
        Invoke-Expression PrintUsage;
    }
    $xi = New-Object NetApp.Manage.NaElement($ARGS[++$index]);

    if ($ARGS.Length -gt $index+1) {
        [int] $index2 = 0;
        for ($index2 = $index+1;$index2 -lt $ARGS.Length;$index2++) {
            $xi.AddNewChild($ARGS[$index2], $ARGS[$index2+1]);
            $index2++;
        }
    }
}
else {
    if ($inputXML -eq 1) {
        if ($ARGS.Length -eq $index+1) {
            Write("API not specified");
            Invoke-Expression PrintUsage;
        }
        [int] $index2 = 0;
        for ($index2 = $index+1;$index2 -lt $ARGS.Length;$index2++) {
            $readXML = $readXML + $ARGS[$index2];
        }
    }
    else {
        write("Enter the input XML:");
        [String] $curLine;
        while (($curLine = [Console]::ReadLine()) -ne $null) {
            $readXML += $curLine;
        }
    }
    [String] $args2 = $readXML.split(" `t`n`r");
    $readXML = "";
    for ($index2 = 0; $index2 -lt $args2.Length; $index2++) {
        if (!($args2[$index2] -ccontains "`t"  -or $args2[$index2] -ccontains " ")) {
            $readXML = $readXML + $args2[$index2];
        }
    }
    $args2 = $readXML.split("`t`n");
    $xi = $s.ParseXMLInput($args2);
}

if ($showXML -gt 0)	{
    if ($showXML -eq 1) {
        write("INPUT:`n" + $xi.ToPrettyString(""));
    }
    else{
        $s.DebugStyle = "PRINT_PARSE";
    }
}
$xo = $s.InvokeElem($xi);
if ($showXML -gt 0) {
    if ($showXML -eq 2) {
    return;
    }
    write("OUTPUT:");   
}                    
write($xo.ToPrettyString(""));
 
trap [Exception] { 
      write-error $("ERROR:" + $_.Exception.Message); 
      exit(1); 
}
