/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.IllegalBlockingModeException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import netapp.manage.http.HTTPException;
import netapp.manage.http.HTTPRequest;
import netapp.manage.http.HTTPResponse;

public class HTTPClient {
    private static final long TIMEOUT = 30000L;
    private static Object _lock = new Object();
    private static SocketFactory _plainFactory = SocketFactory.getDefault();
    private static SocketFactory _sslFactory = null;
    public static int snoop = 0;
    private boolean _ssl;
    private InetAddress _host;
    private int _port;
    private Socket _sock;
    private OutputStream _out;
    private InputStream _in;
    private int _useCount;
    private long _lastTimeUsed;
    private int _timeOut;

    private static SocketFactory makeSSLFactory() {
        TrustManager[] trustManagerArray = new X509TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            return sSLContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (KeyManagementException keyManagementException) {
            return null;
        }
    }

    public HTTPClient(boolean bl, String string, int n) throws IOException, UnknownHostException {
        this(bl, string, n, false);
    }

    public HTTPClient(boolean bl, String string, int n, boolean bl2) throws IOException, UnknownHostException {
        this(bl, InetAddress.getByName(string), n, bl2, 0);
    }

    public HTTPClient(boolean bl, InetAddress inetAddress, int n) throws IOException {
        this(bl, inetAddress, n, false, 0);
    }

    public HTTPClient(boolean bl, InetAddress inetAddress, int n, boolean bl2) throws IOException {
        this(bl, inetAddress, n, bl2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPClient(boolean bl, InetAddress inetAddress, int n, boolean bl2, int n2) throws IOException, SocketTimeoutException, IllegalArgumentException, IllegalBlockingModeException {
        ArrayList<String> arrayList;
        String[] stringArray;
        this._ssl = bl;
        this._host = inetAddress;
        this._port = n;
        this._timeOut = n2 * 1000;
        if (this._ssl) {
            Object object = _lock;
            synchronized (object) {
                if (null == _sslFactory) {
                    _sslFactory = HTTPClient.makeSSLFactory();
                }
            }
            if (null == _sslFactory) {
                throw new IOException("Can't create SSL socket");
            }
            if (this._timeOut > 0) {
                this._sock = _sslFactory.createSocket();
                object = new InetSocketAddress(this._host, this._port);
                this._sock.connect((SocketAddress)object, this._timeOut);
                this._sock.setSoTimeout(this._timeOut);
            } else {
                this._sock = _sslFactory.createSocket(this._host, this._port);
            }
        } else if (bl2) {
            int n3 = 1023;
            while (null == this._sock) {
                if (0 == n3) {
                    throw new IOException("Failed to bind to a reserved port");
                }
                try {
                    if (this._timeOut > 0) {
                        this._sock = _plainFactory.createSocket();
                        stringArray = new InetSocketAddress(this._host, this._port);
                        arrayList = null;
                        InetSocketAddress inetSocketAddress = new InetSocketAddress((InetAddress)((Object)arrayList), n3);
                        this._sock.bind(inetSocketAddress);
                        this._sock.connect((SocketAddress)stringArray, this._timeOut);
                        this._sock.setSoTimeout(this._timeOut);
                    } else {
                        this._sock = _plainFactory.createSocket(this._host, this._port, null, n3);
                    }
                }
                catch (BindException bindException) {
                    this._sock = null;
                }
                --n3;
            }
        } else if (this._timeOut > 0) {
            this._sock = _plainFactory.createSocket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this._host, this._port);
            this._sock.connect(inetSocketAddress, this._timeOut);
            this._sock.setSoTimeout(this._timeOut);
        } else {
            this._sock = _plainFactory.createSocket(this._host, this._port);
        }
        if (this._sock instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)this._sock;
            stringArray = sSLSocket.getEnabledProtocols();
            arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            arrayList.remove("TLSv1");
            stringArray = arrayList.toArray(new String[0]);
            sSLSocket.setEnabledProtocols(stringArray);
        }
        this._out = this._sock.getOutputStream();
        this._in = this._sock.getInputStream();
        this._useCount = 0;
        this._lastTimeUsed = System.currentTimeMillis();
    }

    public void close() {
        try {
            this._out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this._in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this._sock.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isCompatible(boolean bl, String string, int n) {
        return bl == this._ssl && string.equals(this._host.getHostName()) && n == this._port;
    }

    public boolean isCompatible(boolean bl, InetAddress inetAddress, int n) {
        return bl == this._ssl && inetAddress.equals(this._host) && n == this._port;
    }

    public boolean isTimedOut() {
        return System.currentTimeMillis() > this._lastTimeUsed + 30000L;
    }

    public int getUseCount() {
        return this._useCount;
    }

    public HTTPResponse doRequest(HTTPRequest hTTPRequest) throws IOException, HTTPException {
        hTTPRequest.setHeader("Host", this._host.getHostName() + (80 == this._port ? "" : ":" + this._port));
        hTTPRequest.write(this._out);
        HTTPResponse hTTPResponse = HTTPResponse.read(this._in);
        ++this._useCount;
        this._lastTimeUsed = System.currentTimeMillis();
        return hTTPResponse;
    }
}

