/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import netapp.manage.http.HTTPException;
import netapp.manage.http.HTTPMessage;

public class HTTPResponse
extends HTTPMessage {
    private int _statusCode;
    private String _reasonPhrase;

    public HTTPResponse(int n, int n2, String string) {
        super(n);
        this._statusCode = n2;
        this._reasonPhrase = string;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public String getReasonPhrase() {
        return this._reasonPhrase;
    }

    public static HTTPResponse read(InputStream inputStream) throws IOException, HTTPException {
        String string = HTTPResponse.readLine(inputStream);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            throw new HTTPException("Malformed response: " + string);
        }
        int n = HTTPResponse.versionFromString(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = string.substring((HTTPResponse.versionToString(n) + " " + n2).length()).trim();
        HTTPResponse hTTPResponse = new HTTPResponse(n, n2, string2);
        String string3 = HTTPResponse.readLine(inputStream);
        while (0 < string3.length()) {
            hTTPResponse.processHeaderLine(string3);
            string3 = HTTPResponse.readLine(inputStream);
        }
        hTTPResponse.readContents(inputStream);
        return hTTPResponse;
    }

    public boolean canKeepAlive() {
        String string = this.getHeader("Content-Length");
        String string2 = this.getHeader("Transfer-Encoding");
        if (null == string && null == string2) {
            return false;
        }
        String string3 = this.getHeader("Connection");
        if (!(2 != this._version || null != string3 && string3.equalsIgnoreCase("close"))) {
            return true;
        }
        return 1 == this._version && null != string3 && string3.equalsIgnoreCase("Keep-Alive");
    }

    protected String firstLine() {
        return HTTPResponse.versionToString(this._version) + " " + (this._statusCode + " " + this._reasonPhrase).trim() + "\r\n";
    }
}

