/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import netapp.manage.http.Base64;
import netapp.manage.http.HTTPException;
import netapp.manage.http.HTTPMessage;

public class HTTPRequest
extends HTTPMessage {
    private int _method;
    private String _path;

    public HTTPRequest(int n, String string, int n2) {
        super(n2);
        this._method = n;
        this._path = string;
    }

    public int getMethod() {
        return this._method;
    }

    public String getPath() {
        return this._path;
    }

    public void setBasicAuthorization(String string, String string2) {
        this.setHeader("Authorization", "Basic " + Base64.encodeString(string + ":" + string2, false));
    }

    public static HTTPRequest read(InputStream inputStream) throws IOException, HTTPException {
        String string = HTTPRequest.readLine(inputStream);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() != 3) {
            throw new HTTPException("Malformed request: " + string);
        }
        int n = HTTPRequest.methodFromString(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        int n2 = HTTPRequest.versionFromString(stringTokenizer.nextToken());
        HTTPRequest hTTPRequest = new HTTPRequest(n, string2, n2);
        String string3 = HTTPRequest.readLine(inputStream);
        while (0 < string3.length()) {
            hTTPRequest.processHeaderLine(string3);
            string3 = HTTPRequest.readLine(inputStream);
        }
        if (1 == n) {
            return hTTPRequest;
        }
        hTTPRequest.readContents(inputStream);
        return hTTPRequest;
    }

    protected String firstLine() {
        return HTTPRequest.methodToString(this._method) + " " + (this._path + " " + HTTPRequest.versionToString(this._version)).trim() + "\r\n";
    }
}

