/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaExecHost;
import netapp.manage.NaExecResult;
import netapp.manage.NaProtocolException;

class NaSshHost
extends NaExecHost {
    NaSshHost() {
    }

    private SshClient login() throws IOException, NaAuthenticationException {
        SshClient sshClient = new SshClient();
        sshClient.setSocketTimeout(30000);
        SshConnectionProperties sshConnectionProperties = new SshConnectionProperties();
        sshConnectionProperties.setHost(this._hostname);
        sshConnectionProperties.setPrefPublicKey("ssh-dss");
        sshClient.connect(sshConnectionProperties, new HostKeyVerification(){

            public boolean verifyHost(String string, SshPublicKey sshPublicKey) {
                return true;
            }
        });
        PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
        passwordAuthenticationClient.setUsername(this._username);
        passwordAuthenticationClient.setPassword(this._password);
        if (4 != sshClient.authenticate((SshAuthenticationClient)passwordAuthenticationClient)) {
            throw new NaAuthenticationException("Authorization failed");
        }
        return sshClient;
    }

    private static ByteArrayOutputStream[] invoke(SshClient sshClient, String string) throws NaProtocolException, IOException {
        SessionChannelClient sessionChannelClient = sshClient.openSessionChannel();
        if (!sessionChannelClient.executeCommand(string)) {
            throw new NaProtocolException("SSH exec failed");
        }
        ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[]{new ByteArrayOutputStream(), new ByteArrayOutputStream()};
        IOStreamConnector iOStreamConnector = new IOStreamConnector();
        IOStreamConnector iOStreamConnector2 = new IOStreamConnector();
        iOStreamConnector.setCloseOutput(false);
        iOStreamConnector2.setCloseOutput(false);
        iOStreamConnector.connect((InputStream)sessionChannelClient.getInputStream(), (OutputStream)byteArrayOutputStreamArray[0]);
        iOStreamConnector2.connect(sessionChannelClient.getStderrInputStream(), (OutputStream)byteArrayOutputStreamArray[1]);
        try {
            sessionChannelClient.getState().waitForState(3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return byteArrayOutputStreamArray;
    }

    public NaExecResult exec(String string) throws IOException, NaAuthenticationException, NaProtocolException {
        SshClient sshClient = this.login();
        ByteArrayOutputStream[] byteArrayOutputStreamArray = NaSshHost.invoke(sshClient, string);
        sshClient.disconnect();
        NaExecResult naExecResult = new NaExecResult();
        try {
            naExecResult.stdout = new String(byteArrayOutputStreamArray[0].toByteArray(), "UTF-8");
            naExecResult.stderr = new String(byteArrayOutputStreamArray[1].toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            naExecResult.stdout = new String(byteArrayOutputStreamArray[0].toByteArray());
            naExecResult.stderr = new String(byteArrayOutputStreamArray[1].toByteArray());
        }
        return naExecResult;
    }

    static {
        Logger.getLogger("com.sshtools").setUseParentHandlers(false);
        Logger.getLogger("com.sshtools").setLevel(Level.OFF);
    }
}

