/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaError;
import netapp.manage.NaExecHost;
import netapp.manage.NaExecResult;
import netapp.manage.NaInvokable;
import netapp.manage.NaParser;
import netapp.manage.NaProtocolException;
import netapp.manage.http.HTTPClient;
import netapp.manage.http.HTTPException;
import netapp.manage.http.HTTPRequest;
import netapp.manage.http.HTTPResponse;
import org.xml.sax.SAXException;

public class NaServer {
    public static final int SERVER_TYPE_FILER = 1;
    public static final int SERVER_TYPE_NETCACHE = 2;
    public static final int SERVER_TYPE_AGENT = 3;
    public static final int SERVER_TYPE_DFM = 4;
    public static final int TRANSPORT_TYPE_HTTP = 1;
    public static final int TRANSPORT_TYPE_HTTPS = 2;
    public static final int TRANSPORT_TYPE_SSH = 3;
    private static final int TCP_PORT_FILER = 80;
    private static final int TCP_PORT_NETCACHE = 80;
    private static final int TCP_PORT_AGENT = 4092;
    private static final int TCP_PORT_DFM = 8088;
    private static final int TCP_PORT_SSH = 22;
    public static final int STYLE_LOGIN_PASSWORD = 1;
    public static final int STYLE_HOSTSEQUIV = 2;
    public static final int STYLE_RPC = 3;
    public static final int LOGIN_PASSWORD = 1;
    public static final int HOSTSEQUIV = 2;
    private static final String FILER_REQUEST_URI = "/servlets/netapp.servlets.admin.XMLrequest_filer";
    private static final String NETCACHE_REQUEST_URI = "/servlets/netapp.servlets.admin.XMLrequest";
    private static final String AGENT_REQUEST_URI = "/apis/XMLrequest";
    private static final String DFM_REQUEST_URI = "/apis/XMLrequest";
    private static final String XML_REQUEST_BEGIN = "<?xml version='1.0' encoding='utf-8' ?>\r\n<!DOCTYPE netapp SYSTEM 'file:/etc/netapp_filer.dtd'>\r\n";
    private static final String FILER_NAMESPACE = "http://www.netapp.com/filer/admin";
    private InetAddress _server;
    private String _serverName;
    private int _type;
    private int _transport;
    private String _login;
    private String _password;
    private int _style;
    private int _port;
    private int _major;
    private int _minor;
    private int _snoop;
    private boolean _keepAlive;
    private List _sessions;
    private Thread _watcherThread;

    public NaServer(InetAddress inetAddress) {
        this._server = inetAddress;
        this._serverName = inetAddress.getHostName();
        this._major = 1;
        this._minor = 0;
        this._login = null;
        this._password = null;
        this._type = 1;
        this._transport = 1;
        this._style = 1;
        this._port = 0;
        this._snoop = 0;
        this._keepAlive = false;
        this._sessions = new ArrayList();
        this._watcherThread = null;
    }

    public NaServer(String string) throws UnknownHostException {
        this._serverName = string;
        this._major = 1;
        this._minor = 0;
        this._login = null;
        this._password = null;
        this._type = 1;
        this._transport = 1;
        this._style = 1;
        this._port = 0;
        this._snoop = 0;
        this._keepAlive = false;
        this._sessions = new ArrayList();
        this._watcherThread = null;
    }

    public NaServer(InetAddress inetAddress, int n, int n2) {
        this(inetAddress);
        this.setApiVersion(n, n2);
    }

    public NaServer(String string, int n, int n2) throws UnknownHostException {
        this._serverName = string;
        this._login = null;
        this._password = null;
        this._type = 1;
        this._transport = 1;
        this._style = 1;
        this._port = 0;
        this._snoop = 0;
        this._keepAlive = false;
        this._sessions = new ArrayList();
        this._watcherThread = null;
        this.setApiVersion(n, n2);
    }

    public void setApiVersion(int n, int n2) {
        this._major = n;
        this._minor = n2;
    }

    public synchronized void close() {
        this.setKeepAliveEnabled(false);
        if (null != this._watcherThread) {
            this._watcherThread.interrupt();
        }
    }

    public synchronized void setKeepAliveEnabled(boolean bl) {
        if (!bl) {
            Iterator iterator = this._sessions.iterator();
            while (iterator.hasNext()) {
                HTTPClient hTTPClient = (HTTPClient)iterator.next();
                iterator.remove();
                hTTPClient.close();
            }
            this._keepAlive = false;
        } else {
            this._keepAlive = true;
        }
    }

    private synchronized void cleanSessionCache() {
        boolean bl = 2 == this._transport;
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            HTTPClient hTTPClient = (HTTPClient)iterator.next();
            if (hTTPClient.isCompatible(bl, this._server, this.getPort()) && !hTTPClient.isTimedOut()) continue;
            iterator.remove();
            hTTPClient.close();
        }
        if (0 == this._sessions.size()) {
            this._watcherThread = null;
        }
    }

    private synchronized HTTPClient getSession() throws IOException {
        boolean bl;
        boolean bl2 = 2 == this._transport;
        boolean bl3 = bl = 2 == this._style;
        if (this._server == null) {
            try {
                this._server = InetAddress.getByName(this._serverName);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IOException("The host " + this._serverName + "could not be resolved");
            }
        }
        while (this._sessions.size() > 0) {
            HTTPClient hTTPClient = (HTTPClient)this._sessions.remove(0);
            if (!hTTPClient.isTimedOut() && hTTPClient.isCompatible(bl2, this._server, this.getPort())) {
                return hTTPClient;
            }
            hTTPClient.close();
        }
        return new HTTPClient(bl2, this._server, this.getPort(), bl);
    }

    private synchronized void cacheSession(HTTPClient hTTPClient) {
        this._sessions.add(hTTPClient);
        if (null == this._watcherThread) {
            this._watcherThread = new Thread(new Runnable(){

                public void run() {
                    Thread thread = Thread.currentThread();
                    while (NaServer.this._watcherThread == thread) {
                        NaServer.this.cleanSessionCache();
                        if (NaServer.this._watcherThread != thread) break;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
        }
    }

    public synchronized void setPort(int n) {
        this._port = n;
    }

    public int getPort() {
        if (0 != this._port) {
            return this._port;
        }
        if (3 == this._transport) {
            return 22;
        }
        switch (this._type) {
            case 2: {
                return 80;
            }
            case 3: {
                return 4092;
            }
            case 4: {
                return 8088;
            }
        }
        return 80;
    }

    public int getServerType() {
        return this._type;
    }

    private String getURISuffix() {
        switch (this._type) {
            case 2: {
                return NETCACHE_REQUEST_URI;
            }
            case 3: {
                return "/apis/XMLrequest";
            }
            case 4: {
                return "/apis/XMLrequest";
            }
        }
        return FILER_REQUEST_URI;
    }

    public synchronized void setServerType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this._type = n;
                return;
            }
        }
        throw new IllegalArgumentException("Unknown API server type: " + n);
    }

    public int getTransportType() {
        return this._transport;
    }

    public synchronized void setTransportType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this._transport = n;
                return;
            }
        }
        throw new IllegalArgumentException("Unknown API transport type: " + n);
    }

    public void setAdminUser(String string, String string2) {
        this._login = string;
        this._password = string2;
    }

    public void setStyle(int n) {
        if (1 != n && 2 != n && 3 != n) {
            throw new IllegalArgumentException("Invalid style: " + n);
        }
        this._style = n;
    }

    public void setSnoop(int n) {
        this._snoop = n;
        HTTPClient.snoop = n;
    }

    public int getStyle() {
        return this._style;
    }

    public NaElement invokeElem(NaElement naElement) throws IOException, NaAuthenticationException, NaAPIFailedException, NaProtocolException {
        int n;
        NaElement naElement2;
        String string = naElement.toString();
        String string2 = 3 == this._style ? this.invokeRPC(string) : (3 == this._transport ? this.invokeSSH(string) : this.invokeHTTP(string));
        if (this._snoop > 1) {
            System.err.println("BODY =====\n" + string2 + "\n===== END BODY");
        }
        if (0 == string2.length()) {
            throw new NaProtocolException("body of server response empty");
        }
        int n2 = string2.indexOf("<!DOCTYPE");
        int n3 = string2.indexOf("<netapp");
        if (n2 < 0) {
            throw new NaProtocolException("server response did not contain <!DOCTYPE>");
        }
        if (n3 < 0) {
            n3 = string2.indexOf("<", n2);
            if (n3 < 0) {
                throw new NaProtocolException("Output from server doesn't contain <netapp> element.");
            }
            throw new NaProtocolException("Unexpected tag found: " + string2.substring(0, n2) + string2.substring(n3));
        }
        string2 = string2.substring(0, n2) + string2.substring(n3);
        if (this._snoop > 1) {
            System.err.println("MODIFIED BODY =====\n" + string2 + "\n===== END MODIFIED BODY");
        }
        try {
            naElement2 = NaParser.parseTree(new StringReader(string2));
        }
        catch (IOException iOException) {
            throw new NaError("I/O error during XML parsing", iOException);
        }
        catch (SAXException sAXException) {
            throw new NaProtocolException("Malformed XML", sAXException);
        }
        if (null == naElement2 || !naElement2.getName().equals("netapp")) {
            throw new NaProtocolException("Output from server doesn't contain <netapp> element.");
        }
        if (1 != naElement2.getChildren().size()) {
            throw new NaProtocolException("Unexpected - received multiple elements in <netapp>, expecting only one: " + naElement2.toString());
        }
        NaElement naElement3 = naElement2.getChildByName("results");
        if ("passed".equals(naElement3.getAttr("status"))) {
            return naElement3;
        }
        String string3 = naElement3.getAttr("errno");
        if (null == string3) {
            n = 13114;
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NaProtocolException("Malformed errno code: " + string3, numberFormatException);
        }
        throw new NaAPIFailedException(n, naElement3.getAttr("reason"));
    }

    private String invokeHTTP(String string) throws IOException, NaAuthenticationException, NaProtocolException {
        HTTPResponse hTTPResponse;
        HTTPClient hTTPClient;
        byte[] byArray;
        HTTPRequest hTTPRequest = new HTTPRequest(2, this.getURISuffix(), 1);
        try {
            byArray = ("<?xml version='1.0' encoding='utf-8' ?>\r\n<!DOCTYPE netapp SYSTEM 'file:/etc/netapp_filer.dtd'>\r\n<netapp version='" + this._major + "." + this._minor + "' xmlns='" + FILER_NAMESPACE + "'>" + string + "</netapp>\r\n").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NaError("Failed UTF-8 encoding", unsupportedEncodingException);
        }
        hTTPRequest.setContents(byArray);
        hTTPRequest.setHeader("Content-Length", "" + byArray.length);
        hTTPRequest.setBasicAuthorization(this._login, this._password);
        if (this._keepAlive) {
            hTTPRequest.setHeader("Connection", "Keep-Alive");
        }
        while (true) {
            boolean bl;
            boolean bl2 = bl = 0 == (hTTPClient = this.getSession()).getUseCount();
            if (this._snoop > 0) {
                System.err.println(bl ? "*** Using new connection" : "*** Reusing existing connection");
            }
            try {
                hTTPResponse = hTTPClient.doRequest(hTTPRequest);
            }
            catch (IOException iOException) {
                hTTPClient.close();
                if (bl) {
                    throw iOException;
                }
                if (this._snoop <= 0) continue;
                System.err.println("*** Failed attempt (" + iOException + ") trying again");
                continue;
            }
            catch (HTTPException hTTPException) {
                hTTPClient.close();
                throw new NaProtocolException("HTTP protocol error", hTTPException);
            }
            break;
        }
        if (this._keepAlive && hTTPResponse.canKeepAlive()) {
            if (this._snoop > 0) {
                System.err.println("*** Saving connection for future use");
            }
            this.cacheSession(hTTPClient);
        } else {
            if (this._snoop > 0) {
                System.err.println("*** Closing non-reusable connection");
            }
            hTTPClient.close();
        }
        if (401 == hTTPResponse.getStatusCode()) {
            throw new NaAuthenticationException("Authorization failed");
        }
        if (200 != hTTPResponse.getStatusCode()) {
            throw new NaProtocolException("Unexpected HTTP response: " + hTTPResponse.getStatusCode() + " " + hTTPResponse.getReasonPhrase());
        }
        try {
            return new String(hTTPResponse.getContents(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NaError("Failed UTF-8 decoding", unsupportedEncodingException);
        }
    }

    private String invokeSSH(String string) throws IOException, NaAuthenticationException, NaProtocolException {
        NaExecHost naExecHost;
        Object object;
        try {
            Class.forName("com.sshtools.j2ssh.SshClient");
            object = Class.forName("netapp.manage.NaSshHost");
            naExecHost = (NaExecHost)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NaError("Failed to load SSH library", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new NaError("Failed to instantiate SSH library", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NaError("Illegal access loading SSH library", illegalAccessException);
        }
        naExecHost.setHostname(this._serverName);
        naExecHost.setLogin(this._login, this._password);
        object = "priv set advanced ; ontapi execute " + string;
        NaExecResult naExecResult = naExecHost.exec((String)object);
        return naExecResult.stdout;
    }

    private String invokeRPC(String string) throws IOException, NaAuthenticationException, NaProtocolException {
        NaInvokable naInvokable;
        try {
            Class<?> clazz = Class.forName("netapp.manage.NaRPCTarget");
            naInvokable = (NaInvokable)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NaError("Failed to load RPC library", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new NaError("Failed to instantiate RPC library", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NaError("Illegal access loading RPC library", illegalAccessException);
        }
        naInvokable.setHostname(this._serverName);
        string = "<netapp version='" + this._major + "." + this._minor + "' xmlns='" + FILER_NAMESPACE + "'>" + string + "</netapp>\r\n";
        return naInvokable.invoke(string);
    }

    private String getTransportString() {
        switch (this._transport) {
            case 1: {
                return "HTTP";
            }
            case 2: {
                return "HTTPS";
            }
            case 3: {
                return "SSH";
            }
        }
        return Integer.toString(this._transport);
    }

    private String getAuthStyleString() {
        switch (this._style) {
            case 1: {
                return "password";
            }
            case 2: {
                return "host-equiv";
            }
            case 3: {
                return "RPC";
            }
        }
        return Integer.toString(this._style);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        stringBuffer.append("server=" + this._server.getHostName());
        stringBuffer.append(",");
        stringBuffer.append("uri=" + this.getURISuffix());
        stringBuffer.append(",");
        stringBuffer.append("login=" + this._login);
        stringBuffer.append(",");
        stringBuffer.append("password=(hidden)");
        stringBuffer.append(",");
        stringBuffer.append("auth-style=" + this.getAuthStyleString());
        stringBuffer.append(",");
        stringBuffer.append("protocol=" + this.getTransportString());
        stringBuffer.append(",");
        stringBuffer.append("port=" + this.getPort());
        stringBuffer.append(",");
        stringBuffer.append("version=" + this._major + "." + this._minor);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

