#!/usr/bin/perl
use strict;
use DBI;
use DBD::mysql;
use Getopt::Std;

my %opts;
getopts ":-h:-u:-p:",\%opts;

if (!defined $opts{'h'}) {
	&usage();
} elsif (!defined $opts{'u'}) {
	&usage();
}

sub usage () {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
	exit 1;
}

my $driver = "mysql";
my $dsn = "DBI:$driver:database=;hostname=$opts{'h'}";
my $dbh = DBI->connect($dsn,$opts{'u'},"$opts{'p'}");

unless (defined $dbh) {
	print "Can't connect to mysql: $@\n";
	exit 2;
}

my $sth = $dbh->prepare("show master logs");
$sth->execute();

my $cnt = 0;

while (my @row = $sth->fetchrow_array()) {
	$cnt++;
}

$sth->finish();
$dbh->disconnect();

if ($cnt <= 30) {
	print "Alles OK: $cnt binlog files\n";
	exit 0;
} elsif ($cnt > 30 and $cnt <= 40) {
	print "langsam werdens ein bisschen viele binlogs: $cnt binlog files\n";
	exit 1;
} elsif ($cnt > 40) {
	print "bitte die alten Binlog files purgen: $cnt blinlog files\n";
	exit 2;
}
