#!/bin/bash
#
# multi_check_tcp.sh
#
# written by Martin Karch 2008
# (c) noris network AG



CHECK_TCP="/usr/lib/nagios/plugins/check_tcp"


exit_error()
{
	echo "Usage: $0 <Hostname | IP Address> [-r | --range] <Port1> <Port2> <Port3>..."
        exit 1
}

if [ "$1" == "" ]
then
	exit_error
fi

HOST="$1"
shift

case "$1" in
	"") 
		exit_error
		;;

	-r|-R|--range|--RANGE|--Range)
		if [ $# != 3 ]
		then
			exit_error
		fi
		
		PORTS=`seq $2 $3`
		;;
		
	*)
		PORTS="$*"
		;;
esac

# echo $PORTS

EXIT_CODE=0

OK_PORTS=""
WARNING_PORTS=""
CRITICAL_PORTS=""

for port in $PORTS
do
	$CHECK_TCP -H $HOST -p $port > /dev/null 2>&1
	status=$?

	case $status in
		2)	CRITICAL_PORTS="$CRITICAL_PORTS $port"
			;;

		1)	WARNING_PORTS="$WARNING_PORTS $port"
			;;

		*)	OK_PORTS="$OK_PORTS $port"
			;;
	esac
	
	if [ $EXIT_CODE -lt $status ]
	then
		EXIT_CODE=$status
	fi
done

echo "TCP Ports OK:$OK_PORTS  -  TCP Ports WARNING:$WARNING_PORTS  -  TCP Ports CRITICAL:$CRITICAL_PORTS"

exit $EXIT_CODE

