#!/usr/bin/perl

use strict;
use warnings;
use LWP::Simple qw(get);
use XML::Simple;
use Getopt::Std;

sub usage() { # output when (needed) options are missing or -h option given
    print "$0: -H <Host> -n node -c <size,consumerCount> [-w <size,consumerCount>] [-p port]\n\twarning and port are optional.\n";
	exit 3;
}

my %options = ();

getopts("H:n:c:w:p:h", \%options);
## vars that come from getopts
my $host = $options{'H'};
my $node = $options{'n'};
my $critical = $options{'c'};
my $warning = $options{'w'};
my $port = $options{'p'};
my $help = $options{'h'};
my $xml = new XML::Simple;

if ($help) {
	usage
}
$port=8161 unless defined($port); # make sure that $port is defined

usage unless (defined $host && defined $node && defined $critical); # if host, node or critical values are not defined output the help text and exit

##############################################################################
## get and Parse the XML data                                               ##
##############################################################################
my $URL="http://$host:$port/admin/xml/queues.jsp";
my $data = $xml->XMLin(get("$URL"));
my $size = $data->{'queue'}{$node}{'stats'}{'size'};
my $consumer = $data->{'queue'}{$node}{'stats'}{'consumerCount'};
##############################################################################

##############################################################################
## check the critical state                                                 ##
##############################################################################
my @crit = split(',', $critical);
my $Csize = $crit[0];
my $Ccount = $crit[1];
@crit = undef;
if (($size > $Csize) || ($consumer != $Ccount)) {
	print "Critical: size: $size, consumerCount: $consumer\n";
	exit 2;
}
###############################################################################

###############################################################################
## check the warning state if defined                                        ##
###############################################################################
if (defined $warning) {
	my @warn = split(',', $warning);
	my $Wsize = $warn[0];
	my $Wcount = $warn[1];
	@warn = undef;
	if (($size > $Wsize) || ($consumer != $Wcount)) {
		print "Warning: size: $size, consumerCount: $consumer\n";
		exit 1;
	}
}
################################################################################
print "OK: size: $size, consumerCount: $consumer\n";
exit 0;
