#!/usr/bin/python
# encoding: UTF-8

DefaultConfig = { "CGIConfigFile": "/etc/nagios/cgi.cfg",
                  "RTNotifyLog": "/var/log/nagios/notify.log",
                  "NagiosLogFile": "/var/log/nagios/nagios.log",
                  "NagiosLogArchive": "/var/log/nagios/archives/"
                }

import os
import sys
import cgi
import cgitb
import time
import gzip
import ConfigParser

conf = ConfigParser.ConfigParser(DefaultConfig)
conf.read("/etc/nagios-enhancer.conf")
try:
	conf.add_section("files")
except:
	pass

cgitb.enable()

print "Content-Type: text/xml"
print

class Notice(object):
	def __init__(self, text, host):
		text = text.strip()
		self.raw = text
		self.Host = "????"
		self.Service = None
		self.Status = "????"
		self.Ticket = 0
		self.Sequence = 0
		if ' => ' in text:
			ticket = text[text.index(' => ') + 7:]
			text = text[:text.index(' => ')]
			while len(ticket) and not ticket[0].isdigit():
				ticket = ticket[1:]
			while len(ticket) and not ticket[-1].isdigit():
				ticket = ticket[:-1]
			if len(ticket):
				self.Ticket = int(ticket.split('-')[0])
				try:
					self.Sequence = int(ticket.split('-')[1])
				except IndexError:
					self.Sequence = 1
		items = text.split(' -')
		self.Date = time.mktime(time.strptime(items.pop(0)))
		for item in items:
			if '=' in item:
				key = item.split('=', 1)[0]
				value = item.split('=', 1)[1]
			elif ' ' in item:
				key = item.split(' ', 1)[0]
				value = item.split(' ', 1)[1]
			else:
				key = item
				value = None
			if key == "status":
				self.Status = value
			elif key == "key":
				self.Host = value
				if value != host and value.startswith(host):
					self.Host = host
					self.Service = value[len(host):]
					if self.Service[0] == '/':
						self.Service = self.Service[1:]
	
	def GetDate(self):
		return self.Date
	
	def ToHTML(self, hidden=False):
		if hidden:
			return "<tr style='display:none'><td><a href='https://intra.office.noris.de/otrs/index.fpl?Action=AgentTicketSearch&Subaction=FastSearch&ResultForm=Normal&FastSearchPattern=%d'>%d-%d</a></td><td>%s</td><td>%s</td></tr>" % (self.Ticket, self.Ticket, self.Sequence, self.Status, time.ctime(self.Date))
		else:
			return "<tr><td><a href='https://intra.office.noris.de/otrs/index.fpl?Action=AgentTicketSearch&Subaction=FastSearch&ResultForm=Normal&FastSearchPattern=%d'>%d-%d</a></td><td>%s</td><td>%s</td></tr>" % (self.Ticket, self.Ticket, self.Sequence, self.Status, time.ctime(self.Date))

class Downtime(object):
	def __init__(self, text):
		text = text.strip()
		self.raw = text.strip()
		ts, rest = text.split(' ', 1)
		self.Time = int(ts[1:-1])
		action, rest = rest.split(';', 1)
		if action == "EXTERNAL COMMAND: SCHEDULE_HOST_DOWNTIME":
			self.Service = None
			self.Host, start, end, kA, kA2, kA3, self.User, self.Comment = rest.split(';')
		elif action == "EXTERNAL COMMAND: SCHEDULE_SVC_DOWNTIME":
			self.Host, self.Service, start, end, kA, kA2, kA3, self.User, self.Comment = rest.split(';')
		self.Start = int(start)
		self.End = int(end)
		self.Length = self.End - self.Start
		try:
			self.Comment = unicode(self.Comment, "ISO-8859-15").encode("UTF-8")
		except:
			pass
	
	def GetEnd(self):
		return self.End
	
	def ToHTML(self, hidden=False):
		if hidden:
			return "<tr style='display:none'><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>" % (self.Service, time.ctime(self.Start), time.ctime(self.End), Duration(time.time() - self.End), Duration(self.Length), self.User, self.Comment)
		else:
			return "<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>" % (self.Service, time.ctime(self.Start), time.ctime(self.End), Duration(time.time() - self.End), Duration(self.Length), self.User, self.Comment)
	
	def __repr__(self):
		return "%s(%s)" % (self.__class__.__name__, repr(self.raw))

class CGIConfig(dict):
	def __init__(self, name):
		try:
			f = file(name, "r")
		except:
			return
		for line in f:
			line = line.strip()
			if not line or line[0] == '#' or not '=' in line:
				continue
			self[line.split('=', 1)[0].strip()] = [x.strip() for x in line.split('=', 1)[1].strip().split(',')]

def Duration(i):
	i = int(i)
	if i < 0:
		return "in the future"
	ret = ""
	if i >= 86400:
		ret += " " + str(i / 86400) + " days"
		i %= 86400
	if i >= 3600:
		ret += " " + str(i / 3600) + " hours"
		i %= 3600
	if i >= 60:
		ret += " " + str(i / 60) + " minutes"
		i %= 60
	if ret == "":
		ret = "just now"
	return ret.strip()

def GetNotification(limit=3, timelimit=0):
	path, name = os.path.split(conf.get("files", "RTnotifyLog"))
	errortext = ""
	logs = []
	try:
		dir = os.listdir(path)
		for d in dir:
			if not d.startswith(name):
				continue
			if d.endswith(".gz"):
				f = gzip.GzipFile(os.path.join(path, d))
			else:
				f = file(os.path.join(path, d))
			for line in f:
				if not host in line:
					continue
				logs.append(Notice(line, host))
	except OSError, e:
		errortext = str(e)

	results = []
	for i in logs:
		if host == i.Host and service == i.Service:
			results.append(i)

	results.sort(key=Notice.GetDate, reverse=True)
	print "<results>"
	print "  <data>"
	print "    <lines>%d</lines>" % (len(results), )
	print "    <limit>%d</limit>" % (limit, )
	print "  </data>"
	print "  <html>"
	if len(results) == 0:
		if errortext:
			print cgi.escape("<tr><td colspan=3>Fehler beim Lesen der Logs: %s</td></tr>" % (errortext, ))
		else:
			print cgi.escape("<tr><td colspan=3>Keine Daten gefunden.</td></tr>")
	else:
		for i in xrange(len(results)):
			if not limit or i < limit:
				print cgi.escape(results[i].ToHTML())
			else:
				print cgi.escape(results[i].ToHTML(True))
	print "  </html>"
	print "</results>"

def ReadLogFile(name, host, service):
	ret = []
	try:
		f = file(name, "r")
	except IOError:
		return []
	for line in f:
		if (not "EXTERNAL COMMAND: SCHEDULE_HOST_DOWNTIME" in line) and (not "EXTERNAL COMMAND: SCHEDULE_SVC_DOWNTIME" in line):
			continue
		d = Downtime(line)
		if host != d.Host or (service and d.Service and service != d.Service):
			continue
		ret.append(d)
	return ret

# Logfilename format:
#nagios-MM-DD-YYYY-NN.log
#nagios-08-14-2009-00.log
def LogKey(name):
	if len(name) != 24 or not name.startswith("nagios-") or not name.endswith(".log"):
		return "zzzzzzz"
	return "nagios-%s-%s-%s-%s.log" % (name[13:17], name[7:9], name[10:12], name[18:20])

def ReadLogDir(name, host, service, limit, timelimit):
	num = 0
	ret = []
	d = os.listdir(name)
	d.sort(key=LogKey, reverse=True)
	for f in d:
		ret.extend(ReadLogFile(os.path.join(name, f), host, service))
		num += 1
		if (limit > 0 and len(ret) >= limit) or (timelimit and timelimit <= time.time()):
			return num, len(d), ret
	return num, len(d), ret

def GetDowntime(host, service=None, limit=3, timelimit=0):
	Downtimes = ReadLogFile(conf.get("files", "NagiosLogFile"), host, service)
	num, max, ret = ReadLogDir(conf.get("files", "NagiosLogArchive"), host, service, 0, timelimit)
	num += 1
	max += 1
	Downtimes.extend(ret)
	Downtimes.sort(key=Downtime.GetEnd,reverse=True)
	print "<results>"
	print "  <data>"
	print "    <files-searched>%d</files-searched>" % (num + 1, )
	print "    <files-found>%d</files-found>" % (max + 1, )
	print "    <lines>%d</lines>" % (len(Downtimes), )
	print "    <limit>%d</limit>" % (limit, )
	print "  </data>"
	print "  <html>"
	if not Downtimes:
		print cgi.escape("<tr><td colspan=7>Keine Daten gefunden.</td></tr>")
	else:
		for i in xrange(len(Downtimes)):
			if not limit or i < limit:
				print cgi.escape(Downtimes[i].ToHTML())
			else:
				print cgi.escape(Downtimes[i].ToHTML(True))
	print "  </html>"
	print "</results>"

form = cgi.FieldStorage()

def CheckAccess():
	cgiconf = CGIConfig(conf.get("files", "CGIConfigFile"))
	if not "authorized_for_system_commands" in cgiconf:
		return False
	if "*" in cgiconf["authorized_for_system_commands"]:
		return True
	try:
		user = os.environ["REMOTE_USER"]
	except:
		return False
	if user in cgiconf["authorized_for_system_commands"]:
		return True
	return False

if not CheckAccess():
	sys.exit(0)

try:
	action = form["action"].value
except:
	action = "notification"
host = form["host"].value
try:
	service = form["service"].value
except:
	service = None
try:
	limit = int(form["limit"].value)
except:
	limit = 3
try:
	timelimit = int(form["timelimit"].value)
	if timelimit:
		timelimit += time.time()
except:
	timelimit = 0

if action == "notification":
	GetNotification(limit=limit, timelimit=timelimit)
elif action == "downtime":
	GetDowntime(host, service, limit=limit, timelimit=timelimit)
