ResumeSuspendedVMs()
{

echo "Resuming the suspended VMs by the preexec script on the VMWare ESX server $HOST:"
echo "=================================="

#Now, we go through the list of VMs which should be resumed.
cat $LIST_RUNNING_VMS_TO_SUSPEND | while read VMS
do
running=`vmware-cmd $VMS getstate | awk '{print $3}'`
echo
echo "VM $VMS is in <$running> state"
if [ "$running" = "suspended" ]; then
    echo "Let's resume the VM $VMS"
else
    echo "No need to resume the VM $VMS"
fi
if [ "$running" = "suspended" ] ; then
#If a VM is indeed suspended then we resume it.
/usr/bin/vmware-cmd $VMS start hard
sleep 1
echo "VM $VMS resumed"
fi
done
echo
echo "=================================="
echo
}


HOST=`/bin/hostname`
SCRIPT_DIR=/opt/omni/bin
LIST_RUNNING_VMS_TO_SUSPEND="/tmp/list_running_vms_to_suspend.tmp"
LIST_VMS_IN_HOT_TO_COMMIT="/tmp/list_running_vms_to_put_in_hot.tmp"


#First we check the existence of the list of suspended VMs which should be resumed.
if [ -s $LIST_RUNNING_VMS_TO_SUSPEND ]; then
    ResumeSuspendedVMs
#    rm $LIST_RUNNING_VMS_TO_SUSPEND
else
    echo "There are no suspended VMs to resume by the postexec script"
fi


#Then we check the existence of the list of VMs in hot mode which should be committed.
if [ -s $LIST_VMS_IN_HOT_TO_COMMIT ]; then
    $SCRIPT_DIR/DPvmware_commitop.pl
#    rm $LIST_VMS_IN_HOT_TO_COMMIT
else
    echo "There are no VMs in hot mode to commit by the postexec script"
fi
