VDF_OUTPUT="/tmp/vdf.tmp"
DF_OUTPUT="/tmp/df.tmp"
VMFS_VDF_OUTPUT="/tmp/vmfs_vdf.tmp"
VMFS_DF_OUTPUT="/tmp/vmfs_df.tmp"
VMFS_TO_MOUNT="/tmp/vmfs_to_mount.tmp"

if [ -s $VMFS_TO_MOUNT ]; then
    rm $VMFS_TO_MOUNT
fi

echo
echo "Mounting the VMFS file systems for Data Protector purposes"
echo "=================================="

echo
echo "/usr/sbin/vdf"
/usr/sbin/vdf
echo "=================================="

/usr/sbin/vdf | grep vmhba > ${VDF_OUTPUT} 2> /dev/null
`awk '{ print $1 "@" $6 }' $VDF_OUTPUT > $VMFS_VDF_OUTPUT`
rm $VDF_OUTPUT

echo
echo "/bin/df"
/bin/df
echo "=================================="

/bin/df | grep vmhba > ${DF_OUTPUT} 2> /dev/null
`awk '{ print $1 "@" $6 }' $DF_OUTPUT > $VMFS_DF_OUTPUT`
rm $DF_OUTPUT

for LINE in `awk '{ if (NF == 1) print $1 }' $VMFS_VDF_OUTPUT 2> /dev/null`
do
    FILESYSTEM=`echo $LINE|cut -f1 -d@`
    MOUNTPOINT=`echo $LINE|cut -f2 -d@`
    egrep $FILESYSTEM $VMFS_DF_OUTPUT > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo
        echo "VMFS file system $FILESYSTEM already mounted on /vmfs"
    else
        echo $LINE >> $VMFS_TO_MOUNT
    fi
done
rm $VMFS_VDF_OUTPUT
rm $VMFS_DF_OUTPUT

if [ -s $VMFS_TO_MOUNT ]; then
    cat $VMFS_TO_MOUNT
    echo "=================================="
    for LINE in `awk '{ if (NF == 1) print $1 }' $VMFS_TO_MOUNT 2> /dev/null`
    do
        FILESYSTEM=`echo $LINE|cut -f1 -d@`
        MOUNTPOINT=`echo $LINE|cut -f2 -d@`
        echo "Mounting $FILESYSTEM on /vmfs"
        /bin/mount -t vmfs ${FILESYSTEM} /vmfs
        echo
        echo "ls -l $MOUNTPOINT"
        ls -l ${MOUNTPOINT}
        echo "=================================="
    done
fi

echo
/bin/df
echo "=================================="