#!/usr/bin/perl

use VMware::Control::Server;
use VMware::Control::VM;

$data_file="/tmp/list_running_vms_to_put_in_hot.tmp";
open(DAT,"$data_file") || die("Could not open file!");

$server = VMware::Control::Server::new();

$err = $server->connect();
if (!defined($err)) 
{
   ($errorNumber, $errorString) = $server->get_last_error();
   print "Server connect error: ", $errorString, "\n";
   exit;
}

@raw_data=<DAT>;
foreach $pair (@raw_data)
{
   chop($pair);
   ($cfg,$disk)=split(/\ /,$pair);

   $vm = VMware::Control::VM::new($server, $cfg);
   $err = $vm->connect();
   if (!defined($err)) 
   {
      ($errorNumber, $errorString) = $vm->get_last_error();
      print "VM connect error: ", $errorString, "\n";
      exit;
   }

   print "\n";
   print "Committing disk $disk on $cfg\n";
   $err = $vm->commit($disk, 0, 0, 1);
   if (!defined($err)) 
   {
      ($errorNumber, $errorString) = $vm->get_last_error();
      print "VM commit error: ", $errorString, "\n";
      $vm->disconnect();
      exit;
   }

   print "Disk $disk on $cfg is committed\n";
   print "\n";
   $vm->disconnect();

}

$server->disconnect();