#!/usr/bin/perl

use VMware::Control::Server;
use VMware::Control::VM;

$cfg = $ARGV[0];

$server = VMware::Control::Server::new();

$err = $server->connect();
if (!defined($err)) 
{
   ($errorNumber, $errorString) = $server->get_last_error();
   print "Server connect error: ", $errorString, "\n";
   #QXCM1000358754 - exiting with status = 1 on error
   exit 1;
}

$vm = VMware::Control::VM::new($server, $cfg);
$err = $vm->connect();
if (!defined($err)) 
{
   ($errorNumber, $errorString) = $vm->get_last_error();
   print "VM connect error: ", $errorString, "\n";
   #QXCM1000358754 - exiting with status = 1 on error
   exit 1;
}

$data_file="/tmp/list_running_vms_to_put_in_hot.tmp";
open(DAT,">>$data_file") || die("Could not open file!");

@devices = @{ $vm->get("Status.devices") };
foreach $disk (@devices) 
{
   #print "$disk\n";
   if ($disk =~ "ethernet" || $disk !~ ":" || $disk =~ "ide") 
   {
   next;
   }
   # Skip the CD-ROM devices
   my $deviceType = $vm->get("Config.$disk.deviceType");
   if ($deviceType eq "atapi-cdrom" || $deviceType eq "cdrom-image") 
   {
   next;
   }
   $err = $vm->add_redo($disk);
   if (!defined($err)) 
   {
   ($errorNumber, $errorString) = $vm->get_last_error();
   print "VM add redo log error: ", $errorString, "\n";
   close(DAT);
   #QXCM1000358754 - exiting with status = 1 on error
   exit 1;
   }

   print DAT "$cfg $disk\n";
}

close(DAT);

$vm->disconnect();
$server->disconnect();

