#!/bin/ksh
# **********************************************************
#                                                          *
#      HP OpenView Data Protector                          *
#                                                          *
#      MS Exchange 2000/2003 ZDB                           *
#      Ported into shell script                            *
#                                                          *
#      Version: 1.1                                        *
#      Last modified: 05.03.2004                           *
#                                                          *
# **********************************************************

# **********************************************************
#    Description/ Usage:
#
# This script contains some examples for creating Disk Array XP and Virtual Array Exchange 2000/2003 ZDB backup specifications (datalists). Perform the following steps to create a backup specification using this script:
#
#         1. delete the # statement before the appropriate omnicreatedl command
#         2. replace parameters specified in <> with the real ones (datalist name, application hostname, backup hostname, etc)
#         3. set additional parameters (optional)
#         3. save the script
#         4. run the script from the command line
#
# **********************************************************

# Creating a backup specification for all storage groups running on Exchange 2000/2003 Server app.company.com with HP XP Array local mirror backup system:
# EXAMPLE: ./omnicreatedl -ex2000 -datalist EX2000_ex1 -device dev1 -all_storage_groups -split_mirror -sse -local app.company.com bckp.company.com

# ./omnicreatedl -ex2000 -datalist <name> -device <name> -all_storage_groups -split_mirror -sse -local <app_sys> <bck_sys>



# Creating a backup specification for all storage groups running on Exchange 2000/2003 Server app.company.com with Virtual Array backup system bckp.company.com:
# EXAMPLE: ./omnicreatedl -ex2000 -datalist EX2000_ex2 -device dev1 -all_storage_groups -snapshot -va app.company.com bckp.company.com

# ./omnicreatedl -ex2000 -datalist <name> -device <name> -all_storage_groups -snapshot -va <app_sys> <bck_sys>




# Creating a backup specification for two storage groups ("First Storage Group", "Second Storage Group") running on Exchange 2000/2003 Server app.company.com with HP XP Array remote mirror backup system:
# EXAMPLE: ./omnicreatedl -ex2000 -datalist EX2000_ex3 -device dev1 -storage_group "First Storage Group" -storage_group "Second Storage Group" -split_mirror -sse -remote app.company.com bckp.company.com

# ./omnicreatedl -ex2000 -datalist <name> -device <name> -storage_group <storage group name 1> -storage_group <storage group name 2> -split_mirror -sse -remote <app_sys> <bck_sys>




# Creating a backup specification for two stores (Mailbox, Public, part of First Storage Group) running on Exchange 2000/2003 Server app.company.com with HP XP Array combined mirror backup system:
# EXAMPLE: ./omnicreatedl -ex2000 -datalist EX2000_ex4 -device dev1 -storage_group "First Storage Group" -store "Mailbox" "Public" -split_mirror -sse -combined app.company.com bckp.company.com

# ./omnicreatedl -ex2000 -datalist <name> -device <name> -storage_group <storage group name> -store <store 1> <store 2> -split_mirror -sse -combined <app_sys> <bck_sys>




# Creating a backup specification for backing up Site Replication Service running on app.company.com with Virtual Array backup system bckp.company.com:
# EXAMPLE: ./omnicreatedl -ex2000 -datalist EX2000_ex5 -device  -annotation SRS -snapshot -VA app.company.com bckp.company.com

# ./omnicreatedl -ex2000 -datalist <name> -device <name> -annotation SRS -snapshot -VA <app_sys> <bck_sys>




# Creating a backup specification for backing up Key Management Service running on app.company.com with Virtual Array backup system bckp.company.com:
# EXAMPLE: ./omnicreatedl -ex2000 -datalist EX2000_ex6 -device  -annotation KMS -snapshot -VA app.company.com bckp.company.com

# ./omnicreatedl -ex2000 -datalist <name> -device <name> -annotation KMS -snapshot -VA <app_sys> <bck_sys>



# Cluster configuration: Creating backup specification for all storage groups running on Exchange 2000/2003 Server excluster.hermes.si (Exchange 2000/2003 virtual server name) with HP XP Array local mirror backup system. Cluster virtual server name is xpcluster,hermes.si:
# EXAMPLE: ./omnicreatedl -ex2000 -datalist EX2000_ex1 -device dev1 -all_storage_groups -split_mirror -sse -local xpcluster.hermes.si bckp.company.com -virtualSrv excluster.hermes.si

# ./omnicreatedl -ex2000 -datalist <name> -device <name> -all_storage_groups -split_mirror -sse -local <app_sys_(cluster_virtual_srv)> <bck_sys> -virtualSrv <exchange_virtual_server>

