/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ReportUtil {
    public String m_debug = "1-99";
    public String m_debugFile = "JAVA";
    public String rpttitle = null;
    public String rptfooter = null;
    public String rptcontent = null;
    OmnibackCore m_crs = null;
    OmnibackCore m_database = null;
    public int crs_port = 5555;
    public DBData m_curData = null;
    public RptParams rpt = null;
    public String report_name = null;
    public String notification_name = null;
    public int notification_id = 0;
    public int notification_Multiple = 0;
    public MethodStruct method = null;
    private String[] med_stat = new String[]{"Poor", "Fair", "Good"};
    private int med_stat_no = 3;
    private String[] med_class = new String[]{"DDS", "QIC", "ExaByte", "AIT", "T3480/T4890/T9490", "Optical", "File", "T9840", "Tape", "DLT", "SD-3", "T3590", "LTO-Ultrium", "SuperDLT", "VXA", "DTF", "T9940"};
    private int med_class_no = 17;
    private static int RPT_PARAM_UNDEF = -1;
    private static int RPT_PARAM_DL = 0;
    private static int RPT_PARAM_GROUP = 1;
    private static int RPT_PARAM_TIMEFRAME = 2;
    private static int RPT_PARAM_NO_DAYS = 3;
    private static int RPT_PARAM_DOMAINS = 4;
    private static int RPT_PARAM_HOST = 5;
    private static int RPT_PARAM_LABEL = 6;
    private static int RPT_PARAM_LOCATION = 7;
    private static int RPT_PARAM_POOL = 8;
    private static int RPT_PARAM_CLASS = 9;
    private static int RPT_PARAM_STATUS = 10;
    private static int RPT_PARAM_PROTECTION = 11;
    private static int RPT_PARAM_SESSION_ID = 12;
    private static int RPT_PARAM_DEVICE = 13;
    private static int RPT_PARAM_SLOT = 14;
    private static int RPT_PARAM_MEDIUM_ID = 15;
    private static int RPT_PARAM_HOSTS = 16;
    private static int RPT_PARAM_MESSAGE = 17;
    private static int RPT_PARAM_SERVER = 18;
    private static int RPT_PARAM_LEVEL = 20;
    private static int RPT_PARAM_DAYS = 21;
    private static int RPT_PARAM_LIBRARY = 22;
    private static int RPT_PARAM_HEADER = 23;
    private ReportConst report = new ReportConst();

    public ReportUtil(String string, String string2) {
        this.m_debug = string;
        this.m_debugFile = string2;
    }

    public int getReport(OBCell oBCell, int n) {
        int n2;
        String string = oBCell.name;
        if (oBCell.MOM == 1) {
            string = oBCell.real_name;
            this.rpt.multi_cell = 1;
        }
        this.m_crs = new OmnibackCore(string, this.crs_port);
        if (!this.m_crs.Connect()) {
            return -1;
        }
        IpcMsg ipcMsg = IpcMsg.makeHeaderOptions(this.m_debug, this.m_debugFile);
        this.m_database = this.m_crs.StartSession(2, ipcMsg);
        if (this.m_database == null) {
            this.m_crs.Disconnect();
            return -1;
        }
        ipcMsg = this.rpt.multi_cell == 1 ? new IpcMsg(2002) : new IpcMsg(2000);
        ipcMsg.append(this.rpt.com);
        if (this.rpt.datalists != null && this.rpt.datalists.size() > 0) {
            ipcMsg.append(RPT_PARAM_DL);
            ipcMsg.append(this.rpt.datalists.size());
            for (n2 = 0; n2 < this.rpt.datalists.size(); ++n2) {
                ipcMsg.append((String)this.rpt.datalists.elementAt(n2));
            }
        }
        if (this.rpt.group != null && !this.rpt.group.equals("")) {
            ipcMsg.append(RPT_PARAM_GROUP);
            ipcMsg.append(this.rpt.group);
        }
        ipcMsg.append(RPT_PARAM_TIMEFRAME);
        ipcMsg.append(this.rpt.startTime);
        ipcMsg.append(this.rpt.duration);
        ipcMsg.append(this.rpt.endTime);
        if (this.rpt.label != null && !this.rpt.label.equals("")) {
            ipcMsg.append(RPT_PARAM_LABEL);
            ipcMsg.append(this.rpt.label);
        }
        if (this.rpt.location != null && this.rpt.location.size() > 0) {
            ipcMsg.append(RPT_PARAM_LOCATION);
            ipcMsg.append(this.rpt.location.size());
            for (n2 = 0; n2 < this.rpt.location.size(); ++n2) {
                ipcMsg.append((String)this.rpt.location.elementAt(n2));
            }
        }
        if (this.rpt.pool != null && this.rpt.pool.size() > 0) {
            ipcMsg.append(RPT_PARAM_POOL);
            ipcMsg.append(this.rpt.pool.size());
            for (n2 = 0; n2 < this.rpt.pool.size(); ++n2) {
                ipcMsg.append((String)this.rpt.pool.elementAt(n2));
            }
        }
        if (this.rpt.libVec != null && this.rpt.libVec.size() > 0) {
            ipcMsg.append(RPT_PARAM_LIBRARY);
            ipcMsg.append(this.rpt.libVec.size());
            ipcMsg.append(this.rpt.library);
            for (n2 = 0; n2 < this.rpt.libVec.size(); ++n2) {
                ipcMsg.append((String)this.rpt.libVec.elementAt(n2));
            }
        }
        if (this.rpt.mediaclass != -1L) {
            ipcMsg.append(RPT_PARAM_CLASS);
            ipcMsg.append(this.rpt.mediaclass);
        }
        if (this.rpt.protection >= -1) {
            ipcMsg.append(RPT_PARAM_PROTECTION);
            ipcMsg.append(this.rpt.protection);
        }
        if (this.rpt.status >= 0) {
            ipcMsg.append(RPT_PARAM_STATUS);
            ipcMsg.append(this.rpt.status);
        }
        if (this.rpt.header != 0) {
            ipcMsg.append(RPT_PARAM_HEADER);
            ipcMsg.append(this.rpt.header);
        }
        if (this.rpt.server != null && !this.rpt.server.equals("")) {
            ipcMsg.append(RPT_PARAM_SERVER);
            ipcMsg.append(this.rpt.server);
        }
        if (this.rpt.nodays >= 0) {
            ipcMsg.append(RPT_PARAM_NO_DAYS);
            ipcMsg.append(this.rpt.nodays);
        }
        if (this.rpt.days > 0) {
            ipcMsg.append(RPT_PARAM_DAYS);
            ipcMsg.append(this.rpt.days);
        }
        if (this.rpt.host != null && !this.rpt.host.equals("")) {
            ipcMsg.append(RPT_PARAM_HOST);
            ipcMsg.append(this.rpt.host);
        }
        if (this.rpt.sessionId != null && !this.rpt.sessionId.equals("")) {
            ipcMsg.append(RPT_PARAM_SESSION_ID);
            ipcMsg.append(this.rpt.sessionId);
        }
        if (this.rpt.device != null && !this.rpt.device.equals("")) {
            ipcMsg.append(RPT_PARAM_DEVICE);
            ipcMsg.append(this.rpt.device);
        }
        if (this.rpt.slot != null && !this.rpt.slot.equals("")) {
            ipcMsg.append(RPT_PARAM_SLOT);
            ipcMsg.append(this.rpt.slot);
        }
        if (this.rpt.mediumId != null && !this.rpt.mediumId.equals("")) {
            ipcMsg.append(RPT_PARAM_MEDIUM_ID);
            ipcMsg.append(this.rpt.mediumId);
        }
        if (this.rpt.message != null && !this.rpt.message.equals("")) {
            ipcMsg.append(RPT_PARAM_MESSAGE);
            ipcMsg.append(this.rpt.message);
        }
        if (this.rpt.level != -1) {
            ipcMsg.append(RPT_PARAM_LEVEL);
            ipcMsg.append(this.rpt.level);
        }
        if (this.rpt.hosts != null && this.rpt.hosts.size() > 0) {
            ipcMsg.append(RPT_PARAM_HOSTS);
            ipcMsg.append(this.rpt.hosts.size());
            for (n2 = 0; n2 < this.rpt.hosts.size(); ++n2) {
                ipcMsg.append((String)this.rpt.hosts.elementAt(n2));
            }
        }
        if (this.rpt.domains != null && this.rpt.domains.size() > 0) {
            ipcMsg.append(RPT_PARAM_DOMAINS);
            ipcMsg.append(this.rpt.domains.size());
            for (n2 = 0; n2 < this.rpt.domains.size(); ++n2) {
                ipcMsg.append((String)this.rpt.domains.elementAt(n2));
            }
        }
        ipcMsg.append(RPT_PARAM_UNDEF);
        if (this.m_database.DBReportQueryStart(ipcMsg, 2001) == -1) {
            this.m_crs.Disconnect();
            this.m_database.Disconnect();
            return -1;
        }
        return 0;
    }

    public DBData getReportBuf() {
        DBData dBData = this.m_database.DBReportQuery(2001);
        return dBData;
    }

    public void disconnect() {
        this.m_crs.Disconnect();
        this.m_database.Disconnect();
    }

    public int GetWebAccess(String string, String string2) {
        this.m_curData = null;
        this.m_crs = new OmnibackCore(string, this.crs_port);
        if (!this.m_crs.Connect()) {
            return -1;
        }
        IpcMsg ipcMsg = IpcMsg.makeHeaderOptions(this.m_debug, this.m_debugFile);
        this.m_curData = this.m_crs.CsaGetSingleFile(20, 0);
        if (this.m_curData == null) {
            return -1;
        }
        if (this.m_curData.size() != 0) {
            int n;
            String string3 = this.m_curData.strParseNext();
            int n2 = string3.length();
            if (n2 != (n = string2.length()) * 4) {
                return -2;
            }
            char[] cArray = new char[string3.length() + 1];
            char[] cArray2 = new char[string2.length() + 1];
            string3.getChars(0, string3.length(), cArray, 0);
            string2.getChars(0, string2.length(), cArray2, 0);
            for (int i = 0; i < string2.length(); ++i) {
                if ((cArray[i * 4] & 0xFF) != (cArray2[i] & 0xF) + 66) {
                    return -2;
                }
                if ((cArray[i * 4 + 1] & 0xFF) != ((cArray2[i] & 0xF0) >> 4) + 66) {
                    return -2;
                }
                if ((cArray[i * 4 + 2] & 0xFF) != ((cArray2[i] & 0xF00) >> 8) + 66) {
                    return -2;
                }
                if ((cArray[i * 4 + 3] & 0xFF) == ((cArray2[i] & 0xF000) >> 12) + 66) continue;
                return -2;
            }
        }
        if ((this.m_crs.GetRights() & 0x20000) == 0) {
            return -3;
        }
        return 0;
    }

    public NotificationStruct GetNotification(String string, String string2) {
        NotificationStruct notificationStruct = null;
        NotificationStruct notificationStruct2 = new NotificationStruct();
        notificationStruct2.name = string2;
        this.m_curData = null;
        this.m_crs = new OmnibackCore(string, this.crs_port);
        if (!this.m_crs.Connect()) {
            return notificationStruct2;
        }
        String string3 = this.m_crs.CsaGetNotification(string2);
        if (string3 != null) {
            notificationStruct = this.parseNotification(string3);
        }
        if (notificationStruct != null) {
            return notificationStruct;
        }
        return notificationStruct2;
    }

    NotificationStruct parseNotification(String string) {
        int n = 0;
        parser parser2 = new parser(string);
        NotificationStruct notificationStruct = new NotificationStruct();
        ReportStruct reportStruct = null;
        MethodStruct methodStruct = null;
        block18: while (parser2.nextToken()) {
            String string2;
            String string3 = parser2.value;
            if (string3.equals("NOTIFICATION") || string3.equals("NAME")) {
                if (n != 0) {
                    return null;
                }
                parser2.nextToken();
                notificationStruct.name = parser2.value;
                OB2Debug.DbgPlain(20, "Parsing notification : " + notificationStruct.name);
                continue;
            }
            if (string3.equals("REPORT")) {
                if (n != 1) {
                    return null;
                }
                reportStruct = new ReportStruct();
                parser2.nextToken();
                reportStruct.name = parser2.value;
                parser2.nextToken();
                if (!parser2.value.equals("{")) {
                    return null;
                }
                ++n;
                parser2.nextToken();
                if (!parser2.value.equals("ID")) {
                    return null;
                }
                parser2.nextToken();
                reportStruct.rpt.com = this.report.ReportIDFromName(parser2.value);
                if (reportStruct.rpt.com != -1) continue;
                return null;
            }
            if (string3.equals("MULTICELL")) {
                if (n != 2) {
                    return null;
                }
                reportStruct.rpt.multi_cell = 1;
                continue;
            }
            if (string3.equals("HEADER")) {
                if (n != 2) {
                    return null;
                }
                reportStruct.rpt.header = 1;
                continue;
            }
            if (string3.equals("LEVEL")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                try {
                    reportStruct.rpt.level = Integer.parseInt(parser2.value);
                }
                catch (Exception exception) {
                    reportStruct.rpt.level = -1;
                }
                continue;
            }
            if (string3.equals("MULTIPLE")) {
                reportStruct.rpt.multiple = 1;
                continue;
            }
            if (string3.equals("DATALIST")) {
                if (n != 2) {
                    return null;
                }
                reportStruct.rpt.datalists = new Vector();
                while (parser2.checkToken() == 1) {
                    parser2.nextToken();
                    reportStruct.rpt.datalists.addElement(parser2.value);
                }
                continue;
            }
            if (string3.equals("GROUP")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                reportStruct.rpt.group = parser2.value;
                continue;
            }
            if (string3.equals("HOST")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                reportStruct.rpt.host = parser2.value;
                continue;
            }
            if (string3.equals("DEVICE")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                reportStruct.rpt.device = parser2.value;
                continue;
            }
            if (string3.equals("LABEL")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                reportStruct.rpt.label = parser2.value;
                continue;
            }
            if (string3.equals("LOCATION")) {
                reportStruct.rpt.location = new Vector();
                while (parser2.checkToken() == 1) {
                    parser2.nextToken();
                    reportStruct.rpt.location.addElement(parser2.value);
                }
                continue;
            }
            if (string3.equals("POOL")) {
                reportStruct.rpt.pool = new Vector();
                while (parser2.checkToken() == 1) {
                    parser2.nextToken();
                    reportStruct.rpt.pool.addElement(parser2.value);
                }
                continue;
            }
            if (string3.equals("LIBRARY")) {
                reportStruct.rpt.library = 1;
                reportStruct.rpt.libVec = new Vector();
                while (parser2.checkToken() == 1) {
                    parser2.nextToken();
                    reportStruct.rpt.libVec.addElement(parser2.value);
                }
                continue;
            }
            if (string3.equals("NO_LIBRARY")) {
                reportStruct.rpt.library = -1;
                reportStruct.rpt.libVec = new Vector();
                while (parser2.checkToken() == 1) {
                    parser2.nextToken();
                    reportStruct.rpt.libVec.addElement(parser2.value);
                }
                continue;
            }
            if (string3.equals("STATUS")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                string2 = parser2.value;
                for (int i = 0; i < this.med_stat_no; ++i) {
                    if (!this.med_stat[i].equalsIgnoreCase(string2)) continue;
                    reportStruct.rpt.status = i;
                    continue block18;
                }
                continue;
            }
            if (string3.equals("CLASS")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                string2 = parser2.value;
                for (int i = 0; i < this.med_class_no; ++i) {
                    if (!this.med_class[i].equalsIgnoreCase(string2)) continue;
                    reportStruct.rpt.mediaclass = i;
                    continue block18;
                }
                continue;
            }
            if (string3.equals("NO_DAYS")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                try {
                    reportStruct.rpt.nodays = new Integer(parser2.value);
                    continue;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (string3.equals("DAYS")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                try {
                    reportStruct.rpt.days = new Integer(parser2.value);
                    continue;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (string3.equals("PROTECTION")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                try {
                    reportStruct.rpt.protection = new Integer(parser2.value);
                    continue;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (string3.equals("DOMAIN")) {
                if (n != 2) {
                    return null;
                }
                reportStruct.rpt.domains = new Vector();
                while (parser2.checkToken() == 1) {
                    parser2.nextToken();
                    reportStruct.rpt.domains.addElement(parser2.value);
                }
                continue;
            }
            if (string3.equals("SESSION")) {
                String string4;
                block106: {
                    if (n != 2) {
                        return null;
                    }
                    parser2.nextToken();
                    StringTokenizer stringTokenizer = new StringTokenizer(parser2.value);
                    string2 = null;
                    string4 = null;
                    try {
                        string2 = new String(stringTokenizer.nextToken("-"));
                        string4 = new String(stringTokenizer.nextToken("-"));
                        int n2 = new Integer(string4);
                        if (n2 < 1) {
                            return null;
                        }
                        if (n2 < 10) {
                            string4 = "000" + n2;
                            break block106;
                        }
                        if (n2 < 100) {
                            string4 = "00" + n2;
                            break block106;
                        }
                        if (n2 < 1000) {
                            string4 = "0" + n2;
                            break block106;
                        }
                        if (n2 < 10000) {
                            string4 = "" + n2;
                            break block106;
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        OB2Debug.DbgPlain(10, "Error parsing sessionID:");
                        OB2Debug.DbgPlain(10, exception.toString());
                        return null;
                    }
                }
                reportStruct.rpt.sessionId = string2 + " " + string4;
                continue;
            }
            if (string3.equals("TIMEFRAME")) {
                if (n != 2) {
                    return null;
                }
                parser2.nextToken();
                try {
                    reportStruct.rpt.startTime = new Integer(parser2.value).longValue() * 3600L;
                    try {
                        parser2.nextToken();
                        reportStruct.rpt.duration = new Integer(parser2.value).longValue() * 3600L;
                        continue;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    try {
                        parser2.nextToken();
                        reportStruct.rpt.startTime = new Integer(parser2.value).longValue();
                    }
                    catch (Exception exception2) {
                        return null;
                    }
                    try {
                        parser2.nextToken();
                        reportStruct.rpt.endTime = new Integer(parser2.value).longValue();
                    }
                    catch (Exception exception3) {
                        return null;
                    }
                    if (reportStruct.rpt.endTime <= reportStruct.rpt.startTime) {
                        return null;
                    }
                    reportStruct.rpt.duration = 0L;
                    continue;
                }
            }
            if (string3.equals("MAIL") || string3.equals("SMTP") || string3.equals("LOG") || string3.equals("BROADCAST") || string3.equals("EXTERNAL") || string3.equals("SNMP")) {
                if (n != 2) {
                    return null;
                }
                methodStruct = new MethodStruct();
                if (string3.equals("MAIL")) {
                    methodStruct.type = 1;
                } else if (string3.equals("SMTP")) {
                    methodStruct.type = 2;
                } else if (string3.equals("LOG")) {
                    methodStruct.type = 6;
                } else if (string3.equals("BROADCAST")) {
                    methodStruct.type = 3;
                } else if (string3.equals("EXTERNAL")) {
                    methodStruct.type = 5;
                } else if (string3.equals("SNMP")) {
                    methodStruct.type = 4;
                }
                parser2.nextToken();
                if (!parser2.value.equals("{")) {
                    return null;
                }
                ++n;
                parser2.nextToken();
                if (!parser2.value.equals("TYPE")) {
                    return null;
                }
                parser2.nextToken();
                string3 = parser2.value;
                if (string3.equals("ASCII")) {
                    methodStruct.format = 2;
                } else if (string3.equals("SHORT")) {
                    methodStruct.format = 4;
                } else if (string3.equals("HTML")) {
                    methodStruct.format = 1;
                } else if (string3.equals("TAB")) {
                    methodStruct.format = 8;
                } else {
                    return null;
                }
                parser2.nextToken();
                if (!parser2.value.equals("TO")) {
                    return null;
                }
                methodStruct.to = new Vector();
                while (parser2.checkToken() == 1) {
                    parser2.nextToken();
                    methodStruct.to.addElement(parser2.value);
                }
                if (reportStruct.methods == null) {
                    reportStruct.methods = new Vector();
                }
                reportStruct.methods.addElement(methodStruct);
                continue;
            }
            if (string3.equals("{")) {
                ++n;
                continue;
            }
            if (string3.equals("}")) {
                if (--n < 0) {
                    return null;
                }
                if (n != 1 || reportStruct == null) continue;
                if (notificationStruct.reports == null) {
                    notificationStruct.reports = new Vector();
                }
                notificationStruct.reports.addElement(reportStruct);
                reportStruct = null;
                continue;
            }
            return null;
        }
        return notificationStruct;
    }

    public int saveReport(OBCell oBCell) {
        NotificationStruct notificationStruct = null;
        ReportStruct reportStruct = null;
        String string = "";
        if (this.notification_name != null) {
            notificationStruct = new NotificationStruct();
            notificationStruct.name = this.notification_name;
            notificationStruct.reports = new Vector();
            if (oBCell.notifications == null) {
                oBCell.notifications = new Vector();
            }
            oBCell.notifications.addElement(notificationStruct);
        } else if (this.notification_id != -1) {
            notificationStruct = (NotificationStruct)oBCell.notifications.elementAt(this.notification_id);
            if (notificationStruct.reports == null) {
                notificationStruct.reports = new Vector();
            }
            this.notification_name = notificationStruct.name;
        } else {
            return -1;
        }
        reportStruct = new ReportStruct();
        reportStruct.name = this.report_name;
        reportStruct.rpt = this.rpt;
        reportStruct.rpt.multiple = this.notification_Multiple;
        if (this.method != null) {
            reportStruct.methods = new Vector();
            reportStruct.methods.addElement(this.method);
            this.method = null;
        }
        notificationStruct.reports.addElement(reportStruct);
        string = "NAME ";
        string = string + "\"" + notificationStruct.name + "\"\n{\n";
        for (int i = 0; i < notificationStruct.reports.size(); ++i) {
            Object object;
            int n;
            reportStruct = (ReportStruct)notificationStruct.reports.elementAt(i);
            string = string + "    REPORT ";
            string = string + "\"" + reportStruct.name + "\"\n    {\n";
            string = string + "        ID ";
            string = string + "\"" + this.report.ReportNameFromID(reportStruct.rpt.com) + "\"" + "\n";
            if (reportStruct.rpt.multi_cell == 1) {
                string = string + "\tMULTICELL\n";
            }
            if (reportStruct.rpt.datalists != null) {
                string = string + "        DATALIST\n";
                for (n = 0; n < reportStruct.rpt.datalists.size(); ++n) {
                    string = string + "            \"" + (String)reportStruct.rpt.datalists.elementAt(n) + "\"\n";
                }
            }
            if (reportStruct.rpt.multiple != 0) {
                string = string + "\tMULTIPLE\n";
            }
            if (reportStruct.rpt.header != 0) {
                string = string + "\tHEADER\n";
            }
            if (reportStruct.rpt.group != null && !reportStruct.rpt.group.equals("")) {
                string = string + "        GROUP \"" + reportStruct.rpt.group + "\"\n";
            }
            if (reportStruct.rpt.level != -1) {
                string = string + "        LEVEL \"" + reportStruct.rpt.level + "\"\n";
            }
            if (reportStruct.rpt.nodays > 0) {
                string = string + "        NO_DAYS " + reportStruct.rpt.nodays + "\n";
            }
            if (reportStruct.rpt.days > 0) {
                string = string + "        DAYS " + reportStruct.rpt.days + "\n";
            }
            if (reportStruct.rpt.protection >= -1) {
                string = string + "        PROTECTION " + reportStruct.rpt.protection + "\n";
            }
            if (reportStruct.rpt.label != null && !reportStruct.rpt.label.equals("")) {
                string = string + "        LABEL \"" + reportStruct.rpt.label + "\"\n";
            }
            if (reportStruct.rpt.location != null) {
                string = string + "        LOCATION\n";
                for (n = 0; n < reportStruct.rpt.location.size(); ++n) {
                    string = string + "            \"" + (String)reportStruct.rpt.location.elementAt(n) + "\"\n";
                }
            }
            if (reportStruct.rpt.pool != null) {
                string = string + "        POOL\n";
                for (n = 0; n < reportStruct.rpt.pool.size(); ++n) {
                    string = string + "            \"" + (String)reportStruct.rpt.pool.elementAt(n) + "\"\n";
                }
            }
            if (reportStruct.rpt.libVec != null) {
                if (reportStruct.rpt.library == 1) {
                    string = string + "        LIBRARY\n";
                    for (n = 0; n < reportStruct.rpt.libVec.size(); ++n) {
                        string = string + "            \"" + (String)reportStruct.rpt.libVec.elementAt(n) + "\"\n";
                    }
                } else if (reportStruct.rpt.library == -1) {
                    string = string + "        NO_LIBRARY\n";
                    for (n = 0; n < reportStruct.rpt.libVec.size(); ++n) {
                        string = string + "            \"" + (String)reportStruct.rpt.libVec.elementAt(n) + "\"\n";
                    }
                }
            }
            if (reportStruct.rpt.status >= 0) {
                string = string + "        STATUS \"" + this.med_stat[reportStruct.rpt.status] + "\"\n";
            }
            if (reportStruct.rpt.mediaclass >= 1L) {
                string = string + "        CLASS \"" + this.med_class[(int)reportStruct.rpt.mediaclass] + "\"\n";
            }
            if (reportStruct.rpt.host != null && !reportStruct.rpt.host.equals("")) {
                string = string + "        HOST \"" + reportStruct.rpt.host + "\"\n";
            }
            if (reportStruct.rpt.device != null && !reportStruct.rpt.device.equals("")) {
                string = string + "        DEVICE \"" + reportStruct.rpt.device + "\"\n";
            }
            if (reportStruct.rpt.sessionId != null && !reportStruct.rpt.sessionId.equals("")) {
                string = string + "        SESSION \"";
                object = new StringTokenizer(reportStruct.rpt.sessionId);
                string = string + ((StringTokenizer)object).nextToken(" ") + "-" + new Integer(((StringTokenizer)object).nextToken(" ")) + "\"\n";
            }
            if (reportStruct.rpt.domains != null) {
                string = string + "        DOMAIN\n";
                for (n = 0; n < reportStruct.rpt.domains.size(); ++n) {
                    string = string + "            \"" + (String)reportStruct.rpt.domains.elementAt(n) + "\"\n";
                }
            }
            if (reportStruct.rpt.startTime != 0L || reportStruct.rpt.endTime != Integer.MAX_VALUE) {
                string = reportStruct.rpt.duration != 0L ? string + "        TIMEFRAME " + reportStruct.rpt.startTime / 3600L + " " + reportStruct.rpt.duration / 3600L + "\n" : string + "        TIMEFRAME : " + reportStruct.rpt.startTime + " " + reportStruct.rpt.endTime + "\n";
            }
            if (reportStruct.methods != null) {
                for (n = 0; n < reportStruct.methods.size(); ++n) {
                    object = (MethodStruct)reportStruct.methods.elementAt(n);
                    switch (((MethodStruct)object).type) {
                        case 1: {
                            string = string + "        MAIL\n        {\n";
                            break;
                        }
                        case 2: {
                            string = string + "        SMTP\n        {\n";
                            break;
                        }
                        case 6: {
                            string = string + "        LOG\n        {\n";
                            break;
                        }
                        case 3: {
                            string = string + "        BROADCAST\n        {\n";
                            break;
                        }
                        case 5: {
                            string = string + "        EXTERNAL\n        {\n";
                            break;
                        }
                        case 4: {
                            string = string + "        SNMP\n        {\n";
                        }
                    }
                    switch (((MethodStruct)object).format) {
                        case 2: {
                            string = string + "            TYPE ASCII\n";
                            break;
                        }
                        case 1: {
                            string = string + "            TYPE HTML\n";
                            break;
                        }
                        case 4: {
                            string = string + "            TYPE SHORT\n";
                            break;
                        }
                        case 8: {
                            string = string + "            TYPE TAB\n";
                        }
                    }
                    if (((MethodStruct)object).to != null) {
                        string = string + "            TO\n";
                        for (int j = 0; j < ((MethodStruct)object).to.size(); ++j) {
                            string = string + "                \"" + (String)((MethodStruct)object).to.elementAt(j) + "\"\n";
                        }
                    }
                    string = string + "        }\n";
                }
            }
            string = string + "    }\n";
        }
        string = string + "}\n";
        this.m_crs = !oBCell.name.equals("MULTICELL") ? new OmnibackCore(oBCell.name, this.crs_port) : new OmnibackCore(oBCell.real_name, this.crs_port);
        if (!this.m_crs.Connect()) {
            return -1;
        }
        if (this.m_crs.CsaPutNotification(this.notification_name, string) == -1) {
            return -1;
        }
        return 0;
    }

    public int SaveNotificationRecord(OBCell oBCell) {
        String string = this.makeBuffNotifs(oBCell.notifs);
        this.m_curData = null;
        this.m_crs = new OmnibackCore(oBCell.name, this.crs_port);
        if (!this.m_crs.Connect()) {
            return 0;
        }
        return this.m_crs.CsaPutSingleFile(24, 1, string);
    }

    public int DeleteNotification(OBCell oBCell, String string) {
        Enumeration enumeration = oBCell.notifs.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            NotificationItem notificationItem = (NotificationItem)enumeration.nextElement();
            if (notificationItem.name.equals(string)) break;
            ++n;
        }
        if (n >= oBCell.notifs.size()) {
            return 0;
        }
        oBCell.notifs.removeElementAt(n);
        return this.SaveNotificationRecord(oBCell);
    }

    public Vector parseNotifs(Vector vector, String string) {
        Vector vector2 = vector;
        NotificationItem notificationItem = null;
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return vector;
        }
        parser parser2 = new parser(string);
        while (parser2.nextToken()) {
            String string2 = new String(parser2.value);
            if (string2.equals("NOTIFICATION")) {
                n2 = 0;
                notificationItem = new NotificationItem();
                if (parser2.nextToken()) {
                    notificationItem.name = parser2.value;
                    continue;
                }
                return vector;
            }
            if (string2.equals("{")) {
                if (notificationItem == null) {
                    return vector;
                }
                ++n;
                continue;
            }
            if (string2.equals("-event")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                string2 = parser2.value;
                if (string2.equals("DeviceError")) {
                    notificationItem.eventID = 0;
                    continue;
                }
                if (string2.equals("EndOfSession")) {
                    notificationItem.eventID = 1;
                    continue;
                }
                if (string2.equals("MountRequest")) {
                    notificationItem.eventID = 2;
                    continue;
                }
                if (string2.equals("CRSFailOver")) {
                    notificationItem.eventID = 3;
                    continue;
                }
                if (string2.equals("DbSpaceLow")) {
                    notificationItem.eventID = 4;
                    continue;
                }
                if (string2.equals("NotEnoughFreeMedia")) {
                    notificationItem.eventID = 5;
                    continue;
                }
                if (string2.equals("DbCorrupted")) {
                    notificationItem.eventID = 6;
                    continue;
                }
                if (string2.equals("BackupError")) {
                    notificationItem.eventID = 7;
                    continue;
                }
                if (string2.equals("UnexpectedEvents")) {
                    notificationItem.eventID = 8;
                    continue;
                }
                if (string2.equals("HealthCheckFailed")) {
                    notificationItem.eventID = 9;
                    continue;
                }
                if (string2.equals("UserCheckFailed")) {
                    notificationItem.eventID = 10;
                    continue;
                }
                if (string2.equals("MailSlotsFull")) {
                    notificationItem.eventID = 11;
                    continue;
                }
                if (string2.equals("DbPurgeNeeded")) {
                    notificationItem.eventID = 12;
                    continue;
                }
                if (string2.equals("LicenseWillExpire")) {
                    notificationItem.eventID = 13;
                    continue;
                }
                if (string2.equals("Alarm")) {
                    notificationItem.eventID = 14;
                    continue;
                }
                if (string2.equals("StartOfSession")) {
                    notificationItem.eventID = 15;
                    continue;
                }
                if (string2.equals("LicenseWarning")) {
                    notificationItem.eventID = 16;
                    continue;
                }
                if (string2.equals("DbTablespaceLow")) {
                    notificationItem.eventID = 17;
                    continue;
                }
                if (string2.equals("DbUpgNeeded")) {
                    notificationItem.eventID = 18;
                    continue;
                }
                if (string2.equals("FileLibraryDiskUsage")) {
                    notificationItem.eventID = 19;
                    continue;
                }
                return vector;
            }
            if (string2.equals("-report")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.methodID = 0;
                notificationItem.method = parser2.value;
                continue;
            }
            if (string2.equals("-email")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.methodID = 1;
                notificationItem.method = parser2.value;
                continue;
            }
            if (string2.equals("-smtp")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.methodID = 2;
                notificationItem.method = parser2.value;
                continue;
            }
            if (string2.equals("-snmp")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.methodID = 3;
                notificationItem.method = parser2.value;
                continue;
            }
            if (string2.equals("-broadcast")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.methodID = 4;
                notificationItem.method = parser2.value;
                continue;
            }
            if (string2.equals("-log")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.methodID = 5;
                notificationItem.method = parser2.value;
                continue;
            }
            if (string2.equals("-external")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.methodID = 6;
                notificationItem.method = parser2.value;
                continue;
            }
            if (string2.equals("-ob2eventLog")) {
                if (n != 1) {
                    return vector;
                }
                notificationItem.methodID = 7;
                notificationItem.method = "";
                continue;
            }
            if (string2.equals("-parameter")) {
                if (n != 1 || !parser2.nextToken()) {
                    return vector;
                }
                notificationItem.configParamKey[n2] = parser2.value;
                if (!parser2.nextToken()) {
                    return vector;
                }
                notificationItem.configParam[n2] = parser2.value;
                ++n2;
                continue;
            }
            if (!string2.equals("}")) continue;
            for (int i = n2; i < 5; ++i) {
                notificationItem.configParam[i] = new String("*");
            }
            if (--n != 0) {
                return vector;
            }
            if (notificationItem == null || notificationItem.name == null || notificationItem.eventID == -1 || notificationItem.methodID == -1 || notificationItem.configParam[0] == null || notificationItem.method == null) {
                return vector;
            }
            vector2.addElement(notificationItem);
            notificationItem = null;
        }
        if (n != 0) {
            return vector;
        }
        return vector2;
    }

    public String makeBuffNotifs(Vector vector) {
        NotificationItem notificationItem = null;
        String string = new String();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            notificationItem = (NotificationItem)enumeration.nextElement();
            string = string + new String("\nNOTIFICATION \"") + notificationItem.name + new String("\"\n{\n");
            string = string + new String("\t-event \"");
            switch (notificationItem.eventID) {
                case 0: {
                    string = string + new String("DeviceError\"\n");
                    break;
                }
                case 1: {
                    string = string + new String("EndOfSession\"\n");
                    break;
                }
                case 2: {
                    string = string + new String("MountRequest\"\n");
                    break;
                }
                case 3: {
                    string = string + new String("CRSFailOver\"\n");
                    break;
                }
                case 4: {
                    string = string + new String("DbSpaceLow\"\n");
                    break;
                }
                case 5: {
                    string = string + new String("NotEnoughFreeMedia\"\n");
                    break;
                }
                case 6: {
                    string = string + new String("DbCorrupted\"\n");
                    break;
                }
                case 7: {
                    string = string + new String("BackupError\"\n");
                    break;
                }
                case 8: {
                    string = string + new String("UnexpectedEvents\"\n");
                    break;
                }
                case 9: {
                    string = string + new String("HealthCheckFailed\"\n");
                    break;
                }
                case 10: {
                    string = string + new String("UserCheckFailed\"\n");
                    break;
                }
                case 11: {
                    string = string + new String("MailSlotsFull\"\n");
                    break;
                }
                case 12: {
                    string = string + new String("DbPurgeNeeded\"\n");
                    break;
                }
                case 13: {
                    string = string + new String("LicenseWillExpire\"\n");
                    break;
                }
                case 14: {
                    string = string + new String("Alarm\"\n");
                    break;
                }
                case 15: {
                    string = string + new String("StartOfSession\"\n");
                    break;
                }
                case 16: {
                    string = string + new String("LicenseWarning\"\n");
                    break;
                }
                case 17: {
                    string = string + new String("DbTablespaceLow\"\n");
                    break;
                }
                case 18: {
                    string = string + new String("DbUpgNeeded\"\n");
                    break;
                }
                case 19: {
                    string = string + new String("FileLibraryDiskUsage\"\n");
                }
            }
            switch (notificationItem.methodID) {
                case 0: {
                    string = string + new String("\t-report \"");
                    break;
                }
                case 1: {
                    string = string + new String("\t-email \"");
                    break;
                }
                case 2: {
                    string = string + new String("\t-smtp \"");
                    break;
                }
                case 3: {
                    string = string + new String("\t-snmp \"");
                    break;
                }
                case 4: {
                    string = string + new String("\t-broadcast \"");
                    break;
                }
                case 5: {
                    string = string + new String("\t-log \"");
                    break;
                }
                case 6: {
                    string = string + new String("\t-external \"");
                    break;
                }
                case 7: {
                    string = string + new String("\t-ob2eventLog\n");
                }
            }
            if (notificationItem.methodID != 7) {
                string = string + notificationItem.method + new String("\"\n");
            }
            switch (notificationItem.eventID) {
                case 0: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("DEVICE \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 1: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("DATALIST \"") + notificationItem.configParam[1] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("SESSSTAT \"") + notificationItem.configParam[2] + new String("\"\n");
                    break;
                }
                case 2: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("DEVICE \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("VSLIMIT \"") + notificationItem.configParam[1] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("VDSLIMIT \"") + notificationItem.configParam[2] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("DCBFSLIMIT \"") + notificationItem.configParam[3] + new String("\"\n");
                    break;
                }
                case 5: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("POOL \"") + notificationItem.configParam[1] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("NUMFREEMEDIA \"") + notificationItem.configParam[2] + new String("\"\n");
                    break;
                }
                case 6: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    break;
                }
                case 7: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("SINGLEMSGLEVEL \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 8: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("NUMEVENT \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 9: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    break;
                }
                case 10: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("COMMANDPATH \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 11: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("DEVICE \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 12: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("DAYSLASTPURGE \"") + notificationItem.configParam[1] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("NUMESTIMFILENAMES \"") + notificationItem.configParam[2] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("ESTIMTIMEPURGE \"") + notificationItem.configParam[3] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("NUMFILENAMES \"") + notificationItem.configParam[4] + new String("\"\n");
                    break;
                }
                case 13: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("LICEXPIREDAYS \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 14: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    break;
                }
                case 15: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("DATALIST \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 16: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    break;
                }
                case 17: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("TBLSPACETHRESHOLD \"") + notificationItem.configParam[1] + new String("\"\n");
                    break;
                }
                case 18: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    break;
                }
                case 19: {
                    string = string + new String("\t-parameter ") + new String("LEVEL \"") + notificationItem.configParam[0] + new String("\"\n");
                    string = string + new String("\t-parameter ") + new String("FILELIBRARYNAME \"") + notificationItem.configParam[1] + new String("\"\n");
                }
            }
            string = string + new String("}\n");
        }
        return string;
    }
}

