/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class OmnibackCore {
    private String m_home;
    private int crs_port = 5555;
    protected Socket m_Socket;
    public DataInputStream m_sin;
    public DataOutputStream m_sout;
    protected int m_access;
    public String m_server;
    public int m_connected;
    public DBData m_curData;
    private IpcMsg rptmsg = null;

    public OmnibackCore(String string, int n) {
        this.crs_port = n;
        this.m_sin = null;
        this.m_sout = null;
        this.m_access = 0;
        this.m_server = string;
        this.m_connected = 0;
    }

    public boolean Connect(int n) {
        try {
            this.m_Socket = new Socket(this.m_server, n);
            this.m_sout = new DataOutputStream(this.m_Socket.getOutputStream());
            this.m_sin = new DataInputStream(this.m_Socket.getInputStream());
            this.m_connected = 2;
        }
        catch (UnknownHostException unknownHostException) {
            if (unknownHostException.toString() != null) {
                OB2Debug.DbgPlain(0, unknownHostException.toString());
            }
            if (unknownHostException.getMessage() != null) {
                OB2Debug.DbgPlain(0, "detailed message ->" + unknownHostException.getMessage());
            }
            this.m_connected = 0;
            return false;
        }
        catch (IOException iOException) {
            if (iOException.toString() != null) {
                OB2Debug.DbgPlain(0, iOException.toString());
            }
            if (iOException.getMessage() != null) {
                OB2Debug.DbgPlain(0, "detailed message ->" + iOException.getMessage());
            }
            this.m_connected = 0;
            return false;
        }
        catch (SecurityException securityException) {
            if (securityException.toString() != null) {
                OB2Debug.DbgPlain(0, securityException.toString());
            }
            if (securityException.getMessage() != null) {
                OB2Debug.DbgPlain(0, "detailed message ->" + securityException.getMessage());
            }
            this.m_connected = 0;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int crsPort(String string) {
        IpcMsg ipcMsg;
        Socket socket;
        int n;
        block22: {
            int n2;
            int n3;
            block21: {
                OB2Debug.DbgPlain(1, "Inside crsPort");
                n = -1;
                socket = null;
                n3 = -1;
                ipcMsg = new IpcMsg(2);
                if (Common.init == 0) {
                    return -1;
                }
                try {
                    socket = new Socket(string, this.crs_port);
                    OB2Debug.DbgPlain(5, "Socket opened ->" + socket.toString());
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                    ipcMsg.append(Common.strLocalHost);
                    ipcMsg.append(0);
                    ipcMsg.append(Common.strLocalUser);
                    ipcMsg.append(Common.strLocalUserGroup);
                    ipcMsg.append("C");
                    ipcMsg.append(15);
                    OB2Debug.DbgPlain(5, "Sending My Id");
                    int n4 = ipcMsg.sendMsg(dataOutputStream);
                    n3 = ipcMsg.readMsg(dataInputStream);
                    OB2Debug.DbgPlain(5, "Response ; num bytes->" + new Integer(n3).toString());
                }
                catch (UnknownHostException unknownHostException) {
                    if (unknownHostException.toString() != null) {
                        OB2Debug.DbgPlain(0, unknownHostException.toString());
                    }
                    if (unknownHostException.getMessage() != null) {
                        OB2Debug.DbgPlain(0, "detailed message ->" + unknownHostException.getMessage());
                    }
                }
                catch (IOException iOException) {
                    if (iOException.toString() != null) {
                        OB2Debug.DbgPlain(0, iOException.toString());
                    }
                    if (iOException.getMessage() != null) {
                        OB2Debug.DbgPlain(0, "detailed message ->" + iOException.getMessage());
                    }
                }
                catch (SecurityException securityException) {
                    if (securityException.toString() != null) {
                        OB2Debug.DbgPlain(0, securityException.toString());
                    }
                    if (securityException.getMessage() == null) break block21;
                    OB2Debug.DbgPlain(0, "detailed message ->" + securityException.getMessage());
                }
            }
            if (n3 == -1) {
                return -1;
            }
            try {
                n3 = ipcMsg.strParseStartN();
                if (n3 == 109) break block22;
                n2 = -1;
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OB2Debug.DbgPlain(1, "end crsPort");
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            OB2Debug.DbgPlain(1, "end crsPort");
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return n2;
        }
        n = ipcMsg.strParseNextN();
        Object var10_14 = null;
        OB2Debug.DbgPlain(1, "end crsPort");
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {}
        return n;
    }

    public boolean Connect() {
        OB2Debug.DbgPlain(1, "Inside crsConnect ");
        if (this.m_connected > 0) {
            return true;
        }
        int n = this.crsPort(this.m_server);
        if (n < 0) {
            return false;
        }
        OB2Debug.DbgPlain(1, "Port Num OK");
        try {
            this.m_Socket = new Socket(this.m_server, n);
            OB2Debug.DbgPlain(5, "Socket opened ->" + this.m_Socket.toString());
            this.m_sout = new DataOutputStream(this.m_Socket.getOutputStream());
            this.m_sin = new DataInputStream(this.m_Socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
            if (unknownHostException.toString() != null) {
                OB2Debug.DbgPlain(0, unknownHostException.toString());
            }
            if (unknownHostException.getMessage() != null) {
                OB2Debug.DbgPlain(0, "detailed message ->" + unknownHostException.getMessage());
            }
            this.m_connected = 0;
            return false;
        }
        catch (IOException iOException) {
            if (iOException.toString() != null) {
                OB2Debug.DbgPlain(0, iOException.toString());
            }
            if (iOException.getMessage() != null) {
                OB2Debug.DbgPlain(0, "detailed message ->" + iOException.getMessage());
            }
            this.m_connected = 0;
            return false;
        }
        catch (SecurityException securityException) {
            if (securityException.toString() != null) {
                OB2Debug.DbgPlain(0, securityException.toString());
            }
            if (securityException.getMessage() != null) {
                OB2Debug.DbgPlain(0, "detailed message ->" + securityException.getMessage());
            }
            this.m_connected = 0;
            return false;
        }
        IpcMsg ipcMsg = Common.MakeMyId();
        ipcMsg.append(Common.strLocalUser);
        ipcMsg.append(Common.strLocalUserGroup);
        ipcMsg.append(101);
        ipcMsg.append(Common.strLocalHost);
        if (ipcMsg.sendMsg(this.m_sout) == -1) {
            return false;
        }
        OB2Debug.DbgPlain(5, "Sending My Id ");
        if (ipcMsg.readMsg(this.m_sin) == -1) {
            return false;
        }
        try {
            if (Integer.parseInt(ipcMsg.m_lastR) == 5) {
                if (OB2Error.ErhUnpackMsg(ipcMsg) != 0) {
                    return false;
                }
                ipcMsg.strParseNext();
                this.m_access = Integer.parseInt(ipcMsg.m_lastR);
            } else {
                this.m_access = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.m_access = 8191;
        }
        this.m_connected = 1;
        return true;
    }

    public OmnibackCore StartSession(int n, IpcMsg ipcMsg) {
        if (this.m_connected != 1) {
            return null;
        }
        OmnibackCore omnibackCore = new OmnibackCore(this.m_server, this.crs_port);
        IpcMsg ipcMsg2 = new IpcMsg(205);
        ipcMsg2.append(n);
        ipcMsg2.append("");
        ipcMsg2.append(OB2Debug.m_debugRanges);
        ipcMsg2.append(OB2Debug.m_debugPostfix);
        ipcMsg2.append(OB2Debug.m_debugSelect);
        ipcMsg2.append("C");
        ipcMsg2.sendMsg(this.m_sout);
        if (ipcMsg != null) {
            ipcMsg.SendData(this.m_sout, false, true);
        }
        if (ipcMsg2.readMsg(this.m_sin) == -1) {
            return null;
        }
        if (OB2Error.ErhUnpackMsg(ipcMsg2) != 0) {
            return null;
        }
        if (OB2Error.ErhErrno() != 0) {
            OB2Error.ErhClearError();
            return null;
        }
        ipcMsg2.strParseNext();
        ipcMsg2.strParseNext();
        if (!omnibackCore.Connect(Integer.parseInt(ipcMsg2.m_lastR))) {
            return null;
        }
        Common.MakeMyId().sendMsg(omnibackCore.m_sout);
        return omnibackCore;
    }

    public boolean Disconnect() {
        try {
            if (this.m_Socket != null) {
                this.m_Socket.close();
            }
            this.m_connected = 0;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public int GetRights() {
        return this.m_access;
    }

    private boolean CheckConnect(int n) {
        boolean bl = true;
        if (this.m_access > 0) {
            bl = true;
        }
        if (n < 1000 && this.m_connected != 1) {
            bl = false;
        }
        return bl;
    }

    public int CsaPutSingleFile(int n, int n2, String string) {
        if (Common.CmnValidSingleFile(n) == -1) {
            return 0;
        }
        if (n2 != 2 && n2 != 1) {
            return 0;
        }
        IpcMsg ipcMsg = new IpcMsg(203);
        ipcMsg.append(n);
        ipcMsg.append(string.length() * 2);
        ipcMsg.sendMsg(this.m_sout);
        IpcMsg ipcMsg2 = new IpcMsg(string, false);
        ipcMsg2.SendData(this.m_sout, true, false);
        if (ipcMsg.readMsg(this.m_sin) == -1) {
            return 0;
        }
        if (OB2Error.ErhUnpackMsg(ipcMsg) != 0) {
            return 0;
        }
        if (OB2Error.ErhErrno() != 0) {
            OB2Error.ErhClearError();
            return 0;
        }
        return 1;
    }

    public DBData CsaGetSingleFile(int n, int n2) {
        if (Common.CmnValidSingleFile(n) == -1) {
            return null;
        }
        if (n2 != 0 && n2 != 1) {
            return null;
        }
        IpcMsg ipcMsg = new IpcMsg(202);
        ipcMsg.append(n);
        ipcMsg.sendMsg(this.m_sout);
        DBData dBData = ipcMsg.ReadData(this.m_sin);
        if (dBData == null) {
            // empty if block
        }
        return dBData;
    }

    public String CsaGetNotification(String string) {
        IpcMsg ipcMsg = new IpcMsg(214);
        ipcMsg.append(40);
        ipcMsg.append(string);
        if (ipcMsg.sendMsg(this.m_sout) <= 0) {
            return null;
        }
        DBData dBData = ipcMsg.ReadData(this.m_sin);
        int n = ipcMsg.strParseStartN();
        if (n == 5) {
            return dBData.strParseNext();
        }
        return null;
    }

    public int CsaPutNotification(String string, String string2) {
        IpcMsg ipcMsg = new IpcMsg(215);
        ipcMsg.append(40);
        ipcMsg.append(string);
        ipcMsg.append(string2.length() * 2);
        ipcMsg.append(string2);
        if (ipcMsg.sendMsg(this.m_sout) <= 0) {
            return -1;
        }
        ipcMsg = new IpcMsg(string2, false);
        if (ipcMsg.SendData(this.m_sout, true, false) <= 0) {
            return -1;
        }
        return 0;
    }

    public boolean RemoveGroupItem(int n, String string) {
        IpcMsg ipcMsg = new IpcMsg(216);
        ipcMsg.append(n);
        ipcMsg.append(string);
        if (ipcMsg.sendMsg(this.m_sout) <= 0) {
            return false;
        }
        DBData dBData = ipcMsg.ReadData(this.m_sin);
        int n2 = ipcMsg.strParseStartN();
        if (n2 != 5) {
            return false;
        }
        OB2Error.ErhUnpackMsg(this.rptmsg);
        if (OB2Error.ErhErrno() == 0) {
            return true;
        }
        OB2Error.ErhClearError();
        return false;
    }

    public DBData DBQuery(IpcMsg ipcMsg, int n) {
        int n2;
        DBData dBData = new DBData();
        if (!this.CheckConnect(n)) {
            return null;
        }
        if (ipcMsg.sendMsg(this.m_sout) <= 0) {
            return null;
        }
        dBData.removeAllElements();
        do {
            if (ipcMsg.readMsg(this.m_sin) <= 0) {
                return null;
            }
            n2 = ipcMsg.strParseStartN();
            if (n2 == -1) {
                return null;
            }
            if (n2 == n) {
                while (ipcMsg.strParseNext() != null) {
                    dBData.addElement(ipcMsg.m_lastR);
                }
            } else {
                if (n2 != 5) continue;
                OB2Error.ErhUnpackMsg(ipcMsg);
                if (OB2Error.ErhErrno() == 1252) {
                    OB2Error.ErhClearError();
                    return dBData;
                }
                if (OB2Error.ErhErrno() == 1254 || OB2Error.ErhErrno() == 1258 || OB2Error.ErhErrno() == 1203) {
                    OB2Error.ErhClearError();
                    return dBData;
                }
                if (OB2Error.ErhErrno() == 0) continue;
                OB2Error.ErhClearError();
                return null;
            }
        } while (n2 != 5);
        return dBData;
    }

    public int DBReportQueryStart(IpcMsg ipcMsg, int n) {
        DBData dBData = new DBData();
        if (!this.CheckConnect(n)) {
            return -1;
        }
        if (ipcMsg.sendMsg(this.m_sout) <= 0) {
            return -1;
        }
        this.rptmsg = ipcMsg;
        return 0;
    }

    public DBData DBReportQuery(int n) {
        DBData dBData = new DBData();
        dBData.removeAllElements();
        if (this.rptmsg.readMsg(this.m_sin) <= 0) {
            return null;
        }
        int n2 = this.rptmsg.strParseStartN();
        if (n2 == -1) {
            return null;
        }
        if (n2 == n) {
            while (this.rptmsg.strParseNext() != null) {
                dBData.addElement(this.rptmsg.m_lastR);
            }
        } else {
            if (n2 == 5) {
                dBData.addElement("R E S U L T");
                OB2Error.ErhUnpackMsg(this.rptmsg);
                dBData.addElement(new Integer(OB2Error.ErhErrno()).toString());
                dBData.addElement("");
                dBData.addElement("");
                OB2Error.ErhClearError();
                return dBData;
            }
            if (n2 == 1) {
                dBData.addElement("A B O R T");
                this.rptmsg.strParseNext();
                String string = this.rptmsg.m_lastR;
                OB2Error.ErhUnpackMsg(this.rptmsg);
                dBData.addElement(new Integer(OB2Error.ErhErrno()).toString());
                dBData.addElement(string);
                dBData.addElement("");
                OB2Error.ErhClearError();
                return dBData;
            }
            return null;
        }
        return dBData;
    }
}

