/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Vector;

public class OmniTree
extends Panel {
    public static int OT_HASLINES = 1;
    public static int OT_HASBUTTONS = 2;
    public static int OT_FIXEDBGIMAGE = 4;
    private static int m_levelOffset = 20;
    private int m_buttonSize = 10;
    private int m_Height = 20;
    private Image bgimage = null;
    private Image m_sideImage = null;
    private Image m_topImage = null;
    public int m_TextSize = 12;
    public String m_TextFontFirst = "SansSerif";
    public String m_TextFontSecond = "SansSerif";
    private int imageOffset = 5;
    private int textOffset = 5;
    private int inSignOffset = 3;
    private int signOffset = 3;
    private boolean m_lines;
    private boolean m_buttons;
    private boolean m_fixedBgImage = false;
    private OmniTreeItem root;
    private OmniTreeItem focused = null;
    private Vector visibleItems = null;
    private Vector fonts = null;
    private static Color m_linecolor = Color.black;
    private int m_winHeight = -1;
    private int m_winWidth = -1;
    private int m_maxWidth = -1;
    private int m_maxHeight = -1;
    private Image m_winImage = null;
    private Graphics m_winGG = null;
    private int sbPositionX = 0;
    private int sbPositionY = 0;
    private Scrollbar m_sbX = null;
    private Scrollbar m_sbY = null;
    private boolean m_sbxS = false;
    private boolean m_sbyS = false;
    private int transparent = -1;

    public OmniTree(int n) {
        this.m_lines = (n & OT_HASLINES) != 0;
        this.m_buttons = (n & OT_HASBUTTONS) != 0;
        this.m_fixedBgImage = (n & OT_FIXEDBGIMAGE) != 0;
        this.root = new OmniTreeItem();
        this.m_sbX = new Scrollbar(0, 0, 1, 0, 10);
        this.m_sbY = new Scrollbar(1, 0, 1, 0, 10);
        this.add(this.m_sbX);
        this.add(this.m_sbY);
        this.m_sbX.setVisible(true);
        this.m_sbY.setVisible(true);
        this.setAllFonts();
    }

    private void drawItem(Graphics graphics, OmniTreeItem omniTreeItem, int n) {
        int n2 = omniTreeItem.m_Level * m_levelOffset + this.signOffset;
        int n3 = n + (this.m_Height - this.m_buttonSize) / 2;
        int n4 = n2 + this.imageOffset + this.m_buttonSize;
        int n5 = n;
        int n6 = n4 + this.textOffset;
        int n7 = 0;
        Color color = new Color(136);
        if (omniTreeItem.m_Image != null) {
            n6 += omniTreeItem.m_Image.getWidth(null);
            n5 += (this.m_Height - omniTreeItem.m_Image.getHeight(null)) / 2;
        }
        if (color != null) {
            graphics.setColor(m_linecolor);
        }
        int n8 = n2 + this.m_buttonSize / 2;
        int n9 = n3 + this.m_buttonSize / 2;
        if (omniTreeItem.hasChildren() && this.m_buttons) {
            graphics.setColor(Color.black);
            graphics.drawRect(n2, n3, this.m_buttonSize, this.m_buttonSize);
            graphics.drawLine(n2 + this.inSignOffset, n9, n2 + this.m_buttonSize - this.inSignOffset, n9);
            if (!omniTreeItem.isExpanded()) {
                graphics.drawLine(n8, n3 + this.inSignOffset, n8, n3 + this.m_buttonSize - this.inSignOffset);
            }
            graphics.setColor(m_linecolor);
            if (this.m_lines) {
                if (omniTreeItem.hasPrevSiebling() || omniTreeItem.m_Level != 0) {
                    graphics.drawLine(n8, n, n8, n3);
                }
                if (omniTreeItem.hasNextSiebling()) {
                    graphics.drawLine(n8, n3 + this.m_buttonSize, n8, n + this.m_Height);
                }
                graphics.drawLine(n2 + this.m_buttonSize, n9, n4, n9);
            }
        } else if (this.m_lines) {
            if (omniTreeItem.hasPrevSiebling() || omniTreeItem.m_Level > 0) {
                graphics.drawLine(n8, n, n8, n9);
            }
            graphics.drawLine(n8, n9, n4, n9);
            if (omniTreeItem.hasNextSiebling()) {
                graphics.drawLine(n8, n9, n8, n + this.m_Height);
            }
        }
        if (omniTreeItem.m_Style == null) {
            return;
        }
        graphics.setFont(omniTreeItem.m_Style);
        if (this.m_lines) {
            int n10;
            OmniTreeItem omniTreeItem2 = omniTreeItem;
            for (n7 = omniTreeItem.m_Level - 1; n7 >= 0; --n7) {
                if (omniTreeItem2 != null) {
                    omniTreeItem2 = omniTreeItem2.getParent();
                }
                if (omniTreeItem2 == null || !omniTreeItem2.hasNextSiebling()) continue;
                n10 = n7 * m_levelOffset + this.m_buttonSize / 2 + this.signOffset;
                graphics.drawLine(n10, n, n10, n + this.m_Height);
            }
            if (omniTreeItem.hasChildren() && omniTreeItem.isExpanded()) {
                n10 = (omniTreeItem.m_Level + 1) * m_levelOffset + this.m_buttonSize / 2 + this.signOffset;
                int n11 = n9;
                n11 = omniTreeItem.m_Image != null ? (n11 += omniTreeItem.m_Image.getHeight(null) / 2) : (n11 += this.m_TextSize / 2);
                graphics.drawLine(n10, n11, n10, n + this.m_Height);
            }
        }
        if (omniTreeItem == this.focused) {
            graphics.setColor(color);
            graphics.fillRect(n6 - this.textOffset / 2, n, omniTreeItem.m_stringLen + this.textOffset, this.m_Height);
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        if (omniTreeItem.m_Image != null) {
            graphics.drawImage(omniTreeItem.m_Image, n4, n5, null);
        }
        graphics.drawString(omniTreeItem.m_Text, n6, n + (this.m_Height + this.m_TextSize) / 2);
    }

    private int drawTree(Graphics graphics, OmniTreeItem omniTreeItem, int n, int n2) {
        for (int i = 0; i < omniTreeItem.numberOfChildren(); ++i) {
            OmniTreeItem omniTreeItem2 = (OmniTreeItem)omniTreeItem.items.elementAt(i);
            if (omniTreeItem2 == null) continue;
            this.visibleItems.addElement(omniTreeItem2);
            if (n < n2) {
                if (n >= -this.m_Height) {
                    this.drawItem(graphics, omniTreeItem2, n);
                }
                n += this.m_Height;
                if (!omniTreeItem2.isExpanded()) continue;
                n = this.drawTree(graphics, omniTreeItem2, n, n2);
                continue;
            }
            return n;
        }
        return n;
    }

    public void redraw(boolean bl, boolean bl2) {
        int n;
        Dimension dimension = this.getSize();
        boolean bl3 = false;
        try {
            bl3 = new String(System.getProperty("java.vendor")).substring(0, 8).equals("Netscape");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        this.m_maxWidth = this.maxWalk(this.root, 0, true);
        this.m_maxHeight = this.maxWalk(this.root, 0, false);
        int n2 = this.m_sbY.getSize().width;
        int n3 = this.m_sbX.getSize().height;
        int n4 = this.m_sideImage == null ? 0 : this.m_sideImage.getWidth(null);
        int n5 = this.m_topImage == null ? 0 : this.m_topImage.getHeight(null);
        this.m_sbxS = false;
        this.m_sbyS = false;
        if (this.m_maxHeight > dimension.height - n3 - n5 && this.m_maxWidth > dimension.width - n2 - n4) {
            this.m_sbyS = true;
            this.m_sbxS = true;
        }
        if (this.m_maxHeight > dimension.height - n5) {
            this.m_sbyS = true;
        }
        if (this.m_maxWidth > dimension.width - n4) {
            this.m_sbxS = true;
        }
        if (this.m_winWidth != this.m_maxWidth || this.m_winHeight != dimension.height) {
            this.m_winWidth = this.m_maxWidth;
            if (this.m_winWidth < dimension.width) {
                this.m_winWidth = dimension.width;
            }
            this.m_winHeight = dimension.height;
            this.m_winImage = this.createImage(this.m_winWidth, this.m_winHeight);
            if (this.m_winGG != null) {
                this.m_winGG.dispose();
            }
            this.m_winGG = this.m_winImage.getGraphics();
        }
        if (this.visibleItems == null) {
            this.visibleItems = new Vector();
        } else {
            this.visibleItems.removeAllElements();
        }
        if (this.m_sbxS) {
            n = dimension.width;
            this.m_sbX.setValues(this.sbPositionX, dimension.width, 0, this.m_maxWidth + (this.m_sbyS ? n2 : 0) + n4 + n);
            this.m_sbX.setUnitIncrement(this.m_Height);
        } else {
            this.sbPositionX = 0;
            this.m_sbX.setValue(0);
        }
        if (this.m_sbyS) {
            n = dimension.height;
            this.m_sbY.setValues(this.sbPositionY, dimension.height, 0, this.m_maxHeight + n + (this.m_sbxS ? n3 : 0) + n5);
            this.m_sbY.setUnitIncrement(this.m_Height);
        } else {
            this.sbPositionY = 0;
            this.m_sbY.setValue(0);
        }
        this.m_winGG.clearRect(0, 0, this.m_winWidth, this.m_winHeight);
        this.drawTree(this.m_winGG, this.root, -this.m_sbY.getValue() + n5, this.getSize().height);
        if (this.m_topImage != null) {
            this.m_winGG.drawImage(this.m_topImage, 0, 0, null);
        }
    }

    public void updateG(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        if (this.m_winWidth != this.m_maxWidth || this.m_winHeight != dimension.height) {
            this.redraw(true, true);
        }
        this.sbPositionX = this.m_sbX.getValue();
        this.sbPositionY = this.m_sbY.getValue();
        graphics.drawImage(this.m_winImage, (this.m_sideImage == null ? 0 : this.m_sideImage.getWidth(null)) - this.sbPositionX, 0, null);
        if (this.m_sideImage != null) {
            graphics.drawImage(this.m_sideImage, 0, 0, null);
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.m_sbX.getPreferredSize();
        Dimension dimension3 = this.m_sbY.getPreferredSize();
        graphics.clipRect(0, 0, dimension.width - (this.m_sbyS ? dimension3.width : 0), dimension.height - (this.m_sbxS ? dimension2.height : 0));
        this.updateG(graphics);
        if (this.m_sbxS) {
            this.m_sbX.setBounds(0, dimension.height - dimension2.height, dimension.width - (this.m_sbyS ? dimension3.width : 0), dimension2.height);
            this.m_sbX.setVisible(true);
        } else {
            this.m_sbX.setVisible(false);
        }
        if (this.m_sbyS) {
            this.m_sbY.setBounds(dimension.width - dimension3.width, 0, dimension3.width, dimension.height - (this.m_sbxS ? dimension2.height : 0));
            this.m_sbY.setVisible(true);
        } else {
            this.m_sbY.setVisible(false);
        }
        if (this.m_sbyS && this.m_sbxS) {
            graphics.clearRect(dimension.width - dimension3.width, dimension.height - dimension2.height, dimension3.width, dimension2.height);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.m_sbX && event.arg != null) {
            this.sbPositionX = this.m_sbX.getValue();
            this.repaint();
            return true;
        }
        if (event.target == this.m_sbY && event.arg != null) {
            this.sbPositionY = this.m_sbY.getValue();
            this.redraw(true, true);
            this.repaint();
            return true;
        }
        return super.handleEvent(event);
    }

    public OmniTreeItem add(String string, int n) {
        OmniTreeItem omniTreeItem = null;
        if (this.root != null) {
            omniTreeItem = new OmniTreeItem(string, this.root, this.getSF(n, null));
            this.root.addItem(omniTreeItem);
        }
        return omniTreeItem;
    }

    public OmniTreeItem add(Image image, String string, int n) {
        OmniTreeItem omniTreeItem = null;
        if (this.root != null) {
            omniTreeItem = new OmniTreeItem(image, string, this.root, this.getSF(n, null));
            this.root.addItem(omniTreeItem);
        }
        return omniTreeItem;
    }

    public OmniTreeItem add(String string, OmniTreeItem omniTreeItem, int n) {
        OmniTreeItem omniTreeItem2 = new OmniTreeItem(string, omniTreeItem, this.getSF(n, null));
        if (omniTreeItem != null) {
            omniTreeItem.addItem(omniTreeItem2);
        }
        return omniTreeItem2;
    }

    public OmniTreeItem add(Image image, String string, OmniTreeItem omniTreeItem, int n) {
        OmniTreeItem omniTreeItem2 = new OmniTreeItem(image, string, omniTreeItem, this.getSF(n, null));
        if (omniTreeItem != null) {
            omniTreeItem.addItem(omniTreeItem2);
        }
        return omniTreeItem2;
    }

    public void add(OmniTreeItem omniTreeItem) {
        if (this.root != null) {
            this.root.addItem(omniTreeItem);
        }
    }

    public void add(OmniTreeItem omniTreeItem, OmniTreeItem omniTreeItem2) {
        if (omniTreeItem2 != null) {
            omniTreeItem2.addItem(omniTreeItem);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = (n2 + this.sbPositionY) / this.m_Height;
        if (event.target instanceof Scrollbar) {
            return true;
        }
        if (n3 < this.visibleItems.size()) {
            OmniTreeItem omniTreeItem = (OmniTreeItem)this.visibleItems.elementAt(n3);
            int n4 = -this.sbPositionX + omniTreeItem.m_Level * m_levelOffset + this.signOffset;
            int n5 = -this.sbPositionY + this.m_Height * n3 + (this.m_Height - this.m_buttonSize) / 2;
            if (n >= n4 && n <= n4 + this.m_buttonSize && n2 >= n5 && n2 <= n5 + this.m_buttonSize) {
                omniTreeItem.setExpanded(!omniTreeItem.isExpanded());
            } else {
                this.focused = omniTreeItem;
                if (event.clickCount == 1) {
                    omniTreeItem.setExpanded(!omniTreeItem.isExpanded());
                    this.getParent().postEvent(new Event(this, 1234, omniTreeItem));
                }
            }
        }
        this.redraw(true, true);
        this.repaint();
        return true;
    }

    public boolean keyDown(Event event, int n) {
        if (this.focused == null && this.root != null) {
            this.focused = (OmniTreeItem)this.root.items.elementAt(0);
        }
        switch (n) {
            case 1005: {
                this.MoveDown(this.focused);
                this.redraw(true, true);
                this.repaint();
                break;
            }
            case 1004: {
                this.MoveUp(this.focused);
                this.redraw(true, true);
                this.repaint();
                break;
            }
            case 1006: {
                this.MoveLeft(this.focused);
                this.redraw(true, true);
                this.repaint();
                break;
            }
            case 1007: {
                this.MoveRight(this.focused);
                this.redraw(true, true);
                this.repaint();
                break;
            }
            case 10: {
                this.focused.setExpanded(!this.focused.isExpanded());
                this.redraw(true, true);
                this.repaint();
            }
        }
        return true;
    }

    public void MoveLeft(OmniTreeItem omniTreeItem) {
        if (this.focused != null) {
            if (this.focused.isExpanded() && this.focused.hasChildren()) {
                this.focused.setExpanded(!this.focused.isExpanded());
            } else if (this.focused.m_Level > 0) {
                this.focused = this.focused.getParent();
            }
        }
    }

    public void MoveRight(OmniTreeItem omniTreeItem) {
        if (!this.focused.isExpanded()) {
            this.focused.setExpanded(!this.focused.isExpanded());
        } else if (this.focused.hasChildren()) {
            this.focused = (OmniTreeItem)this.focused.items.elementAt(0);
        }
    }

    public void MoveDown(OmniTreeItem omniTreeItem) {
        int n = omniTreeItem != null ? this.visibleItems.indexOf(omniTreeItem) : -1;
        if (n < this.visibleItems.size() - 1) {
            ++n;
        }
        if ((n + 1) * this.m_Height - this.sbPositionY >= this.getSize().height - this.m_Height) {
            this.sbPositionY += this.m_Height;
        }
        this.focused = (OmniTreeItem)this.visibleItems.elementAt(n);
    }

    public void MoveUp(OmniTreeItem omniTreeItem) {
        int n = omniTreeItem != null ? this.visibleItems.indexOf(omniTreeItem) : 1;
        if (n > 0) {
            --n;
        }
        if (n * this.m_Height < this.sbPositionY) {
            this.sbPositionY -= this.m_Height;
        }
        this.focused = (OmniTreeItem)this.visibleItems.elementAt(n);
    }

    public void setAllFonts() {
        Font font = null;
        if (this.fonts == null) {
            this.fonts = new Vector();
        } else {
            this.fonts.removeAllElements();
        }
        font = new Font(this.m_TextFontFirst, 0, this.m_TextSize);
        if (font == null) {
            font = new Font(this.m_TextFontSecond, 0, this.m_TextSize);
        }
        this.fonts.addElement(font);
        font = new Font(this.m_TextFontFirst, 1, this.m_TextSize);
        if (font == null) {
            font = new Font(this.m_TextFontSecond, 1, this.m_TextSize);
        }
        this.fonts.addElement(font);
        font = new Font(this.m_TextFontFirst, 2, this.m_TextSize);
        if (font == null) {
            font = new Font(this.m_TextFontSecond, 2, this.m_TextSize);
        }
        this.fonts.addElement(font);
        font = new Font(this.m_TextFontFirst, 3, this.m_TextSize);
        if (font == null) {
            font = new Font(this.m_TextFontSecond, 3, this.m_TextSize);
        }
        this.fonts.addElement(font);
    }

    private Font getSF(int n, Graphics graphics) {
        Font font = null;
        if (this.fonts != null) {
            font = (Font)this.fonts.elementAt(n);
            if (graphics != null) {
                graphics.setFont(font);
            }
        }
        return font;
    }

    public int getNumberVisibleItems() {
        int n = 0;
        if (this.visibleItems != null) {
            n = this.visibleItems.size();
        }
        return n;
    }

    public void setValues(int n, int n2, int n3, int n4) {
        m_levelOffset = n;
        this.m_Height = n2;
        this.m_TextSize = n3;
        this.m_buttonSize = n4;
        this.setAllFonts();
    }

    public void setBgImage(Image image) {
        this.bgimage = image;
    }

    public void setSideImage(Image image) {
        this.m_sideImage = image;
    }

    public void setTopImage(Image image) {
        this.m_topImage = image;
    }

    public void setLineColor(Color color) {
        m_linecolor = color;
    }

    private int maxWalk(OmniTreeItem omniTreeItem, int n, boolean bl) {
        if (bl) {
            for (int i = 0; i < omniTreeItem.numberOfChildren(); ++i) {
                OmniTreeItem omniTreeItem2 = (OmniTreeItem)omniTreeItem.items.elementAt(i);
                if (omniTreeItem2 == null) continue;
                int n2 = omniTreeItem2.m_Level * m_levelOffset + this.signOffset;
                if (omniTreeItem2.m_Image != null) {
                    n2 += omniTreeItem2.m_Image.getWidth(null);
                }
                n2 += this.textOffset + this.imageOffset + this.m_buttonSize;
                n2 += omniTreeItem2.m_stringLen + this.textOffset / 2;
                if (omniTreeItem2.isExpanded()) {
                    n2 = Math.max(n2, this.maxWalk(omniTreeItem2, Math.max(n2, n), true));
                }
                n = Math.max(n2, n);
            }
        } else {
            for (int i = 0; i < omniTreeItem.numberOfChildren(); ++i) {
                OmniTreeItem omniTreeItem3 = (OmniTreeItem)omniTreeItem.items.elementAt(i);
                if (omniTreeItem3 == null) continue;
                n += this.m_Height;
                if (!omniTreeItem3.isExpanded()) continue;
                n = this.maxWalk(omniTreeItem3, n, false);
            }
        }
        return n;
    }

    public void handleSinglePixel(int n, int n2, int n3, int[] nArray) {
    }

    public void makeShadow(Image image, int n, int n2) {
        int[] nArray = new int[(n2 + 9) * n];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 6 * n, n);
        pixelGrabber.setColorModel(ColorModel.getRGBdefault());
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted  waiting  for  pixels!");
            return;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            System.err.println("image  fetch  aborted  or  errored");
            return;
        }
        this.transparent = nArray[6 * n];
        for (int i = n2 - 1; i > -1; --i) {
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[i * n + j + 6 * n];
                if (n3 == this.transparent) continue;
                int n4 = (n3 >> 24 & 0xFF) * (n2 - i) / n2;
                int n5 = (n3 >> 16 & 0xFF) * (n2 - i) / (2 * n2);
                int n6 = (n3 >> 8 & 0xFF) * (n2 - i) / n2;
                int n7 = (n3 & 0xFF) * (n2 - i) / (2 * n2);
                if (nArray[j + 2 + (i + 3) * n + 6 * n] != this.transparent) continue;
                nArray[j + 2 + (i + 3) * n + 6 * n] = n4 << 24 | n5 << 16 | n6 << 8 | n7;
            }
        }
        Image image2 = this.createImage(new MemoryImageSource(n, n2, ColorModel.getRGBdefault(), nArray, 6 * n, n));
        Graphics graphics = image.getGraphics();
        graphics.drawImage(image2, 0, 0, null);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, 200, 800);
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 400);
    }

    public Dimension getMaximumSize() {
        return new Dimension(200, 400);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 400);
    }
}

