/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public class ListView
extends Panel
implements ImageObserver {
    private static final int clickMargin = 5;
    private static final int maxBUFF = 1200000;
    private static final int perPage = 99;
    public boolean printBack = true;
    private boolean ListModeSlow = true;
    public String containerEmptyString;
    Color colorBg = Color.white;
    Color colorFg = Color.black;
    Color colorHBg = Color.blue;
    Color colorHFg = Color.white;
    boolean multiSelect = false;
    int[] splitters;
    double[] splittersD;
    int[] sizes;
    int tempCount;
    BitSet options = new BitSet(20);
    boolean doubleInUse = false;
    int title = -1;
    int currentCursor = 0;
    Image im;
    Graphics gg;
    int height = -1;
    int width = -1;
    int selectedRow = 0;
    int dragColumn = -1;
    int xDragLast = -1;
    Vector rows;
    BitSet highlightedRows = new BitSet();
    int firstSeenRow = 0;
    int prefSizeX = 10;
    int prefSizeY = 0;
    Vector styles;

    public ListView(int n, boolean bl) {
        this.splitters = new int[n + 1];
        this.splittersD = new double[n + 1];
        this.sizes = new int[n + 1];
        this.rows = new Vector();
        this.styles = new Vector();
        this.multiSelect = bl;
        this.setLayout(new BorderLayout());
        this.setBackground(this.colorBg);
        this.options.set(4);
        for (int i = 0; i < n; ++i) {
            this.splitters[i] = 0;
            this.splittersD[i] = 0.0;
            this.sizes[i] = 0;
        }
    }

    public void setMode(int n, boolean bl) {
        if (bl) {
            this.options.set(n);
        } else {
            this.options.clear(n);
        }
    }

    public void setColumnSettings(int n, int n2) {
        this.splitters[n] = n2;
        this.sizes[n - 1] = n2;
        if (n2 > this.prefSizeX) {
            this.prefSizeX = n2;
        }
    }

    public void setColumnSettingsD(int n, double d) {
        this.splittersD[n] = d;
        this.doubleInUse = true;
    }

    public boolean addCellStyle(int n, Font font, Color color, Color color2, int n2) {
        if (this.styles.size() > 15) {
            return false;
        }
        cellStyle cellStyle2 = new cellStyle(n, font, color, color2, n2, this);
        this.styles.addElement(cellStyle2);
        return true;
    }

    public cellStyle getStylewID(int n) {
        if (this.styles.size() <= n) {
            return null;
        }
        cellStyle cellStyle2 = (cellStyle)this.styles.elementAt(n);
        return cellStyle2;
    }

    public FontMetrics getFMwID(int n) {
        cellStyle cellStyle2 = this.getStylewID(n);
        if (cellStyle2 == null) {
            return null;
        }
        return this.getFontMetrics(cellStyle2.cellF);
    }

    private void corrColumnSettings(int n) {
        int n2;
        if (this.options.get(4)) {
            for (int i = 0; i < this.splitters.length - 1; ++i) {
                this.splittersD[i + 1] = this.sizes[i];
            }
        }
        double d = this.splittersD[0];
        for (n2 = 1; n2 < this.splitters.length; ++n2) {
            d += this.splittersD[n2];
        }
        if (d < 0.1) {
            d = 0.1;
        }
        n2 = n - (int)d;
        for (int i = 1; i < this.splitters.length; ++i) {
            this.splitters[i] = (int)((double)n2 * this.splittersD[i] / d) + this.sizes[i - 1] + this.splitters[i - 1];
        }
        if (this.splitters[this.splitters.length - 1] > this.prefSizeX && !this.options.get(4)) {
            this.prefSizeX = this.splitters[this.splitters.length - 1];
        }
        this.doubleInUse = false;
    }

    public int getSelected() {
        return this.selectedRow;
    }

    public String getSelectedString(int n) {
        if (this.getSelected() <= 0) {
            return null;
        }
        rowCtrl rowCtrl2 = (rowCtrl)this.rows.elementAt(this.getSelected());
        if (rowCtrl2.cels.length <= n) {
            return null;
        }
        return new String(rowCtrl2.cels[n].trim());
    }

    public void setBaseColors(Color color, Color color2) {
        this.colorHBg = color;
        this.colorHBg = color2;
    }

    public void deleteRows() {
        this.rows.removeAllElements();
        this.selectedRow = 0;
        this.highlightedRows = new BitSet();
        for (int i = 0; i < this.splitters.length - 1; ++i) {
            this.sizes[i] = 0;
        }
    }

    public void deleteSelections() {
        this.selectedRow = 0;
        this.highlightedRows = new BitSet();
        this.redraw();
        this.repaint();
    }

    public rowCtrl findSameRow(String string) {
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            rowCtrl rowCtrl2 = (rowCtrl)enumeration.nextElement();
            if (!new String(rowCtrl2.cels[0].trim()).equals(string)) continue;
            return rowCtrl2;
        }
        return null;
    }

    public rowCtrl getIndRow(int n) {
        return (rowCtrl)this.rows.elementAt(this.rows.size() - 1);
    }

    public int addCell(int n, int n2, String string, Image image, int n3, int n4) {
        if (this.rows.size() <= n || n2 == 0) {
            return this.addRow(string, image, n3, n4);
        }
        this.addRowCell(n, n2, string, image, n3, n4);
        return 1;
    }

    public int addRow(String string, Image image, int n, int n2) {
        cellStyle cellStyle2 = this.getStylewID(n);
        int n3 = 0;
        if (!string.equals("")) {
            string = " " + string + "  ";
        }
        if (image != null) {
            n3 = image.getWidth(null);
        }
        if ((cellStyle2.special & 4) == 0) {
            if (this.sizes[0] < cellStyle2.getFM().stringWidth(string) + n3) {
                this.sizes[0] = cellStyle2.getFM().stringWidth(string) + n3;
            }
        } else {
            this.title = Math.max(this.title, cellStyle2.getFM().stringWidth(string));
        }
        rowCtrl rowCtrl2 = new rowCtrl(this.sizes.length, this, string, image, cellStyle2, n2, this.prefSizeY);
        this.rows.addElement(rowCtrl2);
        this.prefSizeY += rowCtrl2.rowSize;
        return this.rows.size() - 1;
    }

    public void addRowCell(int n, int n2, String string, Image image, int n3, int n4) {
        if (this.rows.size() <= n) {
            return;
        }
        try {
            int n5 = 0;
            if (!string.equals("")) {
                string = " " + string + "  ";
            }
            String string2 = string;
            if (image != null) {
                n5 = image.getWidth(null);
            }
            cellStyle cellStyle2 = this.getStylewID(n3);
            rowCtrl rowCtrl2 = (rowCtrl)this.rows.elementAt(n);
            int n6 = rowCtrl2.rowSize;
            rowCtrl2.addCell(n2, string, image, cellStyle2, n4);
            if (cellStyle2.special == 32) {
                string = "";
            }
            if (this.sizes[n2] < cellStyle2.getFM().stringWidth(string) + n5) {
                this.sizes[n2] = cellStyle2.getFM().stringWidth(string) + n5;
            }
            if (n6 < rowCtrl2.rowSize) {
                this.prefSizeY += rowCtrl2.rowSize - n6;
            }
            if (cellStyle2.special == 32) {
                string = string2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public synchronized void print(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        System.out.println("printing...");
        if (this.selectedRow > 0) {
            this.highlightedRows.clear(this.selectedRow);
        }
        int n = rectangle.y;
        this.printBack = false;
        PrintPanel printPanel = (PrintPanel)this.getParent();
        for (int i = 0; i < this.rows.size(); ++i) {
            rowCtrl rowCtrl2 = (rowCtrl)this.rows.elementAt(i);
            n += rowCtrl2.rowSize;
            rowCtrl2.drawRow(graphics, i);
        }
        this.printBack = true;
        if (this.selectedRow > 0) {
            this.highlightedRows.set(this.selectedRow);
        }
    }

    public void redraw() {
        int n;
        Object object;
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        if (this.width != dimension.width || this.height != dimension.height || this.ListModeSlow) {
            if (this.ListModeSlow) {
                object = (PrintPanel)this.getParent();
                this.height = ((Component)object).getParent().getSize().height;
                this.width = dimension.width;
            } else {
                this.height = dimension.height;
                this.width = dimension.width;
            }
            this.im = this.createImage(this.width, this.height);
            if (this.gg != null) {
                this.gg.dispose();
            }
            this.gg = this.im.getGraphics();
            this.corrColumnSettings(dimension.width);
        }
        this.gg.setColor(this.colorBg);
        this.gg.fillRect(0, 0, this.width, this.height);
        if (this.ListModeSlow) {
            object = this.getBounds();
            PrintPanel printPanel = (PrintPanel)this.getParent();
            this.gg.translate(0, -(printPanel.posY > ((Rectangle)object).y ? printPanel.posY - ((Rectangle)object).y : 0));
        }
        object = this.rows.elements();
        for (n = 0; this.firstSeenRow != n && object.hasMoreElements(); ++n) {
            object.nextElement();
        }
        if (this.ListModeSlow) {
            rowCtrl rowCtrl2;
            for (int i = 0; object.hasMoreElements() && i < ((PrintPanel)this.getParent()).divY; i += rowCtrl2.rowSize) {
                rowCtrl2 = (rowCtrl)object.nextElement();
                rowCtrl2.drawRow(this.gg, n++);
            }
        } else {
            while (object.hasMoreElements()) {
                rowCtrl rowCtrl3 = (rowCtrl)object.nextElement();
                i += rowCtrl3.rowSize;
                rowCtrl3.drawRow(this.gg, n++);
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Font font;
        Rectangle rectangle = graphics.getClipBounds();
        Dimension dimension = this.getSize();
        Rectangle rectangle2 = this.getBounds();
        if (this.ListModeSlow) {
            int n = ((PrintPanel)this.getParent()).posY;
            this.firstSeenRow = this.findRow(n -= rectangle2.y) != null ? this.tempCount : 0;
        }
        if (rectangle.x != 0 || rectangle.y != 0 || rectangle.width != dimension.width || rectangle.height != dimension.height) {
            this.repaint();
        }
        if ((font = graphics.getFont()) == null) {
            font = this.getStylewID((int)0).cellF;
            this.setFont(font);
            return;
        }
        if ((this.width != dimension.width || this.height != dimension.height || this.ListModeSlow) && this.dragColumn < 0) {
            try {
                this.redraw();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.ListModeSlow) {
            graphics.drawImage(this.im, 1, ((PrintPanel)this.getParent()).posY > rectangle2.y ? ((PrintPanel)this.getParent()).posY - rectangle2.y : 0, this);
        } else {
            graphics.drawImage(this.im, 1, 0, this);
        }
    }

    private void redrawRow(int n) {
        rowCtrl rowCtrl2 = (rowCtrl)this.rows.elementAt(n);
        rowCtrl2.drawRow(this.gg, n);
    }

    synchronized void changeSelection(rowCtrl rowCtrl2, int n, int n2) {
        if (this.multiSelect) {
            switch (n2) {
                case 2: {
                    if (this.highlightedRows.get(n)) {
                        this.highlightedRows.clear(n);
                    } else {
                        this.highlightedRows.set(n);
                    }
                    rowCtrl2.drawRow(this.gg, n);
                    break;
                }
            }
        } else {
            if (this.selectedRow >= 0) {
                this.highlightedRows.clear(this.selectedRow);
                this.redrawRow(this.selectedRow);
            }
            this.highlightedRows.set(n);
            rowCtrl2.drawRow(this.gg, n);
        }
        if (this.selectedRow != n) {
            if (n2 > 0) {
                this.postEvent(702, this.selectedRow);
            }
            this.selectedRow = n;
        }
        this.postEvent(701, n);
        this.repaint();
    }

    boolean postEvent(int n, int n2) {
        return this.postEvent(new Event(this, n, this.getObjectData(n2)));
    }

    private rowCtrl findRow(int n) {
        this.tempCount = 0;
        Enumeration enumeration = this.rows.elements();
        rowCtrl rowCtrl2 = null;
        while (enumeration.hasMoreElements()) {
            rowCtrl2 = (rowCtrl)enumeration.nextElement();
            if (rowCtrl2.yStart < n && rowCtrl2.yStart + rowCtrl2.rowSize > n) break;
            ++this.tempCount;
            rowCtrl2 = null;
        }
        return rowCtrl2;
    }

    public void putObjectData(Object object, int n) {
        rowCtrl rowCtrl2 = (rowCtrl)this.rows.elementAt(n);
        rowCtrl2.data = object;
    }

    public Object getObjectData(int n) {
        rowCtrl rowCtrl2 = (rowCtrl)this.rows.elementAt(n);
        return rowCtrl2.data;
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        rowCtrl rowCtrl2 = null;
        rowCtrl2 = this.findRow(n2);
        if (rowCtrl2 == null) {
            return true;
        }
        if ((rowCtrl2.styles[0].special & 8) != 0) {
            for (int i = 1; i < this.splitters.length - 1; ++i) {
                if (n >= this.splitters[i] + 5 || n <= this.splitters[i] - 5) continue;
                this.dragColumn = i;
                this.xDragLast = this.splitters[i];
                return true;
            }
        } else if (rowCtrl2.styles[0].special == 0) {
            this.changeSelection(rowCtrl2, this.tempCount, event.modifiers);
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseExit(Event event, int n, int n2) {
        Frame frame;
        if (0 != this.currentCursor && (frame = this.frame()) != null) {
            this.currentCursor = 0;
            frame.setCursor(0);
        }
        return super.mouseExit(event, n, n2);
    }

    public synchronized boolean mouseUp(Event event, int n, int n2) {
        if (this.dragColumn > 0) {
            if (n < 0) {
                n = 10;
            }
            this.gg.setColor(this.colorBg);
            this.gg.setXORMode(Color.black);
            this.gg.drawLine(this.xDragLast, 0, this.xDragLast, this.getSize().height);
            this.gg.setColor(Color.black);
            this.gg.setPaintMode();
            this.xDragLast = -1;
            this.splitters[this.dragColumn] = this.splitters[this.dragColumn - 1] > n ? this.splitters[this.dragColumn - 1] + 10 : n;
            this.redraw();
            this.repaint();
            this.dragColumn = -1;
            return true;
        }
        return super.mouseUp(event, n, n2);
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        Dimension dimension = this.getSize();
        if (this.dragColumn > 0) {
            if (n < 0) {
                n = 0;
            }
            this.gg.setColor(this.colorBg);
            this.gg.setXORMode(Color.black);
            this.gg.drawLine(this.xDragLast, 0, this.xDragLast, dimension.height);
            this.gg.drawLine(n, 0, n, dimension.height);
            this.gg.setColor(Color.black);
            this.gg.setPaintMode();
            this.xDragLast = n;
            this.repaint();
        }
        return true;
    }

    public synchronized boolean mouseMove(Event event, int n, int n2) {
        Frame frame;
        int n3;
        boolean bl = false;
        rowCtrl rowCtrl2 = null;
        rowCtrl2 = this.findRow(n2);
        if (rowCtrl2 == null) {
            return true;
        }
        if ((rowCtrl2.styles[0].special & 8) != 0) {
            for (n3 = 1; n3 < this.splitters.length - 1; ++n3) {
                if (n >= this.splitters[n3] + 5 || n <= this.splitters[n3] - 5) continue;
                bl = true;
                break;
            }
        }
        int n4 = n3 = bl ? 10 : 0;
        if (n3 != this.currentCursor && (frame = this.frame()) != null) {
            this.currentCursor = n3;
            frame.setCursor(this.currentCursor);
        }
        return false;
    }

    private rowCtrl getRow(boolean bl) {
        this.tempCount = this.selectedRow;
        rowCtrl rowCtrl2 = (rowCtrl)this.rows.elementAt(this.selectedRow);
        if (!bl) {
            if (this.tempCount > 1) {
                rowCtrl2 = (rowCtrl)this.rows.elementAt(--this.tempCount);
            }
            while (rowCtrl2.styles[0].special != 0 && this.tempCount > 1) {
                rowCtrl2 = (rowCtrl)this.rows.elementAt(--this.tempCount);
            }
            if (rowCtrl2.styles[0].special != 0) {
                return null;
            }
        } else {
            if (this.tempCount == 0) {
                this.tempCount = 0;
            }
            do {
                rowCtrl2 = (rowCtrl)this.rows.elementAt(++this.tempCount);
            } while (rowCtrl2.styles[0].special != 0 && this.tempCount < this.rows.size());
            if (rowCtrl2.styles[0].special != 0) {
                return null;
            }
        }
        return rowCtrl2;
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 1005: 
            case 1007: {
                rowCtrl rowCtrl2 = this.getRow(true);
                if (rowCtrl2 == null) break;
                this.changeSelection(rowCtrl2, this.tempCount, event.modifiers);
                this.redraw();
                this.repaint();
                break;
            }
            case 1004: 
            case 1006: {
                rowCtrl rowCtrl3 = this.getRow(false);
                if (rowCtrl3 == null) break;
                this.changeSelection(rowCtrl3, this.tempCount, event.modifiers);
                this.redraw();
                this.repaint();
            }
        }
        return true;
    }

    private Frame frame() {
        Container container;
        for (container = this; container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        return (Frame)container;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefSizeX, this.prefSizeY);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.prefSizeX, this.prefSizeY);
    }

    public void recalcSize() {
        if (this.options.get(4)) {
            this.doubleInUse = true;
        }
        this.prefSizeX = this.sizes[0];
        for (int i = 1; i < this.sizes.length; ++i) {
            this.prefSizeX += this.sizes[i];
        }
        this.prefSizeX = Math.max(this.prefSizeX, this.title + 12) + 2;
        this.ListModeSlow = this.prefSizeX * this.prefSizeY > 1200000;
    }
}

