#! /bin/sh
#
# Copyright (c) 2003-2004 eleven GmbH
# All rights reserved.
#
# To install this startupscript:
# Copy this script to /etc/init.d/expurgate
# Copy the expurgate file to /etc/default/expurgate
# cd /etc/rc2.d/; ln -s ../init.d/expurgate S21expurgate
#
# /etc/init.d/expurgate
#

set -e

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DESC="expurgate MTA"
NAME=expurgate
DAEMON=/usr/sbin/$NAME
PIDFILE=/var/run/expurgate/$NAME.pid
SCRIPTNAME=/etc/init.d/expurgate

# Gracefully exit if the package has been removed.
test -x $DAEMON || exit 0

# Read config file if it is present.
if [ -r /etc/default/$NAME ]
then
	. /etc/default/$NAME
fi

#
#	Function that starts the daemon/service.
#
d_start() {
	start-stop-daemon --start --quiet --pidfile $PIDFILE \
		--exec $DAEMON --name $NAME -- $EXPURGATE_OPTS -s -P $PIDFILE
}

#
#	Function that stops the daemon/service.
#
d_stop() {
	start-stop-daemon --stop --quiet --pidfile $PIDFILE \
		--name $NAME || echo -n " FAILED"
}

#
#	Function that sends a SIGHUP to the daemon/service.
#
d_reload() {
	start-stop-daemon --stop --quiet --pidfile $PIDFILE \
		--name $NAME --signal HUP
}

case "$1" in
    start)
        echo -n "Starting $DESC: $NAME"
        d_start
        echo "."
        ;;

    stop)
        echo -n "Stopping $DESC: $NAME"
        d_stop
        echo "."
        ;;

    reload|force-reload)
        echo -n "Reloading $DESC configuration..."
        d_reload
        echo "done."
        ;;

    restart)
        echo -n "Restarting $DESC: $NAME"
        d_stop
        sleep 1
        d_start
        echo "."
        ;;

    *)
        echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
        exit 1
        ;;
esac

exit 0
