package noris::IO::AutoEncoding;

use strict;
use warnings;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [qw(fix_encoding)] );
our @EXPORT_OK   = ( @{ $EXPORT_TAGS{'all'} } );
our @EXPORT      = qw( );

our $VERSION = '0.01';

sub fix_encoding {
    my $is_utf8;
    if ( defined $ENV{LC_ALL} && $ENV{LC_ALL} =~ /utf-?8/i
        || !defined $ENV{LC_ALL}
        && defined $ENV{LANG}
        && $ENV{LANG} =~ /utf-?8/i )
    {
        $is_utf8 = 1;
    }

    # if not a terminal everything stays as is. (hope)
    if ($is_utf8) {

        #print "# UTF8 mode\n";
        binmode( STDOUT, ":raw :encoding(UTF-8)" );
        binmode( STDERR, ":raw :encoding(UTF-8)" );
    }
    else {

        #print "# latin1 mode\n";
        binmode( STDOUT, ":raw :encoding(ISO-8859-15)" );
        binmode( STDERR, ":raw :encoding(ISO-8859-15)" );
    }

}

fix_encoding();

1;

__END__

=head1 NAME

noris::IO::AutoEncoding - Autoencoding IO messages

=head1 SYNOPSIS

    use noris::IO::AutoEncoding

=head1 DESCRIPTION

Das Skript versucht anhand der LOCALE oder der Environment Einstellungen
rauszufinden welches das passende Encoding für die jeweilige Shell ist.
Wenn UTF-8 möglich ist wird auch dieses angewendet ansonsten gibt es ein
Fallback auf ISO-8859-15

=head1 PUBLIC METHODEN

=over 4

=item fix_encoding()

Setzt die Enkodierung des IO Streams 

    fix_encoding();

=back

=head1 AUTOR

 Stelios Gikas <entwicklung@noris.net>
 Stelios Gikas <10040531@ticket.noris.net>

