# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::ui::web::support;

require Exporter;
use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use vars qw(@EXPORT_OK @ISA);
@ISA = qw(Exporter);
@EXPORT_OK = qw(
	esc
	get_default_query
	get_default_query4user
	get_msg
	info4kunde
	print_transaction
	prio_color
	req_url
	rt_footer
	rt_header
	select_a_date
	select_an_int
	user_param
	xstatus
  );

use Cf qw(
  $BGCOLOR
  $INFO4KUNDE
  $RT_DEFAULT_QUERY
  $RT_DOMAIN
  $RT_IGNORE_PARAMETERS
  $TICKET_DOMAIN
  $WDESCR
);
use CGI qw(:standard :any object center);
use Dbase::Help qw(DoFn qquote);
use Memoize qw(memoize);
use RT::I18N qw(english_preferred);
use RT::MIME qw(mime_parse);
use URI ();
use URI::Escape qw(uri_escape_utf8);
use URI::Find ();
use Encode qw();
use UTFkram qw(fix_mime_encoding decode_anything safe_encode_utf8);
use Umlaut qw(binmodus);

my $urls2html = URI::Find->new(
	sub {
		my ( $uri_o, $uri_txt ) = @_;
		my $txt = a( { href => $uri_o, target => '_blank' }, $uri_txt );
	}
);

sub esc_h($) {
	my($txt) = @_;
	# esc(scalar decode_mimewords($txt));
	# Wir brauchen das decode_anything, weil der decode()-Aufruf evtl. ISO-8859-1
	# zurückliefert.
	my $new_txt;
	eval {
		$new_txt = Encode::decode("MIME-Header", $txt);
	};
	$new_txt = $txt if $@;
	esc(decode_anything($new_txt));
}

sub ticket_url($) {
    my ($tn) = @_;
    delete local $ENV{TICKET_BACKENDS};
    require noris::Ticket::API
      and noris::Ticket::API->import('get_pooled_connection')
      unless defined &get_pooled_connection;
    my ($ticket_url) =
      get_pooled_connection()->get_ticket( $tn, ['ticket_url'] );
    $ticket_url;
}
memoize('ticket_url');

# Flags & 1 => kein Einbauen von Links (benötigt für <title>-Header)
sub esc($;$$) {
	my ( $txt, $request, $flags ) = @_;
	$flags = 0 unless defined $flags;

	return "&nbsp;" unless defined $txt;
	$txt = CGI::escapeHTML(decode_anything($txt));

	unless ( $flags & 1 ) {
		my @txt = split /
            (                                            # (gesamter Link)
                \b
                RT\#
                ([1-9][0-9]*)                            # RT#<4711>
                (?:
                    -
                    ([1-9][0-9]*)                        # RT#4711-<42>
                )?
                \b
              |
                \b
                ([1-9][0-9]*)                            # <4711>@...
                \@
                ( \Q$TICKET_DOMAIN\E | \Q$RT_DOMAIN\E )  # 4711@<...>
                \b
              |
                \[
				\Q$WDESCR\E
				\s
				\#
				([1-9][0-9]*)                            # [noris #<12345678>]
				\]
              |
                \b
                [Tt]icket\s*
                ( \d{1,13} )                             # 123456789 (ticket number)
                \b
             |
                \b
                Artikel\s+
                ( \d{1,13} )                             # Artikel 123456789 (article number)
                \b
             |
                \[\[
                (.*?)                                    # [[<Seite>]]
                \]\]
            )
		/x,
		  $txt;

		$txt = '';
		my $is_txt;
		my $escape = CGI::autoEscape();
		while (@txt) {
			if ( $is_txt = !$is_txt ) {
				my $text = shift @txt;
				# Einschränkung ist Workaround für RT#476386-1, wo die Analyse
				# eines uuencodeten Textes sehr viel Rechenzeit fraß und wir
				# nicht ohne Weiteres eingrenzen konnten, woran das liegt.
				$urls2html->find( \$text ) if $text !~ /^begin [0-7]{3} /m;
				$txt .= $text;
			}

			# elsif ( @txt < 6 ) { die }
			# nein, denn split() lässt undef-Werte am Ende der Liste weg

			else {
				my ( $text, $ticket1, $seq, $ticket2, $domain, $ticket3,
					$ticket4, $artikel, $wikiseite )
				  = splice @txt, 0, 9;
				$txt .= defined $wikiseite
				  ? '[[' . a(
					{
						href => '/wiki/index.php/' . uri_escape_utf8(
							$wikiseite,

							# Zeichenliste geklaut aus URI::Escape,
							# mit "/" als zusätzlicher Ausnahme,
							# vgl. Ticket #10033731:
							'^A-Za-z0-9\-_.!~*’()/'
						),
						target => 'Wiki',
					},
					$wikiseite
				  )
				  . ']]'
				  : defined $domain || defined $ticket3
				  ? do {
					if (
						defined(
							my $ticket_url = ticket_url(
								defined $ticket2 ? $ticket2 : $ticket3
							)
						)
					  )
					{
						a( { href => $ticket_url, target => 'Ticket' }, $text );
					}
					else { $text }
				  }
				  : defined $ticket4
				  ? do {
					if ( defined( my $ticket_url = ticket_url( $ticket4 ) ) ) {
						a( { href => $ticket_url, target => 'Ticket' }, $text );
					}
					else { $text }
				  }
				  : defined $artikel
				  ? 
						a( { href => '/otrs/index.pl?Action=AgentTicketZoom&ArticleID='.$artikel, target => 'Ticket' }, $text )
				  : a(
					{
						href => req_url(
							$request,
							display    => 'History',
							serial_num => $ticket1 || $ticket2
						  )
						  . ( defined $seq && "#t-$ticket1-$seq" ),
						target => 'Ticket',
					},
					$text
				  );
			}
		}
		CGI::autoEscape($escape);
	}
	$txt;
}

sub print_mime($$$$$);

# Funktion dient nur noch dazu, message/rfc822-Teile doch noch auseinander
# zu nehmen, da der MIME::Parser das nicht tut, vgl. RT#139965-4
sub mime_depth($);
sub mime_depth($) {
	my($msg) = @_;
	return 0 unless $msg;
	my $max = 0;
	my @parts = $msg->parts;
	foreach my $part(@parts) {
		my $mx = mime_depth($part);
		$max = $mx if $max < $mx;
	}
	if(not @parts and $msg->mime_type =~ m#^message/rfc822#i and not exists $msg->{SubMessage}) {
		my ( $nmsg, $state ) = mime_parse( $msg->bodyhandle->open('r') );
		if(ref $nmsg and ($state eq "" or $state eq "EOF")) {
			$msg->{SubMessage} = $nmsg;
		} else {
			$msg->{SubMessage} = "Bad MIME decoder state: '$state'";
			$max = 1 if $max == 0; ## for download
		}
	}
	if(ref $msg->{SubMessage}) {
		my $mx = mime_depth($msg->{SubMessage})+1;
		$max = $mx if $max < $mx;
	}
	$max+1;
}

use Text::Wrapper;
my $wr = new Text::Wrapper(body_start => '+ ', columns => 85);

sub get_msg($$$) {
	my ($request,$trans,$mimepath) = @_;
	require RT::database and RT::database->import('transaction_in')
	  unless defined &transaction_in;
	$trans = RT::database::transaction_in($trans,"_rt_system") unless ref $trans eq 'HASH';

	my ( $msg, $state ) = mime_parse( \$trans->{content} );

	$mimepath =~ s/^-//;
	
	if (not ref $msg or ($state ne "" and $state ne "EOF")) {
		if($mimepath eq "") {
			print $trans->{content};
			return undef;
		}
		return "Bad MIME decoder state '$state'"
	}
	fix_mime_encoding($msg); ## Nebeneffekt: scannt nach message/rfc822
	my $omsg = $msg;

	my $oldpath = "";
	while($mimepath =~ s/^(\d+)-?//) {
		my $nextpart = $1;
		my $nmsg = $msg->parts($nextpart-1);
		$nmsg = $msg->{SubMessage}
			if not $nmsg and $msg->mime_type =~ m#^message/rfc822#i and $nextpart == 1;
		unless($nmsg) {
			_delete($omsg);
			return "Empty message path for $oldpath-$nextpart";
		}
		$msg = $nmsg;
		$oldpath .= "$nextpart-";
	}

	$msg->head->unfold;
	my $type = $msg->mime_type || "text/plain";
	my $charset = $msg->head->mime_attr('content-type.charset');

	my $conv;
#	if($type eq "image/tiff") {
#		$type = "image/png";
#		$conv = "tifftopnm < ".$msg->bodyhandle->path." | pnmtopng -phys 7874 7874 1"
#	}

	my $fn = $msg->head->mime_attr('content-disposition.filename');
	$fn =~ y#\0-\037"/\\##d if defined $fn; # s. RT#252647
	$fn = $trans->{serial_num}."-".$trans->{seq}."-$mimepath" if not defined $fn or $fn eq "";
  
	print $request->header($charset ? (-charset => $charset) : (),
	                       -nph => !$DB::apache2,
	                       -type => $type,
	                       -content_disposition => "filename=\"$fn\"");
	binmodus(\*STDOUT);

	$msg->make_singlepart;
	if($msg->parts) {
		$msg->sync_headers(Length=>'COMPUTE');
		print $msg->body_as_string;
	} else {
		my $data;

		if($conv) {
			pipe(R2,W2);
			my $pid1 = fork();
			return "no fork: $!" unless defined $pid1;
			if($pid1 == 0) {
				close(R2);
				use POSIX qw(dup2);
				dup2(fileno(W2),1);
				exec $conv or die $!;
			}
			close(W2);

			print $data while read(R2,$data,8192) > 0;
			close(R2);

			waitpid($pid1,0);
		} else {
			$msg = $msg->open("r");
			print $data while $msg and $msg->read($data,8192) > 0;
		}
	}
	_delete($omsg);
	0;
}

sub print_transaction($$$) {
	my($header_mode, $request,$trans) = @_;
	require RT::database and RT::database->import('transaction_in')
	  unless defined &transaction_in;
	$trans = RT::database::transaction_in($trans,"_rt_system") unless ref $trans eq 'HASH';

	my ( $msg, $state ) = eval { mime_parse( \$trans->{content} ) };
	return b("Bad MIME decoder state '$@'/'$state'!").pre(esc($wr->wrap($trans->{content})))
		if not ref $msg or (defined $state and $state ne "" and $state ne "EOF");
	
	fix_mime_encoding($msg);

	my @res = print_mime($header_mode,$msg,"",$request,$trans);
	_delete($msg);
	@res;
}

sub _delete {
	my($msg) = @_;
	return unless ref $msg;
#	my @parts = $msg->parts;
#	foreach my $part(@parts) {
#		_delete($part);
#	}
#	# $msg->{SubMessage}->delete if ref $msg->{SubMessage};
	$msg->purge;
}

sub _indent(@) {
	my(@args) = @_;
	table({cellspacing=>0, cellpadding=>0, border=>0},
	      Tr(td({width=>5,-bgcolor=>"#666666"},"&nbsp;"),
	         td({width=>10,-bgcolor=>"#EEEEEE"},"&nbsp;"),
	         td(@_)));
}

sub type_id($$) {
	my($type,$disp) = @_;
	if($type =~ m#^message/rfc822#i) {
		$type = 3;
	} elsif($type =~ m#^multipart/signed#i) {
		$type = 5;
	} elsif($disp =~ m#^attach#i) {
		$type = 0;
	} elsif($type =~ m#^text/html#i) {
		$type = 2;
	} elsif($type =~ m#^text/(?:x-)?vcard$#i) { #
		$type = 4; # don't display vcard data inline
	} elsif($type =~ m#^message/#i or $type =~ m#^text($|/)#i) {
		$type = 1;
	} else {
		$type = 0;
	}
	$type;
}

sub print_mime($$$$$) {
	my($header_mode,$msg,$mimepath,$request,$trans)=@_;
	return i("(unknown)") unless $msg;
	return i($msg) unless ref $msg;

	$msg->head->unfold;
	my $headers = $msg->head->original_text;

	my $mime_type = my $type = $msg->mime_type || 'text/plain';
	my $disp = $msg->head->get('Content-Disposition') || "inline";
	$type = type_id($type,$disp);

	# join continuation lines 
	$headers =~ s/\n\s+/ /g;

	my @res;

	my $xpath = $mimepath;
	if($xpath eq "-") {
		$xpath = "";
	} elsif($xpath =~ /^\d/) {
		$xpath = "-$xpath";
	}
			
	if ($header_mode ne 'none') {
		push(@res,table(
			do {
				my $cont = 0;
				my @mp = map {
					my $line = $_;
					my ($field, $value)= split (/:\s+/,$line, 2);
					if($cont and $field =~ /^content-type$/i) {
						();
					} else {
						($header_mode eq 'all' or $field =~ /\b$header_mode\b/i) ? 
						Tr(
							td({align=>"right", valign=>'top'}, (ref $request and $field =~ /^content-type$/i) ?
							do { $cont=1; a({href=>req_url($request,-path=>$trans->{serial_num}."-".$trans->{seq}.$xpath,transaction=>join('-',@{$trans->{id}}),display=>"MIME",subpath=>$mimepath)},"Content")."-Type: " }
							: esc($field).": "),
							td({valign=>"top"}, esc_h($value))
						) : ();
					}
				} split (/\n/, $headers), "Mime-Version: 1.0", "Content-Type: text/plain; charset=utf-8", "Content-Transfer-Encoding: 8bit";
				push(@mp,Tr(td(i("keine Header")))) unless @mp;
				@mp;
			}
		));
	}

	# $body =~ s/(.{76})(.{3})/$1\n $2/g;

	$CGI::EXPORT{'-any'}=1;
	if($type == 4) { ## OBJECT bzw. :any wird ignoriert..?
		push(@res, object({src=>req_url($request,-path=>$trans->{serial_num}."-".$trans->{seq}.$xpath,transaction=>$trans->{id},display=>"MIME",subpath=>$mimepath),width=>"90%",height=>"30%"},
		"Dein Browser kann kein OBJECT dieses Typs darstellen."));
	} elsif($type == 2) { # HTML
		my $encoding = $msg->head->mime_attr('content-type.charset') || "ascii";
		use HTMLfilter qw($filter);
		my $res = $filter->scrub(Encode::decode($encoding,$msg->bodyhandle->as_string,Encode::FB_HTMLCREF));

		push(@res, object({src=>req_url($request,-path=>$trans->{serial_num}."-".$trans->{seq}.$xpath,transaction=>$trans->{id},display=>"MIME",subpath=>$mimepath),width=>"90%",height=>"60%"},
		$res));
	} else {
		if($msg->bodyhandle) {
			my $encoding = $msg->head->mime_attr('content-type.charset') || "ascii";
			if($type == 0) {
				push(@res,table(Tr(td("Length:&nbsp;"),td(i(length($msg->bodyhandle->as_string),"bytes"))),$msg->head->get("subject")?Tr(td("Subject:&nbsp;"),td(esc_h($msg->head->get("subject")))):""));
			} elsif($type == 3) {
   				push(@res, _indent(print_mime($header_mode,$msg->{SubMessage},$mimepath."-1",$request,$trans))) if $msg->{SubMessage};
				return @res;
			} else {
				my $content = esc(
					$wr->wrap(
						Encode::decode(
							$encoding, $msg->bodyhandle->as_string,
							Encode::FB_PERLQQ
						)
					),
					$request,
					$mime_type ne 'text/plain'
				);
				$content =~ s/(?<=\n)(-- ?)\n(.*)/
					my $id = join '-', @{$trans->{id}}, $mimepath;
					a( { href=>"javascript:void(toggleSignature('$id'))" }, $1 )
					. div( { id => $id, style => 'display:none' }, $2 )
				/es;
	  			push(@res,font({size=>"+0"},pre($content)));
			}
		}

		push(@res,font({size=>"+0"},pre(esc($wr->wrap(join("\n",@{$msg->preamble})))))) if $msg->preamble;
		my $num=0;
		if($type == 5) { # multipart/signed
   			push(@res, map { print_mime($header_mode,$_,$mimepath."-".++$num,$request,$trans) } $msg->parts);
		} else {
   			push(@res, map { _indent(print_mime($header_mode,$_,$mimepath."-".++$num,$request,$trans)) } $msg->parts);
		}
		push(@res,font({size=>"+0"},pre(esc($wr->wrap(join("\n",@{$msg->epilogue})))))) if $msg->epilogue;
	}
	
	@res;
}

# Wird effektiv nur für Prioritäten verwendet:
sub select_an_int($$) {
    my ($default, $name) = @_;
	$default = sprintf '%02d', $default || 0;
	Select(
		{ name => $name },
		map $default == $_
		? option( { value => 0+$_, selected => undef }, $_ )
		: option( { value => 0+$_                    }, $_ ),
		'00' .. '05',
		10 .. 50
	  )
}

my @MoY = ('Jan','Feb','Mar','Apr','May','Jun',
       	   'Jul','Aug','Sep','Oct','Nov','Dec');

sub select_a_date($$;$$) {
    my ($default,$name,$en,$zero) = @_;
    my ($wday, $mon, $mday, $hour, $min, $sec, $TZ, $year, $temp, $counter, $now_year);

	$default=$RT::time+7*24*3600 ## wenn garnix angegeben
    	unless defined $default;
    
	my %name;
	$name{0} = $en?"No":"Nein" if $zero;
	$name{1} = $en?"select...":"wähle...";
	$name{$RT::time+15*60} = $en?"15 minutes":"15 Minuten";
	$name{$RT::time+60*60} = $en?"1 hour":"1 Stunde";
	$name{$RT::time+$_*60*60} = $en?"$_ hours":"$_ Stunden" for 2, 3;
	$name{$RT::time+24*60*60} = $en?"1 day":"1 Tag";
	$name{$RT::time+$_*24*60*60} = $en?"$_ days":"$_ Tage" for 2, 3, 5;
	$name{$RT::time+7*24*60*60} = $en?"1 week":"1 Woche";
	$name{$RT::time+$_*7*24*60*60} = $en?"$_ weeks":"$_ Wochen" for 2, 3;
	$name{$RT::time+30*24*60*60} = $en?"1 month":"1 Monat";
	$name{$RT::time+$_*30*24*60*60} = $en?"$_ months":"$_ Monate" for 2, 3;
	$name{$RT::time+365*24*60*60} = $en?"1 year":"1 Jahr";

	popup_menu($name."_opt", [ sort { lc($a) <=> lc($b) } keys %name ],($zero && !$default)?0:1,\%name).($en?"&nbsp;or&nbsp;":"&nbsp;oder&nbsp;").do {
		my $dh = $default;

		$default=$RT::time+7*24*3600 ## wenn explizit Null angegeben
    		unless $default;

	require RT::support::utils and RT::support::utils->import('parse_time')
	  unless defined &parse_time;
    	($wday, $mon, $mday, $hour, $min, $sec, $TZ, $year)=parse_time($default); 
    	(undef,undef,undef,undef,undef,undef,undef, $now_year)=parse_time($RT::time); 
		$hour=0 unless $dh;
	
		"";
	}.
    Select({name => $name."_mday"},
		map { $mday == $_ ? option({selected => undef},$_) : option($_) } 1..31
	).
    Select({name => $name."_mon"},
		map { $mon eq $MoY[$_] ? option({selected => undef,value=>$_}, $MoY[$_]) : option({value=>$_},$MoY[$_]) } 0..11
	).
    Select({name => $name."_year"},
		map { $year == $_ ? option({selected => undef},$_) : option($_) } $now_year..($now_year+5)
	).
	($en? ', at ' : ', ab ').
	Select({name => $name."_hr"},
		map { $hour == $_ ? option({selected => undef}, $_) : option($_) } 0..23
	).
	($en ? '' : ' Uhr')
	;
}

sub otrs_disclaimer {
	my $request = shift;
	$request->table(
		{ bgcolor => '#FF9999', cellpadding => 8, width => '100%' },
		$request->Tr(
			$request->td(
				{ align => 'center', style => 'font-size:3em' },
				'Hier gibt es nichts (mehr) zu sehen.'
				  . $request->br
				  . 'Bitte gehen Sie weiter '
				  . $request->a( { href => '/otrs/' }, 'zum OTRS' ) . '!'
			)
		)
	  ),
	  ;
}

sub rt_header($@) {
	my ($request,@args) = @_;
	@args = grep {$_} @args;
	use POSIX 'ctime';
	my $title = "WebRT";
	$title = "Ticket" if $request->param('display') eq "History";
	$title .= " ".join("/",@args) if @args;
	my @scr;
	my @sch;
	push(@scr, -onLoad => "self.focus();" ) unless $request->param('display') eq "Queue";
	push(@sch, -refresh=>$request->param('refresh')) if $request->param('refresh');
	Dbase::log_statements( defined $ENV{PATH_INFO} and $ENV{PATH_INFO} =~ /debug/ );
	print $request->header( -charset => 'utf-8', -nph => !$DB::apache2, @sch );
	print $request->start_html( -bgcolor => $BGCOLOR,
	                            -dtd => "-//W3C//DTD HTML 3.2//EN",
	                            -title   => esc( $title, undef, 1 ),
	                            @scr,
                                  ),
	      otrs_disclaimer($request), $request->br;
}

sub rt_footer($) {
	my ($request) = @_;
	my $current_user = $request->param('auth_user');
	my $en = english_preferred;
	
	print center(
		$en?"You are currently authenticated as $current_user.":"Du bist
		momentan als '$current_user' eingeloggt.",
		br(),
		a({href => req_url($request,display=>"Logout")},
			$en?"Be careful not to leave yourself logged in from a ":"Nach der Arbeit über öffentlich zugängliche Browser",
			b($en?"public terminal":"immer ausloggen!")
		),br(),
    ),
	otrs_disclaimer($request),
	$request->end_html()."\n";
	if ( defined $ENV{PATH_INFO} and $ENV{PATH_INFO} =~ /debug/ ) {
		print "\n<hr><plaintext>\n";
		require Data::Dumper;
		print Data::Dumper->Dump([scalar Dbase::show_statement_log], ['*sql']);
		Dbase::clear_statement_log;
	}
}

# Die Unterstützung des Aufrufs ohne $request brauchen wir, um esc()
# in stunden/view.pl verwenden zu können, vgl. RT#427601.
sub req_url($;%) {
	my($request,%list) = @_;
	my $add = "";

	my $noquery = delete $list{"-noquery"};
	my $doquery = delete $list{"-query"};
	my $apath = delete $list{"-path"};

	my $url = URI->new( defined $request ? $request->url(-query=>$doquery) : '/rt' );
	$url->query("");

	if($doquery) {
		die "\$request must be defined for -query!" unless $request;
		foreach my $name($request->param) {
			$list{$name} = [ $request->param($name) ];
		}
	}

	if ( defined $request ) {
		for (user_param()) {
			defined $list{$_} || !defined( my $param = $request->param($_) )
			  and next;
			$list{$_} = $param;
		}
	}

	$url->path($url->path."/".$apath) if $apath;

	$url->query_form(%list);
	$url = $noquery ? $url->path : $url->path_query;
	$url;
}

sub xstatus($) {
	my($request) = @_;
	join '', map hidden( $_ => $request->param($_) ), user_param();
}

sub info4kunde($;$) {
	my ( $request, $kunde ) = @_;
	( my $url = $INFO4KUNDE ) =~ s/<HTTP_USER>/ uri_escape_utf8($request->param('auth_user')) /eg;
	$url =~ s/<kunde>/ uri_escape_utf8($kunde) /eg if defined $kunde;
	$url;
}

sub get_default_query() { get_default_query4user( $ENV{REMOTE_USER} ) }

sub get_default_query4user($) {
	my ($user) = @_;

	my $cgi;

	if ( defined( my $query = DoFn(<<_) ) ) {
	SELECT query
	FROM   person, rt_defaults
	WHERE  person.user = ${\ qquote($user) }
	   AND person.id = rt_defaults.person
_
		$cgi = CGI->new($query);
		$cgi->delete( split ' ', $RT_IGNORE_PARAMETERS );
	}
	else { $cgi = CGI->new($RT_DEFAULT_QUERY) }

	$cgi;
}

sub user_param() { qw(fup max_sequences nst rev show_all_headers) }

sub prio_color($) {
    my ($prio) = @_;
    !$prio         ? 'bbddff'
      : $prio < 10 ? 'ffbbbb'
      : $prio < 20 ? 'ffeebb'
      : $prio < 30 ? 'ddffdd'
      :              'eeeeee';
}

1;
