# (c) 1997 Jesse Vincent
# jesse@fsck.com
#
# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::ui::web;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use RT::database qw(add_transaction get_queue req_in transaction_history_in);
use RT::database::config qw(is_password);
use RT::database::manipulate qw(change_priority
		stall steal notify reopen change_requestors merge kill give resolve
		change_subject change_info change_kunde change_area
		add_comment add_pointer remail add_correspondence change_queue
		add_new_request change_date_due change_date_fdue change_work
		docushare is_visible set_visibility);
use CGI qw(:standard center);
use CGI::Util qw(escape);
use Dbase::Globals qw(content get_person get_descr find_descr get_kunden
		unterkunden oberkunde kpersinfo);
use Dbase::Help qw( Do DoFn DoN DoTime DoTrans DoTransExit DoTransSuspend
                    in_list isodate isotime qquote quote );
use RT::support::mail qw(extract_mailaddresses);
use RT::support::utils qw(parse_time
		can_manipulate_request normalize_sn can_display_queue
		can_display_request date_diff_ll can_add_time);
use RT::ui::web::support qw(
  get_msg
  print_transaction
  prio_color
  req_url
  xstatus
);
use RT::AddOns ();
use RT::I18N qw(english_preferred);
use Cf qw($BGCOLOR $DOCUSHARE $RT_DEFAULT_FIELDS $WDESCR);
use Docushare qw(propxget);
use Fehler qw(report_fehler ffehler fehler);
use URI::Escape qw(uri_escape_utf8);
use Time::Local qw(timelocal_nocheck);
use noris::MIME::Words qw(encode_mimewords);
use Encode qw();
use UTFkram qw(decode_anything);
use HTTPerror qw(run);
use Dbase::OTRS qw(TicketID);

use strict;
use vars qw(@ISA @EXPORT_OK);
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(activate $frames CheckAuth);

use vars qw(%req %users %queues $time);

my %is_status = (area=>1,status=>1,queue_id=>1,owner=>1,requestors=>1,
				 priority=>1,final_priority=>1,date_due=>1,subject=>1,
				 date_told=>1,kunde=>1,work=>1,info=>1,date_fdue=>1,
				 visibility=>1);

BEGIN {
	*req = \%RT::req;
	*time = \$RT::time;
	*users = \%RT::users;
	*queues = \%RT::queues;
}

use RT::ui::web::auth qw(AuthForceLogin AuthForceLogout);
use RT::ui::web::support qw(esc info4kunde rt_header rt_footer);
use RT::ui::web::forms;

use constant ID_LIMIT => 33;

sub activate($;$) {
	# Dbase::timer_start();
	my($request,$user) = @_;

	run {
		DoTrans {
			%req = (); ## solange die nicht aktuell zu halten sind...
			return unless defined initialize_sn($request);
			my ($value, $message)=RT::initialize();
			return unless CheckAuth($request,$user);

			$request->param( display => $request->param('serial_num') ? 'History' : 'Queue' )
			unless $request->param('display');

			return unless TakeAction($request); ## Redirect!

#	warn "Activate: Serial: $serial\n";

			{
				my $serial = $request->param('serial_num');
				my $user = $request->param('auth_user');

				req_in($serial,$user) if $serial;
			}
			DoTransExit(4); # ab hier kann nicht wiederholt werden
			DisplayForm($request);
		} 3;
	};
}

sub CheckAuth($;$$) {
	my($request,$user,$AuthRealm) = @_;

    $AuthRealm ||= "WebRT_$WDESCR";
    
    #if the user is trying to log out
    if (defined $request->param("display") and
		   $request->param("display") eq 'Logout') {
      	AuthForceLogin($request, $AuthRealm);
      	return undef;
    }

	if($user and defined $users{$user}) {
		$request->param('auth_user', $user);
		return 1;
	}
    
	$request->delete('auth_user');
	AuthForceLogout($request, $AuthRealm);
	return 0;
}

sub DisplayForm($) {
	my($request) = @_;
	my $serial = normalize_sn($request->param('serial_num'));
	my $req;
	my $user = $request->param('auth_user');
	my $display = $request->param('display') || "Queue";

	$request->param('serial_num',$serial) if $serial;

	if ($display eq 'MIME') {
		my $msg = get_msg($request,[split(/-/,$request->param('transaction'))],$request->param('subpath'));
		return unless $msg;
		$request->param('message',$msg);
		if($request->param('transaction') and not $serial) {
			($serial = $request->param('transaction')) =~ s/-.*//;
			$serial = normalize_sn(int($serial));
			$request->param('serial_num',$serial) if defined $serial;
		}
		$display = "History";
	}
	if($display eq "History" and not $serial) {
		## könnte im OTRS sein
		delete local $ENV{TICKET_BACKENDS};
		require noris::Ticket::API
				and noris::Ticket::API->import('get_pooled_connection')
			unless defined &get_pooled_connection;
		my $conn = get_pooled_connection($ENV{REMOTE_USER});
		my $ser = $request->param('serial_num');
		$ser =~ y/0-9//cd;
		$serial = $ser if defined $ser and $conn->get_ticket($ser);
	}
	if($display eq "History" and $serial) {
		my $otrs = TicketID($serial);
		if($otrs) {
			print $request->redirect(-nph => !$DB::apache2, -uri => "/otrs/index.fpl?Action=AgentTicketZoom&TicketID=$otrs");
			return;
		}
		req_in($serial,$user);
		$req = $req{$serial};
		rt_header($request, $serial,$req->{subject});
	} elsif($display eq "Queue") {
		my $en = english_preferred;
		my @owner;
		unless($request->param('q_owner_all')) {
			@owner = map { $_ eq '*' ? $en?'Me':'meine' : $_ eq '--' ? $en?'None':'freie' : $_ } $request->param('q_owner');
			unshift(@owner,"ohne") if $request->param('q_owner_not') and @owner;
	    }
		rt_header($request,
		    $request->param('q_status')?join(",",$request->param('q_status')):"",
			$request->param('q_updates') ? $en ? 'updates only' : 'nur Updates' : undef,
			$request->param('q_abo') ? $en ? 'subscribed only' : 'nur abonnierte' : undef,
			@owner ? join(" ",@owner) : undef,
			map( decode_anything($request->param("q_$_")), qw(kunde subject info inhalt) ),
			($request->param('q_queue_all') ? "" : $request->param('queue') ? ($request->param('q_queue_not')?$en?'excluding ':'ohne ':"").join(",",$request->param('queue')) : "") . ($request->param('q_area') ? "/".$request->param('q_area') : ""));
	} else {
		rt_header($request,$display,$request->param('serial_num'));
	}

	if ( my @messages = $request->param('message') ) {
		print span({style=>'color:red'}, esc("@messages")), br(), hr();
		$request->delete('message');
	}
	$request->delete('display');
	
	if ($display eq 'ReqOptions') {
		display_commands($request);
	} elsif ($display eq 'DumpEnv'){
		dump_env();
	} elsif ($display eq 'Queue') {
	  DoTransSuspend {
	  	my $was = $request->param('was');
		$was = $request->param('filter_aktualisieren') unless defined $was;
		unless ( defined $was ) {
			# tue nix
		} elsif ( $was =~ /^(?:Update Queue Filters|Filter (?:updaten|aktualisieren))$/ ) {
			# "Filter updaten" für Rückwärtskompatibilität mit alten Bookmarks, vgl. RT#295821
			Do("REPLACE rt_defaults SET person = $users{$user}{user_id}, query=${\ qquote( scalar $request->query_string ) }")
			  if $request->param('save_settings');
		} elsif ( $was eq 'Ignorieren' || $was eq 'Ignore' ) {
			$request->param('q_updates', "true");
			my $ids = join(" or ticket = ", map { s/-\d*//; $_ } split(/,/,$request->param('q_idlist')));
			my $pers = get_person($user);
			Do("delete writeonce from ticketlast where person = $pers and ( ticket = $ids )");
			map { s/-(\d*)//;; Do("insert writeonce into ticketlast(ticket,person,seq) values($_,$pers,9999)") } split(/,/,$request->param('q_idlist'));
		} elsif( $was eq 'Gelesen' || $was eq 'Skip' || $was eq 'überspringen') {
			$request->param('q_updates', "true");
			my $ids = join(" or ticket = ", map { s/-\d*//; $_ } split(/,/,$request->param('q_idlist')));
			my $pers = get_person($user);
			Do("delete writeonce from ticketlast where person = $pers and ( ticket = $ids )");
			map { s/-(\d*)//;; my $s=$1||0; Do("insert writeonce into ticketlast(ticket,person,seq) values($_,$pers,$s)") } split(/,/,$request->param('q_idlist'));
		} else {
			$request->param( message => ( english_preferred() ? 'Unknown value for p' : 'Unbekannter Wert im P' ) . qq(arameter "was": $was) );
		}
		my $ids = display_queue($request);

		# Fehlermeldungen von display_queue() anzeigen, z. B. "Unknown sort":
		if ( my @messages = $request->param('message') ) {
			print p(span({style=>'color:red'}, esc("@messages")));
			$request->delete('message');
		}
		FormQueueOptions($request,$ids);
		display_commands($request);
	  };
	} elsif ($display eq 'Create') {
		FormCreate($request);
	} elsif ($display eq 'Create_Step2') {

		FormCreate_Step2($request);
	} elsif ($display eq 'ShowNum') {
		FormShowNum($request);
	} elsif ($display eq 'SetPrio'){
		FormSetPrio($request);
	} elsif ($display eq 'SetKunde'){
		FormSetKunde($request);
	} elsif ($display eq 'SetSubject'){
		FormSetSubject($request);
	} elsif ($display eq 'SetInfo'){
		FormSetInfo($request);
	} elsif ($display eq 'SetUser'){
		FormSetUser($request);
	} elsif ($display eq 'SetMerge'){
		FormSetMerge($request);
	} elsif ($display eq 'ConfirmMerge' ) {
		FormConfirmMerge($request);
	} elsif ($display eq 'SetGive'){
		FormSetGive($request);
	} elsif ($display eq 'AddDocushare'){
		FormAddDocushare($request);
	} elsif ($display eq 'SetDocushare'){
		FormDocushare($request);
	} elsif ($display eq 'SetMail'){
		FormRemail($request);
	} elsif ($display eq 'SetComment'){
		FormComment($request);
	} elsif ($display eq 'SetReply') {
		FormReply($request);
	} elsif ($display eq 'SetThisReply') {
		FormReply($request,1);
	} elsif ($display eq 'SetGroupReply') {
		FormReply($request,2);
	} elsif ($display eq 'exec') {
		FormExec($request);
	} elsif ($display eq 'SetKill') {
		FormSetKill($request);
	} elsif ($display eq 'SetSteal') {
		FormSetSteal($request);
	} elsif ($display eq 'SetStall') {
		FormSetStall($request);
	} elsif ($display eq 'SetStatus') {
		FormSetStatus($request);
	} elsif ($display eq 'SetQueue') {
		FormSetQueue($request);
	} elsif ($display eq 'SetArea') {
		FormSetArea($request);
	} elsif ($display eq 'SetDateFDue') {
		FormSetDateFDue($request);
	} elsif ($display eq 'SetDateDue') {
		FormSetDateDue($request);
	} elsif ($display eq 'SetWork') {
		FormSetWork($request);
	} elsif ( $display =~ /^(?:History|(?:un)?subscribe)\z/ ) {
	  DoTransSuspend {
		if($serial) {
			if ( $display =~ /subscribe\z/ && can_manipulate_request($serial,$user) > 0 ) {
				my $en = english_preferred;
				my $uid = get_person $user or die qq(User "$user" ist unbekannt.\n);
				my $subscribed = DoFn "SELECT 1 FROM ticketabo WHERE ticket = $serial AND person = $uid";
				if ( $display eq 'subscribe' ) {
					if ($subscribed) {
						print $request->p( $en ? 'You have already been subscribed.' : 'Haste doch schon abonniert!?' );
					} else {
						Do "REPLACE ticketabo (ticket,person) VALUES ($serial,$uid)"
    						  and add_transaction $serial, $user, subscription => '+', '', $user;
						undef $req{$serial};
						req_in($serial,$user);
						print $request->p( $en ? 'Subscribed.' : 'Ticket abonniert.' );
					}
				} elsif ( $display eq 'unsubscribe' ) {
					if ($subscribed) {
						Do "DELETE FROM ticketabo WHERE ticket=$serial AND person=$uid"
						  and add_transaction $serial, $user, subscription => '-', '', $user;
						undef $req{$serial};
						req_in($serial,$user);
						print $request->p( $en ? 'Unsubscribed.' : 'Ticket-Abo gekündigt.' );
					} else {
						print $request->p( $en ? 'You are not subscribed to this ticket.' : 'Du hast dieses Ticket doch gar nicht (mehr) abonniert!?' )
					}
				} else { die } # This never happens.
			}
			display_commands($request,1);
			do_xbar($request,$serial);
			do_bar($request,$serial);
		
			display_summary($request,$serial);
			print hr();
			RT::AddOns->dispatch( $req{$serial}{queue}{name} => show_form => $req{$serial}, $request );
			display_history_tables($request,$serial);
			do_bar($request,$serial);
			do_xbar($request,$serial);
			display_commands($request,1);
		} else {
			print "History-Befehl ohne Serial? Browserproblem?"
		}
	  };
	} else {
		print hr(),b("Request type '$display' unknown!"),hr();
	}
	rt_footer($request); 
}

sub fix_data($$) {
	my($hdr,$request) = @_;
	my $data = $request->param('content');
	$hdr = Encode::encode("utf-8",decode_anything($hdr),Encode::FB_HTMLCREF);
	$data = Encode::encode("utf-8",decode_anything($data),Encode::FB_HTMLCREF);
	return $hdr.$data;
}

sub TakeAction($) {
	my($request) = @_;
    my $date_due;
    my $date_fdue;
	my ($trans, $StatusMsg);
	my $serial = normalize_sn($request->param('serial_num'));

	my $user = $request->param('auth_user');
	my $action = $request->param('whatever');
	return 1 unless $action;

	my $req;
	if($serial) {
		req_in($serial,$user);
		$req = $req{$serial};
	}

	if(not $request->param('due_opt')) {
		$request->delete('date_due');
	} elsif ($request->param('due_opt') == 1) {
		$request->param('date_due',timelocal_nocheck(0,0,$request->param('due_hr'),$request->param('due_mday'),$request->param('due_mon'),$request->param('due_year')));
	} else {
		$request->param('date_due',$request->param('due_opt'));
	}

	unless ( defined $request->param('fdue_opt') ) {
		$request->delete('date_fdue');
	} elsif ($request->param('fdue_opt') == 1) {
		$request->param('date_fdue',timelocal_nocheck(0,0,$request->param('fdue_hr'),$request->param('fdue_mday'),$request->param('fdue_mon'),$request->param('fdue_year')));
	} else {
		$request->param('date_fdue',$request->param('fdue_opt'));
	}

	my $subject = $request->param('subject');
	if ( defined $subject ) {
		$subject = decode_anything($subject);
		$subject =~ s/\n+\z//;
		$subject =~ s/\n(?=\S)/\n\t/g;
	}

	if ($action eq "create" or ($action eq "comment" and ( my $queue_new = $request->param('queue_new') ) ne "--")) {
			# ein neuer Request, oder ein Crossrequest.

			my $queue = $request->param('comment') ? $request->param(queue=>$queue_new)
			                                       : $req->{queue_id} || $request->param('queue');

			$request->param('date_due', $time+$date_due*3600*24)
				if $queue and not $request->param('date_due') and ($date_due = $queues{$queue}{default_due});

			my $hdr = "Content-Type: text/plain; charset=utf-8\nContent-Transfer-Encoding: 8bit\n";
			$hdr .= "Subject: ${\encode_mimewords($subject)}\n" if defined $subject;
			if($request->param('to')) {
				$hdr .= "To: ".extract_mailaddresses($request->param('to'))."\n"
			} elsif ( $request->param('requestors') && $request->param('mail2requestors') ) {
				$hdr .= "To: ".extract_mailaddresses($request->param('requestors'))."\n"
			}
			$hdr .= "Cc: ".extract_mailaddresses($request->param('cc'))."\n" if $request->param('cc');
			$hdr .= "Bcc: ".extract_mailaddresses($request->param('bcc'))."\n" if $request->param('bcc');
			$hdr =~ s/\s+\n/\n/g;
			$hdr .= "\n";

			my $data = fix_data($hdr,$request);

			($serial, my $transaction, $StatusMsg) = $action eq 'comment' ? add_pointer($request, $serial, $queue_new, $data)
		                                                              : add_new_request($request, $data);

			fehler $StatusMsg unless $serial;
			
			print $request->redirect(-nph => !$DB::apache2, -uri => req_url($request,display=>"History",serial_num=>$serial,message=>$StatusMsg));
			return 0;
	}
	return 1 unless $user;

	my $display = "History";

	($trans, $StatusMsg) = change_priority ($serial, $request->param('prio'), $user)
		if content( $request->param('prio') );

	($trans, $StatusMsg) = steal ($serial, $user)
		if $action eq 'steal' and $request->param('yes_do_it');

	($trans, $StatusMsg) = notify ($serial, $time, $user)
		if $action eq 'notify';

	($trans, $StatusMsg) = change_work ($serial, $request->param('work'), $user)
		if $action eq 'work';

	($trans, $StatusMsg) = change_requestors ($serial, $request->param('requestors'), $user)
		if $action eq 'user';

	($trans, $StatusMsg) = $request->param('yes')
	                       ? merge($serial, $request->param('merge_into'), $user)
			       : ( 0, 'Die Tickets bleiben getrennt.' )
		if $action eq 'merge' and $request->param('merge_into');

	($trans, $StatusMsg) = kill ($serial, $user)
		if $action eq 'kill' and $request->param('yes_do_it');

	if ($action eq 'give' and $request->param('owner')) {
		($trans, $StatusMsg) = give ($serial, $request->param('owner'), $user);
		$request->param('display', 'SetSteal')
			if $trans == 0 and $request->param('owner') eq $user;
	}
	($trans, $StatusMsg) = give ($serial, "--", $user)
		if $action eq 'untake';

	if ( $action eq 'stall' || $request->param('status') eq 'stalled' ) {
		($trans, $StatusMsg) = change_date_due ($serial, $request->param('date_due'), $user)
			if $request->param('date_due');

		($trans, $StatusMsg) = stall ($serial, $user)
			if $action eq 'stall';
	}

	if ( length( my $info = decode_anything($request->param('info')) ) ) {
		($trans, my $statusmsg) = change_info($serial, $info eq '-' ? '' : $info, $user);
		$StatusMsg .= ( $StatusMsg && ' ' ) . $statusmsg;
	}

	($trans, $StatusMsg) = resolve($serial, $user) if $action eq 'resolve';

	($trans, $StatusMsg) = reopen ($serial, $user)
		if $action eq "open";

	($trans, $StatusMsg) = change_subject ($serial, decode_anything($request->param('subject')), $user)
		if $action eq 'subject' and $request->param('subject');

	($trans, $StatusMsg) = change_kunde ($serial, $request->param('kunde'), $user)
		if $action eq 'kunde' and $request->param('kunde');

	($trans, $StatusMsg) = change_area ($serial, decode_anything($request->param('area')), $user)
		if $action eq 'area' || $action eq 'comment' || $action eq 'respond' and $request->param('area');

	if($action eq "comment") {
		my $hdr = "Content-Type: text/plain; charset=utf-8\nContent-Transfer-Encoding: 8bit\n";
		$hdr .= "Subject: ${\encode_mimewords($subject)}\n" if defined $subject;
		$hdr .= "To: ".extract_mailaddresses($request->param('to'))."\n" if $request->param('to');
		$hdr .= "Cc: ".extract_mailaddresses($request->param('cc'))."\n" if $request->param('cc');
		$hdr .= "Bcc: ".extract_mailaddresses($request->param('bcc'))."\n" if $request->param('bcc');
		$hdr =~ s/\s+\n/\n/g;
		$hdr .= "\n";
		my $data = fix_data($hdr,$request);

		($trans, $StatusMsg) = add_comment ($request, $data);
	}

	($trans, $StatusMsg) = remail ($serial, [split(/-/,$request->param('transaction'))], $request->param('to'), $user)
		if $action eq "remail" and $request->param('to') and $request->param('transaction');

	($trans, $StatusMsg) = docushare ($serial, $request->param('document'), $user)
		if $action eq "docushare" and $request->param('document');

	if($action eq "respond") {
		if($request->param('to') eq "") {
			$StatusMsg = "Das ist ein Reply. Der _braucht_ eine To:-Adresse!";
		} else {
			my $hdr = "Content-Type: text/plain; charset=utf-8\nContent-Transfer-Encoding: 8bit\n";

			$hdr .= "Subject: ${\encode_mimewords($subject)}\n" if defined $subject;
			$hdr .= "To: ".extract_mailaddresses($request->param('to'))."\n" if $request->param('to');
			$hdr .= "Cc: ".extract_mailaddresses($request->param('cc'))."\n" if $request->param('cc');
			$hdr .= "Bcc: ".extract_mailaddresses($request->param('bcc'))."\n" if $request->param('bcc');
			;$hdr =~ s/\s+\n/\n/g;
			$hdr .= "\n";

			( my $serial = $request->param('serial_num') ) =~ /^\d+\z/ or die;
			( my $queue  = $request->param('queue'     ) ) =~ /^\S+\z/ or die;
			my $data = fix_data($hdr,$request);
			($trans, $StatusMsg) = add_correspondence ($request, $data);
			RT::AddOns->dispatch( $queue, reply => $serial );
		}
	}

	($trans, $StatusMsg) = change_date_due ($serial, $request->param('date_due'), $user)
		if $action eq "date_due" and $request->param('date_due');

	($trans, $StatusMsg) = change_date_fdue ($serial, $request->param('date_fdue'), $user)
		if $action eq "date_fdue" and defined $request->param('date_fdue');

	if ( $action eq "queue" and $request->param('queue') ) {
		($trans, $StatusMsg) = change_queue ($serial, $request->param('queue'), $user);
		RT::AddOns->dispatch( $request->param('queue') => init_ticket => $serial );
	}

	if ( $action eq "status" and $request->param('status') ) {
		my $sm;
		if ($request->param('status') eq "resolved") {
			($trans, $sm) = resolve ($serial, $user)
		} elsif ($request->param('status') eq "open") {
			($trans, $sm) = reopen ($serial, $user)
		} elsif ($request->param('status') eq "stalled") {
			($trans, $sm) = stall ($serial, $user)
		} elsif ($request->param('status') eq "dead") {
			$display = "SetKill";
		} else {
			$StatusMsg = "Unknown new status: '".$request->param('status')."'";
		}
		$StatusMsg = join '; ', grep content($_), $StatusMsg, $sm;
	}

	if ( $action eq 'set_visibility' ) {
		if ( not my $extern = $request->param('extern') ) {
			$StatusMsg = 'parameter "extern" missing';
		}

		# In serial_num würde bei gemergten Tickets die falsche ID stehen,
		# weil das weiter oben in diesem Modul verbogen wird, s. RT#389190.
		elsif ( !defined( my $transaction = $request->param('transaction') ) ) {
			$StatusMsg = 'parameter "transaction" missing';
		}
		elsif ( $transaction !~ /^(\d+)-(\d+)\z/ ) {
			$StatusMsg = 'wrong value for parameter "transaction"';
		}
		else {
			( $trans, $StatusMsg ) = set_visibility( $1, $2, $extern, $user );
		}
	}

	if ( $action eq 'save_data' and ( my $addon = $request->param('addon') ) ) {
		$addon =~ /^\w+$/ or die;
		$StatusMsg = RT::AddOns->call( $addon => 'save_data' => $request );
	}

	$StatusMsg = "Unknown or invalid action '$action'" unless $StatusMsg;

	print $request->redirect(-nph => !$DB::apache2, -uri => req_url($request,display=>$display,serial_num=>$serial,message=>$StatusMsg));
	0;
}

sub blink_if_elapsed($) {
	my($date) = @_;
	if ( $date =~ /^-/ ) {
		font( { color => 'red' }, strong("<blink>$date</blink>") )
	}
	else { $date }
}

sub display_queue($) {
	my($request) = @_;
	my $user = $request->param('auth_user');

	my $en = english_preferred;
	my $fields = $request->param('q_fields');

	my ( $area_ops, $kunde_ops, $subject_ops, $info_ops, $queue_ops, $status_ops, $prio_ops, $user_ops, $order_ops, $limit_ops, $query_string );
	
	my $res;
	my $add_from = my $joins = '';

	my @owner_ops;
	unless($request->param('q_owner_all')) {
		my %owner;
		for ( $request->param('q_owner') ) {
			if ( $_ eq '*' ) { ++$owner{ $users{$user}{user_id} } }
			elsif ( $_ eq '--' ) { ++$owner{''} }
			elsif( my $owner = get_person($_) ) { ++$owner{$owner} }
	 	}
		if ( keys %owner ) {
			my $ohne_owner = delete $owner{''};
			my $not = $request->param('q_owner_not') ? ' NOT' : ''
			  or $request->param('own_tickets') and ++$owner{ $users{$user}{user_id} };
			push @owner_ops, "ticket.bearbeiter$not IN (" . join( ',', keys %owner ) . ')'
			  if keys %owner;
			if ( $ohne_owner xor $not ) {
				push @owner_ops, 'ticket.bearbeiter IS NULL';
			}
			elsif ( !@owner_ops && $not ) {
				push @owner_ops, 'ticket.bearbeiter IS NOT NULL';
			}
		}
	}

	unless($request->param('q_queue_all')) {
		foreach my $q($request->param('queue')) {
			if ($res = $queues{$q}) {
				$queue_ops .= " OR " if $queue_ops;
				$queue_ops .= " ticket.queue = ".$res->{id};
			}
		}
	}
	
	if($request->param('q_status')) {
		foreach my $q($request->param('q_status')) {
			$q = find_descr("tickets",$q);
			if($q) {
				$status_ops .= " OR " if $status_ops;
				$status_ops .= " ticket.status = ".find_descr("tickets",$q) ;
			}
		}   
	} else {
		$status_ops .= " OR " if $status_ops;
		$status_ops .= " ticket.status != ".find_descr("tickets","dead") ;
	}
	
	# Suche nach Requestor
	if ($request->param('q_user_other')) {
		$joins .= <<'_' if $joins !~ / JOIN ticketadr /i;
	LEFT JOIN ticketadr ON ticketadr.ticket = ticket.id
_
		foreach my $u(split(/[,\s]+/,$request->param('q_user_other'))) {
			my $uid = get_person($u);
			if($uid) {
				$user_ops .= " OR " if $user_ops;
				$user_ops .= " ticketadr.person = $uid ";

				$uid = DoFn("select email from person where id=$uid");
				if(defined $uid) {
					$user_ops .= " OR ticketadr.email = ${\qquote $uid} ";
					$u = undef if $uid eq $u;
				}
			}
			if(defined $u) {
				$user_ops .= " OR " if $user_ops;
				$user_ops .= "ticketadr.email = ${\qquote $u}";
			}
		}
	}
	
	if ( content( my $q_subject = decode_anything($request->param('q_subject')) ) ) {
		$subject_ops .= ' OR ' if $subject_ops;
		$subject_ops .= ' ticket.subject RLIKE ' . qquote(".*$q_subject.*");
	}

	if ( content( my $q_info = decode_anything($request->param('q_info')) ) ) {
		$info_ops .= ' OR ' if $info_ops;
		$info_ops .= ' ticket.infotext RLIKE ' . qquote(".*$q_info.*");
	}

	if ($request->param('q_inhalt')) {
		$add_from = ", ticketid as ttxt, ticket as ticket2 $add_from";
		$query_string .= " AND " if $query_string;
		$query_string .= "ticket2.ticket = ticket.id AND ticket2.id = ttxt.ticket";
		$query_string .= " AND ttxt.inhalt like '%${\quote $request->param('q_inhalt')}%'";
	}

	my @messages;

	if ( $res = $request->param('q_kunde') ) {
		my ( %pos, %neg );
		foreach my $kk ( split( /[,\s]+/, $res ) ) {
			my $not = $kk =~ s/^!\s*// ? '!' : '';
			my $auch_verbundene = $kk =~ s/^\*\s*//;

			if ( $kk eq "-" ) {
				${ $not ? \%neg : \%pos }{0} = 1;
			}
			elsif ( !( my @kunden = get_kunden($kk) ) ) {
				push @messages,
				  font( { color => 'red' },
					qq(Kunde "$kk" wurde nicht gefunden.) );
			}
			elsif ($auch_verbundene) {
				@{ $not ? \%neg : \%pos }{ map unterkunden( oberkunde($_) ),
					@kunden } = ();
			}
			else {
				@{ $not ? \%neg : \%pos }{@kunden} = ();
			}
		}
		delete @pos{ keys %neg } if keys %pos && keys %neg;
		$kunde_ops =
		  join ' OR ', $pos{0} ? 'ticket.kunde IS NULL' : (),
		  keys %pos
		  ? 'ticket.kunde '
		  . (
			keys %pos == 1
			? "= @{[ keys %pos ]}"
			: 'IN (' . join( ',', keys %pos ) . ')' )
		  : keys %neg
		  ? 'ticket.kunde '
		  . (
			keys %neg == 1
			? "!= @{[ keys %neg ]}"
			: 'NOT IN (' . join( ',', keys %neg ) . ')' )
		  . ( $neg{0} ? '' : ' OR ticket.kunde IS NULL' )
		  : ();
	}
	
	$res = $request->param('q_area');
	if(defined $res and $res ne "") {
		$res =~ tr/\*\?/%_/;
		if($res =~ s/^!//) {
			if($res eq "-") {
				$area_ops = "ticket.area is not null";
			} else {
				$joins .= <<'_' if $joins !~ / JOIN queue_areas AS sarea /i;
	LEFT JOIN queue_areas AS sarea ON ticket.queue_area = sarea.id
_
				foreach my $kk(split(/[,\s]+/,$res)) {
					$area_ops .= " AND " if $area_ops ne "";
					$area_ops .= "NOT ( sarea.name LIKE '${\quote $kk}' )";
				}
			}
		} else {
			if($res eq "-") {
				$area_ops = "ticket.area is null";
			} else {
				$joins .= <<'_' if $joins !~ / JOIN queue_areas AS sarea /i;
	LEFT JOIN queue_areas AS sarea ON ticket.queue_area = sarea.id
_
				foreach my $kk(split(/[,\s]+/,$res)) {
					$area_ops .= " OR " if $area_ops ne "";
					$area_ops .= "sarea.name LIKE '${\quote $kk}'";
				}
			}
		}
	}

	if ( my ($confitems) = in_list( 'rt_incidents_confitem.confitem' => '', grep /^\d+\z/, $request->param('q_ci') ) ) {
		$query_string .= ' AND ' if $query_string;

		if ( $request->param('q_ci_not') ) {
			$joins .= <<_;
	LEFT JOIN rt_incidents_confitem ON rt_incidents_confitem.incident = ticket.id AND $confitems
_
			$query_string .= 'rt_incidents_confitem.confitem IS NULL';
		}
		else {
			$query_string .= " rt_incidents_confitem.incident = ticket.id AND $confitems";
			$add_from = ",rt_incidents_confitem $add_from";
		}
	}
	
	my $sort = $request->param('q_sort') || "number,DOWN";
	foreach my $q(split(/,/,$sort)) {
		if($q eq "UP") {
			# nothing
		} elsif($q eq "DOWN") { 
			$order_ops .= " DESC" if $order_ops && $order_ops !~ /, \z/;
		} elsif ($q eq "date_fdue") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ftermi";
		} elsif ($q eq "date_due") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "termi";
		} elsif ($q eq "timestamp") {       
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ticket.d_told"; 
		} elsif ($q eq "date_acted") {       
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ticket.d_acted"; 
		} elsif ($q eq "number") {       
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ticket.id"; 
		} elsif ($q eq "priority") {       
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ticket.wichtig"; 
		} elsif ($q eq "owner") {       
			$joins .= <<'_' if $joins !~ / AS s_person /i;
	LEFT JOIN person AS s_person ON s_person.id = ticket.bearbeiter
_
			$order_ops .= ", " if $order_ops;
			$order_ops .= "s_person.user"; 
		} elsif ($q eq "sales_p") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "kunde.ap_vertrieb";
		} elsif ($q eq "tech_p") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "kunde.ap_technik";
		} elsif ($q eq "user") {
			$joins .= <<'_' if $joins !~ / JOIN ticketadr /i;
	LEFT JOIN ticketadr ON ticketadr.ticket = ticket.id
_
			$joins .= <<'_' if $joins !~ / AS t_person /i;
	LEFT JOIN person AS t_person ON t_person.id = ticketadr.person
_
			$order_ops .= ", " if $order_ops;
			$order_ops .= "t_person.user,t_person.email, ticketadr.email"; 
		} elsif ($q eq "status") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ticket.status"; 
		} elsif ($q eq "age" or $q eq "date_created") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ticket.beginn"; 
		} elsif ($q eq "d_acted") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "ticket.d_acted"; 
		} elsif ($q eq "subject") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "subject"; 
		} elsif ($q eq "info") {
			$order_ops .= ", " if $order_ops;
			$order_ops .= "infotext"; 
		} elsif ($q eq "kunde") {       
			$order_ops .= ", " if $order_ops;
			$order_ops .= "kunde.name"; 
		} elsif ($q eq "queue") {
			$joins .= <<'_' if $joins !~ / AS s_queue /i;
	LEFT JOIN queue AS s_queue ON s_queue.id = ticket.queue
_
			$order_ops .= ", " if $order_ops;
			$order_ops .= "s_queue.name"; 
		} elsif ($q eq "area") {
			$joins .= <<'_' if $joins !~ / AS s_area /i;
	LEFT JOIN queue_areas AS s_area ON s_area.id = ticket.queue_area
_
			$order_ops .= ", " if $order_ops;
			$order_ops .= "s_area.name"; 
		} elsif ( $q eq 'zeit_soll' ) {
			$order_ops .= ', ' if $order_ops;
			$order_ops .= 'ticket.zeit';
		} else {
			$request->param( message => $en ? qq(Unknown sort "$q") : qq(Sortierung nach "$q" ist nicht implementiert.) )
		}
	}
	
	if ($request->param('q_updates')) {
		my $pers = get_person($user,undef,2);
		if($pers) {
			$joins .= <<_ if $joins !~ / JOIN ticketlast /i;
	LEFT JOIN ticketlast ON ticketlast.ticket = ticket.id AND ticketlast.person = $pers
_
			if ($query_string) {$query_string .= " AND ";}
			$query_string .= "( ticketlast.seq is null OR ticketlast.seq < ticket.maxseq )";
		}
	} 
	if ($request->param('q_abo')) {
		my $pers = get_person($user);
		if($pers) {
			$joins .= <<_ if $joins !~ / JOIN ticketabo /i;
	LEFT JOIN ticketabo ON ticketabo.ticket = ticket.id AND ticketabo.person = $pers
_
			if ($query_string) {$query_string .= " AND ";}
			$query_string .= "( ticketabo.ticket is not null )";
		}
	} 

	
	if ($subject_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= "( $subject_ops )";
	}
	if ($info_ops) {
		$query_string .= ' AND ' if $query_string;
		$query_string .= "( $info_ops )";
	}
	if ($area_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= "( $area_ops )";
	}
	if ($kunde_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= '( ';
		$query_string .= "ticket.bearbeiter = $users{$user}{user_id} OR "
		  if $request->param('own_all_customers');
		$query_string .= "$kunde_ops )";
	}
	if ($queue_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= "( ticket.bearbeiter = $users{$user}{user_id} OR "
		  if $request->param('own_tickets');
		$query_string .= "NOT " if $request->param('q_queue_not');
		$query_string .= "( $queue_ops )";
		$query_string .= ' )' if $request->param('own_tickets');
	}
	if ($prio_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= "( $prio_ops )";
	}
	if ($status_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= "( $status_ops )";
	}
	if ($user_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= "( $user_ops )";
	}
	if (@owner_ops) {
		$query_string .= " AND " if $query_string;
		$query_string .= '( ' . join( ' OR ', @owner_ops ) . ' )';
	}

	{
		my $sec_ops = join(" OR ticket.queue = ",grep { $_ =~ /^\d+$/ and can_display_queue($_,$user)>0 } keys %queues);
		$sec_ops = "ticket.queue = $sec_ops OR " if $sec_ops;
		$sec_ops .= "ticket.bearbeiter = $users{$user}{user_id}";

		$query_string .= " AND" if $query_string;
		$query_string .= " ( /* security */ $sec_ops )";
	}

	if (!$query_string) {
		$query_string = "( /* DEF '$user' */ ticket.bearbeiter = ".get_person($user)." or ticket.bearbeiter = 0 or ticket.bearbeiter = 1 ) and ticket.status = ".find_descr("tickets",'open');
	}
	
	$query_string .= ' GROUP BY ticket.id';
	$query_string .= ' ORDER BY ' . ( $order_ops ? $order_ops : 'ticket.id' );

	my $lim = $request->param('q_limit');
	$lim = 1000 unless $lim and $lim ne "--";
	$lim++;
	$query_string .= " LIMIT $lim ";
	
	my @idlist = get_queue($query_string,$user,$add_from,$joins);

	print <<END;

<!-- Query String 
$add_from
$query_string
 -->
END
	$fields ||= $RT_DEFAULT_FIELDS;

	print "<TABLE cellpadding=3 border=1 ";
	print " width=\"100%\"" if $fields =~ /%/;
	print "bgcolor=\"\#bbbbbb\">\n";
### TABLE

#" # <COLGROUP> <COL span=7> <COL width=20> <COL span=2></COLGROUP>
### tut nix unter Netscape

	print Tr( do {
		my @res;

		foreach my $ff(split(//,$fields)) {
			push(@res,queue_header($request,'number',$en?"Ser":"Nr")) if $ff eq "a";
			push(@res,queue_header($request,'number',$en?"Serial":"Ticket")) if $ff eq "A";
			push(@res,queue_header($request,'queue',"Queue")) if $ff eq "b";
			push(@res,queue_header($request,'owner',$en?"Owner":"Besitzer")) if $ff eq "c";
			push(@res,queue_header($request,'priority',$en?"Pri":"Prio")) if $ff eq "d";
			push(@res,queue_header($request,'status',"Status")) if $ff eq "e";
			push(@res,queue_header($request,'age',$en?"Age":"Alter")) if $ff eq "f";
			push(@res,queue_header($request,'age',$en?"Age":"Alter")) if $ff eq "F";
			push(@res,queue_header($request,'date_acted',$en?"Action":"Änderung")) if $ff eq "g";
			push(@res,queue_header($request,'date_acted',$en?"Action":"Änderung")) if $ff eq "G";
			push(@res,queue_header($request,'date_due',$en?"Re-Open":"Wiederv.")) if $ff eq "h";
			push(@res,queue_header($request,'date_due',$en?"Re-Open":"Wiederv.")) if $ff eq "H";
			push(@res,queue_header($request,'user',$en?"Requestor":"Antwort an")) if $ff eq "i";
			push(@res,queue_header($request,'kunde',$en?"Customer":"Kunde")) if $ff eq "j";
			push(@res,queue_header($request,'subject',$en?"Subject":"Titel")) if $ff eq "k";
			push(@res,queue_header($request,'subject',$en?"Subject+Info":"Titel+Info")) if $ff eq "K";
			push(@res,queue_header($request,'timestamp',$en?"Told":"benachr.")) if $ff eq "l";
			push(@res,queue_header($request,'timestamp',$en?"Told":"benachr.")) if $ff eq "L";
			push(@res,queue_header($request,'area',$en?"Area":"Bereich")) if $ff eq "m";
			push(@res,queue_header($request,'date_created',$en?"Created":"Angelegt")) if $ff eq "n";
			# push(@res,queue_header($request,'relevanz',$en?"Match":"Übereinstimmung")) if $ff eq "r";
			push(@res,queue_header($request,'date_fdue',$en?"Due":"Fällig")) if $ff eq "s";
			push(@res,queue_header($request,'date_fdue',$en?"Due":"Fällig")) if $ff eq "S";
			push(@res,queue_header($request,'info',$en?"State":"Status")) if $ff eq "t";
			push(@res,queue_header($request,'tech_p',$en?"Tech":"Technik")) if $ff eq "u";
			push(@res,queue_header($request,'sales_p',$en?"Sales":"Vertrieb")) if $ff eq "v";
			push(@res,queue_header($request,'zeit_mit_faktor',$en?'Work Time incl. F.':'Ist-Zeit m. F.')) if $ff eq 'x';
			push(@res,queue_header($request,'zeit_ohne_faktor',$en?'Work Time excl. F.':'Ist-Zeit o. F.')) if $ff eq 'X';
			push(@res,queue_header($request,'zeit_soll',$en?"Time planned":"Zeit (Soll)")) if $ff eq "y";
			push(@res,queue_header($request,'zeit_todo',$en?'Time ToDo':'Zeit (ToDo)')) if $ff eq 'z';
		}
		@res
	}),"\n";

	my($idlist,$zeit_todo);
	my $count = 0;

	foreach my $temp (@idlist){
		last unless --$lim;
		$idlist .= $req{$temp}{'effective_sn'}."-".$req{$temp}{'seq'}.","
			if @idlist < ID_LIMIT;
		
		my $bgcolor = (++$count%2)?"#ffffff":"#dddddd";
		print "<TR BGCOLOR=\"$bgcolor\">";

		foreach my $ff(split(//,$fields)) {
			
			if($ff eq "#") {
				print "<!-- RT#".$req{$temp}{serial_num}."-".$req{$temp}{seq}."#RT -->" if $ff eq "#";
			}
			if($ff eq "a") {
				my $url = req_url $request,
				                  display       => 'History',
				                  serial_num    => $req{$temp}{effective_sn},
				                  now           => $req{$temp}{date_acted},
				                  defined $request->param('max_sequences')
				              ? ( max_sequences => $request->param('max_sequences') )
				              : ();
				$url .= "#t-".$req{$temp}{serial_num}."-".$req{$temp}{seq} unless $request->param("rev");
				print tdf($fields,$count,a({href=>$url,
					   target => ($fields =~ /\*/) ? "_blank" : "Ticket"},
					  $req{$temp}{serial_num}."-".$req{$temp}{seq}));
			}
			print tdf($fields,$count,$req{$temp}{queue}{name}) if $ff eq "b";
			print tdf($fields,$count,b(esc($req{$temp}{owner}))) if $ff eq "c";
			print tdf($fields,$count,$req{$temp}{since_told}) if $ff eq "l";
			print tdf($fields,$count,$req{$temp}{since_told_l}) if $ff eq "L";
			print tdf($fields,$count,$req{$temp}{area}) if $ff eq "m";
			print tdf(
				$fields, $count,
				{},
				{
					align   => 'center',
					bgcolor => prio_color( $req{$temp}{priority} )
				},
				a(
					{
						href => req_url(
							$request,
							display    => 'SetPrio',
							serial_num => $req{$temp}{effective_sn},
							now        => $req{$temp}{date_acted},
						),
						target => $fields =~ /\*/ ? '_blank' : 'Ticket',
					},
					sprintf '%02d',
					$req{$temp}{priority}
				)
			) if $ff eq 'd';
			print tdf($fields,$count,$req{$temp}{status}) if $ff eq "e";
			print tdf($fields,$count,$req{$temp}{age}) if $ff eq "f";
			# print tdf($fields,$count,$req{$temp}{relevanz}) if $ff eq "r";
			print tdf($fields,$count,$req{$temp}{age_l}) if $ff eq "F";
			print tdf($fields,$count,scalar isodate($req{$temp}{date_created})) if $ff eq "n";
			print tdf($fields,$count,$req{$temp}{since_acted}) if $ff eq "g";
			print tdf($fields,$count,$req{$temp}{since_acted_l}) if $ff eq "G";

			if($ff eq "h") {
				my $due = $req{$temp}{till_due};
				my @attr;
				@attr = (color => "#ff0000") if substr($due,0,1) eq '-';
				print tdf($fields,$count,{@attr}, $due);
			}
			if($ff eq "H") {
				my $due = $req{$temp}{till_due_l};
				my @attr;
				@attr = (color => "#ff0000") if substr($due,0,1) eq '-';
				print tdf($fields,$count,{@attr}, $due);
			}
			print tdf( $fields, $count, blink_if_elapsed($req{$temp}{till_fdue}) )
				if $ff eq 's';
			print tdf( $fields, $count, blink_if_elapsed($req{$temp}{till_fdue_l}) )
				if $ff eq 'S';
			if($ff eq "u") {
				print tdf($fields,$count,{}, esc( defined $req{$temp}{ tech_p} ? kpersinfo($req{$temp}{ tech_p}) : '-' ));
			}
			if($ff eq "v") {
				print tdf($fields,$count,{}, esc( defined $req{$temp}{sales_p} ? kpersinfo($req{$temp}{sales_p}) : '-' ));
			}
			$ff eq $_->[0] and print tdf( $fields, $count, {},
				$req{$temp}{"zeit_$_->[1]_faktor"}
				? date_diff_ll( 0, $req{$temp}{"zeit_$_->[1]_faktor"} )
				: '-' )
			  for [ x => 'mit' ], [ X => 'ohne' ];
			if($ff eq "y") {
				print tdf($fields,$count,{}, $req{$temp}{t_zeit} ? date_diff_ll(0,$req{$temp}{t_zeit}) : "-");
			}
			if ( $ff eq 'z' ) {
				my $ist_zeit = $req{$temp}{zeit_mit_faktor} || 0;
				print tdf($fields,$count,{}, $req{$temp}{t_zeit} ? date_diff_ll( $ist_zeit, $req{$temp}{t_zeit} ) : '-');
				$zeit_todo += $req{$temp}{t_zeit} - $ist_zeit if $req{$temp}{t_zeit} && $ist_zeit <= $req{$temp}{t_zeit};
			}
					
			if($ff eq "i") {
				my $req = $req{$temp}{'requestors'} || "--";
				$req = substr($req, 0,13).".." if length $req > 15;
				print tdf($fields,$count,esc($req));
			}

			if($ff eq "j") { 
				my $color = "000000";
				if($req{$temp}{kprio}) {
					$color = "808080";
					$color = "d00000" if $req{$temp}{kprio} eq 'a';
					$color = "d000d0" if $req{$temp}{kprio} eq 'b';
					$color = "0000d0" if $req{$temp}{kprio} eq 'c';
				}
				print tdf( $fields, $count, a( { style => "color:'$color", href => info4kunde( $request, $req{$temp}{kunde} ), target => 'kundeninfo' }, font( {color => "#$color" }, esc($req{$temp}{kunde}))) );
			}
			print tdf($fields,$count,esc($req{$temp}{subject})) if $ff eq "k";
			print tdf($fields,$count,esc($req{$temp}{subject}).'<br />'.esc($req{$temp}{info})) if $ff eq "K";
			print tdf($fields,$count,esc($req{$temp}{info})) if $ff eq "t";

		} # end for fields
		print "</TR>\n";
	} # end for requests
### TABLE
	print "</TABLE><HR> ";

	push @messages,
	  $lim
	  ? @idlist
	  . ( $en
		? ' ticket' . ( @idlist != 1 && 's' ) . ' found.'
		: ' Ticket' . ( @idlist != 1 && 's' ) . ' gefunden.' )
	  : $en
	  ? 'There are more tickets.'
	  : 'Es gibt noch weitere Tickets.';

	if ($zeit_todo) {
		$zeit_todo = date_diff_ll( 0, $zeit_todo );
		push @messages,
		     $en ? "The estimated time for ToDos as regards the tickets displayed above is $zeit_todo."
		         : "In den o.g. Tickets gibt es noch schätzungsweise $zeit_todo zu arbeiten.";
	}
	print b(i("@messages")) if @messages;
	
	$idlist;
}

sub tdf($$@) {
	my $inf = shift;
	my $count = shift;

	my %args;
	%args = %{shift()} if ref $_[0];
	my %td_args = %{ +shift } if ref $_[0];
	unless($args{size}) {
		if($inf =~ /\+\+/) {
			$args{size}="+1";
		} elsif($inf =~ /\+/) {
			$args{size}="+0";
		} elsif($inf =~ /\-/) {
			$args{size}="-2";
		} else {
			$args{size}="-1";
		}
	}
	$args{face}="Helvetica" unless $args{face};

	my @cont = grep { defined $_ and $_ ne ""} @_;
	@cont = ("&nbsp;") unless @cont;

	td( { nowrap => undef, %td_args }, font( \%args, @cont ) );
}

sub display_history_tables($$) {
	my ($request,$serial)=@_;
	my $user = $request->param('auth_user');
	my $req = $req{$serial};
	my $en = english_preferred;
	my $tt;
	
	return unless can_display_request($serial,$user) > 0;

	my $total=transaction_history_in($serial, $user)-1;
	# warn "Q $serial: Trans $total\n";

	my $pers = get_person($user);
	if($pers and $req->{seq}) {
		Do("delete writeonce from ticketlast where ticket = $serial and person = $pers and seq < $req->{seq}");

		# Workaround, vgl. Ticket #10026641:
		DoN("replace writeonce into ticketlast (ticket,person,seq) values ($serial,$pers, $req->{seq})");

	} elsif($pers) {
		Do("delete writeonce from ticketlast where ticket = $serial and person = $pers");
		
	}

	local($|)=1;

	my @tmap = (0 .. $total);
	@tmap = reverse @tmap if $request->param("rev");
	if($request->param("nst")) {
		my $sc = 0;
		foreach my $tt(0..$total) {
			$tmap[$sc++] = $tmap[$tt]
				unless $is_status{$req->{trans}[$tmap[$tt]]{'type'}};
		}
		$total = $sc-1;
	}
	$#tmap = $total;
	if($request->param("fup")) {
		my $sc = 0;
		my @mit; my @ohne;
		foreach my $tt(@tmap) {
			if($req->{trans}[$tt]{'type'} eq "queue_ptr") {
				push(@mit,$tt);
			} else {
				push(@ohne,$tt);
			}
		}
		@tmap = (@mit,@ohne);
	}
	$#tmap = $total;

	print big('T').'ransaction '.big('H').'istory', script(<<'_');
function toggleSignature(div_id) {
	var sig_style = document.getElementById(div_id).style;
	sig_style.display = sig_style.display == 'none' ? 'block' : 'none';
}
_
	my $max_sequences = $request->param('max_sequences');
	if ($max_sequences) {
		$max_sequences =~ y/0-9//cd;
		if ( $max_sequences && $max_sequences < @tmap ) {
			my $cut = @{[ $request->param('rev')
			              ? splice(@tmap, $max_sequences)
			              : splice(@tmap, 0, @tmap - $max_sequences) ]};
			print "; $cut ",
			      $en ? 'sequence'.($cut != 1 && 's').' omitted.'
			          : 'Eintr'.($cut == 1 ? 'ag wird' : '&auml;ge werden').' nicht angezeigt.';
		}
	}

	print br;

	foreach my $tt(@tmap){
		my $trans = $req->{trans}[$tt];
		my ($wday, $mon, $mday, $hour, $min, $sec, $TZ, $year)=parse_time($trans->{time});
		my $date=sprintf ("%s, %s %s %4d", $wday, $mon, $mday, $year);
		my $time=sprintf ("%.2d:%.2d:%.2d", $hour,$min,$sec);
		
		my $bgcolor="#000000";
		
		$bgcolor="#000077" if ($trans->{type} eq 'correspond');
		$bgcolor="#0000CC" if ($trans->{type} eq 'comments');
		$bgcolor="#0000AA" if ($trans->{type} eq 'create');
		$bgcolor="#339900" if ($trans->{type} eq 'status');
		$bgcolor="#330000" if ($trans->{type} eq 'owner');
		$bgcolor="#AA0000" if ($trans->{type} eq 'date_due');
		$bgcolor="#AA0000" if ($trans->{type} eq 'date_fdue');
		$bgcolor="#008800" if ($trans->{type} eq 'queue_ptr');
		$bgcolor="#AAAA00" if ($trans->{type} eq 'docushare');
		my $extern = uc ($trans->{extern} || "") eq 'Y' and substr($bgcolor, 1, 2) = 'CC';

		my $tsx;
		if($trans->{type} eq 'queue_ptr') {
			$tsx = DoFn("select t2.status from ticket as t1,ticket as t2 where t2.id = t1.ticket and t1.id = $trans->{content}");
			if($tsx) {
				$tsx = get_descr("tickets",$tsx);
				# weniger grün, wenn's inzwischen in das aktuelle Ticket
				# reingemergt wurde
				if (   defined( my $sn1 = normalize_sn( $trans->{content} ) )
					&& defined( my $sn2 = normalize_sn( $req->{seq} ) ) )
				{
					$bgcolor = '#004400' if $sn1 == $sn2;
				}
			} else {
				$tsx = "unbekannt";
			}
		}

		print table({width=>"100%",cellpadding=>0,cellspacing=>0,border=>0},
			 Tr({bgcolor=>$bgcolor},
			    td({width=>5},'&nbsp;'),
			    td({align=>"left",valign=>"middle",nowrap=>undef},
				    font({color=>"#ffffff"},
	                     $trans->{serial_num}."-".$trans->{seq}),
					br(),
				    font({color=>"#ffffff",size=>"-1"},$date,$time)),"\n",
				td('&nbsp;&nbsp;'),
				td({align=>"left"},"\n",
				   font({color=>"#ffffff"},
				        a({name=>"t-".$trans->{serial_num}."-".$trans->{seq}},
						  b(($trans->{type} eq 'queue_ptr') ?
								( $en ? 'Follow-up request' : ' Folge-Ticket' ) .
								 a({href=>req_url($request,display=>'History',now=>$time,serial_num=>do { $trans->{content} =~ /^(\d+)/; $1 } ),
									# target => ($request->param('q_fields') =~ /\*/) ? "_blank" : "Ticket"
									},
									
								   $trans->{content}).
								 " ($tsx) ".
								 ($trans->{content} < $trans->{serial_num} ? ( $en ? 'from' : 'aus' ) : "in").
								 ( $en ? ' queue ' : ' Queue ' ) .
								 ($trans->{data} && $queues{lc $trans->{data}} ? $queues{lc $trans->{data}}{name} : "?? ".$trans->{data}).
								 ( $en ? ' created by ' : ' angelegt von ' ) . $trans->{actor}
							:
								esc( $trans->{ $en ? 'text_en' : 'text' },
									$request )
						)))),"\n",
				{correspond=>1,comments=>1,create=>1}->{$trans->{type}} && can_manipulate_request($serial,$user)>0
				? td(
					{align=>"right",valign=>"bottom",nowrap=>undef},
					join '&nbsp;',
					fdro_murl($request, [whatever=>'set_visibility', extern=>$extern?'n':'y'], 'summary', font( {color=>'#ffffff'}, $extern ? $en ? '[make invisible]' : '[unsichtbar machen]' : $en ? '[make visible]' : '[sichtbar machen]'), $trans),
					fdro_murl($request,[display=>"SetThisReply"],"history",font({color=>"#ffffff"},"[R]"),$trans, title=>($en?"Reply to this message":"Antwort auf diese Nachricht"), ),
					fdro_murl($request,[display=>"SetGroupReply"],"history",font({color=>"#ffffff"},"[G]"),$trans, title=>($en?"Group Reply to this message":"Gruppenantwort auf diese Nachricht"),),
					fdro_murl($request,[display=>"SetMail"],"history",font({color=>"#ffffff"},"Re-Mail"),$trans, title=>$en?"Mail this text":"Diesen Text mailen"),
					fdro_murl($request,[display=>"SetComment"],"history",img({border=>0, src => "/images/rt/comment.gif", alt=>"[Comment]"}),$trans, title => $en?"Comment this":"diesen Text kommentieren").
					fdro_murl($request,[display=>"SetReply"],"history",img({border=>0, src => "/images/rt/respond.gif", alt=>"[Reply]"}),$trans, title => $en?"Reply to requestor":"Antwort an den Anfragenden")
				)
				: (),

				can_add_time($user)
				  ? td(
					{ align => 'right' },
					a(
						{
							    href => '/verwaltung/stunden/?kunde='
							  . uri_escape_utf8( $req->{kunde} )
							  . "&ticket=$serial&subject="
							  . uri_escape_utf8(
								    'RT#'
								  . $trans->{serial_num} . '-'
								  . $trans->{seq}
							  )
						},
						img(
							{
								alt => $en ? 'Add Time' : 'Zeit eintragen',
								border => 0,
								height => 24,
								src    => '/images/rt/window_time.png',
								width  => 24,
							}
						)
					)
				  )
				  : '',

			    td({width=>5},'&nbsp;')),"\n",

				$trans->{'type'} eq "queue_ptr" ?
				do {
					my $spc = ":&nbsp;";
					my $lreq = req_in($trans->{content},$user);
					if($lreq) {
							Tr({valign=>"top"},
								td({colspan=>2,align=>"right"},b($en?"Subject":"Titel").$spc),
								td({colspan=>4},esc($lreq->{subject}))).
							Tr({valign=>"top"},
								td({colspan=>2,align=>"right"},b($en?"State":"Status").$spc),
								td({colspan=>4},esc($lreq->{info}))).
							Tr({valign=>"top"},
								td({colspan=>2,align=>"right"}, b($en?"Owner":"Bearbeiter").$spc),
								td({colspan=>4},esc($lreq->{owner} || '-' ))).
							Tr({valign=>"top"},
								td({colspan=>2,align=>"right"}, b($en?"Customer":"Kunde").$spc),
								td({colspan=>4},esc($lreq->{kunde})))
					} else {
						Tr(td({colspan=>6},b($en?"(no access rights)":"(keine Berechtigung)")));
					}
				} : $trans->{'type'} eq "docushare" ?
				(ffehler {
					my $di = $trans->{'data'};
					$di =~ s/-(\d+)$//;
					my $thisv = $1;
					my $lastv = $thisv ? propxget($di,"GetLastversion","lastversion") : "1";
					Tr(td({align=>"right"},$en?"Contents:":"Inhalt:"),
						td(
						   ($thisv and $thisv != $lastv) ?
							b("alte Version ".a({href=>("$DOCUSHARE/GetVersion/File-$di/$thisv")},$en?"here":"hier")).($en?"; current version ":"; aktuelle Version "):"",
							a({href=>"$DOCUSHARE/Get/File-$di"},$en?"here":"hier")." (".($en?"or ":"oder ").a({href=>"$DOCUSHARE/GetRepr/File-$di/html"},$en?"as HTML":"als HTML").")"
							)) .
					Tr(td({align=>"right"},$en?"Properties:":"Eigenschaften:"),
						td(a({href=>"$DOCUSHARE/ViewProps/File-$di"},$en?"here":"hier")))
				} sub {
					Tr(td(pre(report_fehler(1|2))))
				}) :
				($trans->{'content'} !~ /^[-\s\n0-9]*$/si) ?
				 Tr(td({bgcolor=>"#FFFFFF",colspan=>6,},
				    table({cellpadding=>20,width=>'100%'},
						Tr(td({bgcolor=>"#EEEEEE"},
						   print_transaction($request->param('show_all_headers') ? 'all' : qr/^(Content-Type|Reply-To|From|Subject|Date|To|Cc|Bcc|X-purgate)$/i, $request, $trans)))))) : "",
			     Tr(td({colspan=>6},img({src=>"/images/rt/sbs.gif",width=>"100%",height=>4,alt=>""}))));
	}
### TABLE FONT
	# print "</TABLE>\n";
}


sub do_bar($$) {
  	my($request,$serial) = @_;
	my $req = $req{$serial};
	my $user = $request->param('auth_user');
	my $en = english_preferred;

	my $cmr = can_manipulate_request($serial,$user);

    print div({align=>"center"},
		fdro_murl($request,[display=>"SetComment"],"history",b($en?"Comment":"Kommentar"),{serial_num => $serial}),
		" | ",
		fdro_murl($request,[display=>"SetReply"],"history",$en?"Reply":"Antwort",{serial_num => $serial}),
		do {
      		unless ( $cmr > 0 ) { "" }
			elsif(not $req->{owner}) {
		 		" | ". fdro_murl($request,[whatever=>"give",owner=>"$user"],"summary",$en?"Take":"nehmen",{serial_num => $serial});
			} elsif($req->{owner} eq $user) {
		 		" | ". fdro_murl($request,[whatever=>"untake"],"summary",$en?"Release":"freigeben",{serial_num => $serial});
			} else {
		 		" | ". fdro_murl($request, [display=>"SetSteal",owner=>$user],"summary", $en?"Steal":"stehlen" ,{serial_num => $serial});
			}
		 },

      	($cmr>0 and $req->{status} ne 'open') ? 
		 " | " . fdro_murl($request,[whatever=>"open"],"summary",$en?"Open":"Öffnen",{serial_num => $serial}) : "",

    	($cmr>0 and $req->{status} ne 'stalled' and (not $req->{owner} or $req->{owner} eq $user)) ?
		 " | ". fdro_murl($request,[display=>"SetStall"],"summary",$en?"Stall":"Wiedervorlage",{serial_num => $serial}) : "",

    	($cmr>0 and $req->{status} ne 'resolved' and (not $req->{owner} or $req->{owner} eq $user)) ?
		 " | ". fdro_murl($request,[whatever=>"resolve"],"summary",$en?"Resolve":"Schließen",{serial_num => $serial}) : "",

   		$cmr>0 ?
		" | ". fdro_murl($request,[display=>"SetKill"],"summary",$en?"Kill":"Löschen",{serial_num => $serial}).
		" | ". fdro_murl($request,[display=>"SetDocushare"],"summary",$en?"DocuShare":"Doku-Link",{serial_num => $serial}).
		' | '. fdro_murl($request,[display=> ( exists $req->{subscribers}{$user} && 'un' ).'subscribe'],"summary", exists $req->{subscribers}{$user} ? $en?'Unsubscribe':'Abo&nbsp;beenden' : $en?'Subscribe':'Abonnieren', {serial_num => $serial})
		: '',
		can_add_time($user) ?
		 ' | '. a({href => '/verwaltung/stunden/?kunde='.uri_escape_utf8($req->{kunde})."&ticket=$serial&subject=".uri_escape_utf8($req->{subject})},b($en?'Add Time':'Zeit eintragen')) : '',

	"");
}

sub do_xbar($$) {
  	my($request,$serial) = @_;
	my $req = $req{$serial};
	my $en = english_preferred;

    print div({align=>"center"},
		$request->param("fup") ?
		a({href => req_url($request,display=>"History",now=>$time,serial_num=>$serial,fup=>0)},$en?"Linked Tickets inlined":"Verbundene Tickets im Kontext") :
		a({href => req_url($request,display=>"History",now=>$time,serial_num=>$serial,fup=>1)},$en?"Linked Tickets on top":"Verbundene Tickets am Anfang")
		," | ",
		$request->param('show_all_headers') ?
		a({href => req_url($request,display=>"History",now=>$time,serial_num=>$serial,show_all_headers=>0)},$en?'show only important headers':'nur wichtige Header anzeigen') :
		a({href => req_url($request,display=>"History",now=>$time,serial_num=>$serial,show_all_headers=>1)},$en?'show all headers':'alle Header anzeigen')
		," | ",
		$request->param("nst") ?
		a({href => req_url($request,display=>"History",now=>$time,serial_num=>$serial,nst=>0)},$en?"Show everything":"alles anzeigen") :
		a({href => req_url($request,display=>"History",now=>$time,serial_num=>$serial,nst=>1)},$en?"Text only":"nur Texte")
	);
}



sub display_summary($$) {
	my ($request,$serial)=@_;
	my $req = $req{$serial};
	my $en = english_preferred;
	my $user = $request->param('auth_user');
	
	unless(can_display_request($serial,$user) > 0) {
		print i(b($en?"You are not allowed to access this ticket (in queue ".$req->{queue}{name}.").":"Sie haben keine Erlaubnis, dieses Ticket (in Queue ".$req->{queue}{name}.") zu lesen."));
		return;
	}

	my $owner = $req->{owner} ? esc($req->{owner}) : i($en?"none":"niemand");
	my $subject = $req->{subject} ? esc($req->{subject}) : i($en?"none":"keines");
	my $info = $req->{info} ? esc($req->{info}) : i($en?"none":"keines");
	my $area = $req->{area} ? esc($req->{area}) : i($en?"none":"keiner");
	my $acted = $req->{date_acted} || DoTime;

	my $spc = td('&nbsp;');

	# Trennung von Variablendeklaration und bedingter Initialisierung wichtig, vgl. RT#244828:
	my @attr;
	@attr = (bgcolor=>'#FFCCCC') if is_visible($serial,$req);
	print "\n",center(table({cellspacing=>0, cellpadding=>0, border=>0},
		  Tr({valign=>"top", @attr},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetMerge",now=>$acted,serial_num=>$serial)},
			     b($en?"Serial Number":"RT-Nummer"))),
			$spc,td($serial)),
		  "\n",
		  Tr({valign=>"top", @attr},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetSubject",now=>$acted,serial_num=>$serial)},
			     b($en?"Subject":"Titel"))),
			$spc,td($subject)),
		  "\n",
		  Tr({valign=>"top", @attr},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetInfo",now=>$acted,serial_num=>$serial)},
			     b($en?'Info':'Info'))),
			$spc,td($info)),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetKunde",now=>$acted,serial_num=>$serial)},
			     b($en?"Customer":"Kunde"))),
			     $spc,
			     td( a( { href => info4kunde( $request, $req->{kunde} ), target => 'kundeninfo' }, esc($req->{kunde}) ) )
		      ),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetQueue",now=>$acted,serial_num=>$serial)},
			     b("Queue"))),
			$spc,td(esc($req->{queue}{name}))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   can_manipulate_request($serial,$user)>0 ? 
			    a({href => req_url($request,display=>"SetArea",now=>$acted,serial_num=>$serial)},
			      b("Area")) :
			    b($en?"Area":"Bereich")),
			$spc,td($area)),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetUser",now=>$acted,serial_num=>$serial)},
			     b($en?"Requestors":"Antwort an"))),
			$spc,td(esc($req->{requestors}))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetGive",now=>$acted,serial_num=>$serial)},
			     b($en?"Owner":"Bearbeiter"))),
			$spc,td(esc($req->{owner}))),
		  "\n",
		  Tr({valign=>'top'},
		    td({align=>'right'}, b($en?'Subscriber(s)':'Abonnent(en)')),
			$spc,td(esc( join( ', ', sort keys %{$req->{subscribers}} ) || '(keine)' ))),
		  "\n",
		  Tr({valign=>"top", @attr},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetStatus",now=>$acted,serial_num=>$serial)},
			     b("Status"))),
			$spc,td(esc($req->{status}))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			     b($en?"Last user contact":"letzte Nachricht")),
			$spc,td($req->{date_told} ? scalar isotime($req->{date_told})." (".$req->{since_told}." ago)" : i("Never contacted"))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetPrio",now=>$acted,serial_num=>$serial)},
			     b($en?"Current Priority":"aktuelle Priorität"))),
			$spc, td( span({style=>'background-color:'.prio_color($req->{priority})}, sprintf '%02d', $req->{priority})) ),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetDateDue",now=>$acted,serial_num=>$serial)},
			     b($en?"Re-Open":"Wiedervorlage"))),
			$spc,td($req->{date_due} ? scalar isotime($req->{date_due})." (in ".$req->{till_due_l}.")" : i($en?"No date assigned":"kein Datum gesetzt"))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetDateFDue",now=>$acted,serial_num=>$serial)},
			     b($en?"Due":"Termin"))),
			$spc,td($req->{date_fdue} ? do {
					my $text = isotime($req->{date_fdue}) . ' (in ' . $req->{till_fdue_l}. ')';
					if ( $time > $req->{date_fdue} ) {
						font( {color=>'red'}, strong("<blink>$text</blink>") )
					}
					else {
						{ bgcolor => '#FF' . ( sprintf( '%2X', 256 * ( $req->{date_fdue} - $time ) / ( $req->{date_fdue} - $req->{date_created} ) ) x 2 ) }, $text
					}
			        } : i($en?"No date assigned":"kein Datum gesetzt"))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   b($en?"Last action":"letzte Aktion")),
			$spc,td( $req->{date_acted} ? scalar isotime($req->{date_acted})." (".$req->{since_acted}." ago)" : i("Never"))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   b($en?"Created":"Angelegt")),
			$spc,td($req->{date_created} ? scalar isotime($req->{date_created})." (".$req->{age}." ago)" : i("Never??"))),
		  "\n",
		  Tr({valign=>"top"},
		    td({align=>"right"},
			   a({href => req_url($request,display=>"SetWork",now=>$acted,serial_num=>$serial)},
			     b($en?"Work Time":"Arbeitszeit"))),
			$spc,
			td(
				$req->{t_zeit}
				? date_diff_ll( 0, $req->{zeit_mit_faktor} ) . ' / '
				  . date_diff_ll( 0, $req->{t_zeit} )
				  . sprintf( ' (%.f %%)',
					100 * $req->{zeit_mit_faktor} / $req->{t_zeit} )
				: date_diff_ll( 0, $req->{zeit_mit_faktor} ),
				$req->{zeit_mit_faktor} != $req->{zeit_ohne_faktor}
				  && '('
				  . ( $en ? 'without factors' : 'ohne Faktoren' ) . ': '
				  . date_diff_ll( 0, $req->{zeit_ohne_faktor} ) . ')'
			  )
			),
		  "\n",
#		  Tr({valign=>"top"},
#		    td({align=>"right"},
#			   b($en?"Sales":"Vertrieb")),
#			$spc,td($req->{sales_p}?b(esc(kpersinfo($req->{sales_p}))):"???")),
#		  (defined $si and $si ne "") ? Tr($spc,$spc,td({align=>"left"}),$si) : "",
#		  "\n",
#		  Tr({valign=>"top"},
#		    td({align=>"right"},
#			   b($en?"Tech":"Technik")),
#			$spc,td($req->{tech_p}?b(esc(kpersinfo($req->{tech_p}))):"???")),
#		  (defined $ti and $ti ne "") ? Tr($spc,$spc,td({align=>"left"}),$ti) : "",
	  "")),"\n";

}
  

#display a column header for the queue

sub queue_header($$$) {
	my($request, $col, $name) = @_;
	my @oldsort = ();
	@oldsort = split(/,/,$request->param('q_sort')) if $request->param('q_sort');
	my @newsort;
	my %sort;

	unless(@oldsort % 1 or (@oldsort > 1 and $oldsort[1] ne "UP" and $oldsort[1] ne "DOWN")) {
		# neu
		%sort = @oldsort;
	} else {
		# Kompatibilität zu alten URLs
		map { $sort{$_} = "UP"; } @oldsort;
	}
	$sort{$col} = ""; delete $sort{"UP"}; delete $sort{"DOWN"};
	@newsort = ($col, "UP", map { $sort{$_} ? ($_,$sort{$_}) : () } @oldsort);

	$request->param('q_sort',join(",",@newsort));
	my $url1 = req_url($request,-query=>1);
	$newsort[1] = "DOWN";
	$request->param('q_sort',join(",",@newsort));
	my $url2 = req_url($request,-query=>1);

	if(@oldsort) {
		$request->param('q_sort', join(",",@oldsort))
	} else {
		$request->delete('q_sort');
	}

	th({nowrap=>undef},font({size=>"-1"},
		center(
			$name, br(),
			a({href => $url1},
				img({src=>"/images/rt/up.gif",
				alt=>"Up", border=>0})
			),
			a({href => $url2},
				img({src=>"/images/rt/down.gif",
				alt=>"Down", border=>0})
			)
		)
	));
#	$header = "<TH><CENTER><FONT SIZE=\"-1\">$name<br><a
#	href=\"$ScriptURL?q_sort=$col\&$query\"><img
#	src=\"/images/rt/up.gif\" alt=\"Ascending\"
#	border=0></a>&nbsp;<a
#	href=\"$ScriptURL?q_sort=$col\&q_reverse=1&$query\"><img
#	src=\"/images/rt/down.gif\" alt=\"Descending\"
#	border=0></a></FONT></CENTER></TH>";
}

#display req options munge url
#makes it easier to print out a url for fdro
sub fdro_murl($$$$$%) {
  	my ($request,$custom_content,$target,$description,$trans,%addon) = @_;
	my @cust = @$custom_content;
	push(@cust,transaction=>join("-",@{$trans->{id}})) if $trans->{id};

	my $fields = $request->param('q_fields') || "";
	my $acted = $trans->{serial_num} && $req{$trans->{serial_num}}{date_acted} || $time;

	a({href => req_url($request,now=>$acted,serial_num=>$trans->{serial_num},@cust),
	   %addon, # target => ($fields =~ /\*/) ? "_blank" : "Ticket"
	}, $description);
}

sub display_commands($;$) {
	my($request,$notarget) = @_;
	my $serial = normalize_sn($request->param('serial_num'));
	my $fields = $request->param('q_fields') || "";
	my $en = english_preferred;


    print center(font({size=>-1},
		a({href => req_url($request,display=>'Create'),
		   $notarget ? () : (target => ($fields =~ /\*/) ? "_blank" : "Ticket")},
    	  $en?"Create a request":"Neues Ticket"),
        " | ",
    
		a({href => req_url($request,display=>'ShowNum'),
		   $notarget ? () : (target => ($fields =~ /\*/) ? "_blank" : "Ticket")},
    	  $en?"View Specific Request":"Ticket aufrufen"),
        " | ",
		a({href => req_url($request,display=>'Logout'), target => "_top"},
		  "Logout")));
}

sub initialize_sn($) {
	my($request) = @_;
	my @ser;
	@ser = normalize_sn($request->param('serial_num'));
	unless(@ser) {
		my @key = $request->keywords();
		if(@key > 1) {
    		print $request->header(-nph=>!$DB::apache2,-status=>"402 Bad serial"),
	              $request->start_html( -bgcolor => $BGCOLOR, -title => 'Bad serial' ),
                      $request->h1("Bad serial"),
				"You can only enter use one serial number",hr(),
				end_html();
			return undef;
		}
		if(@key == 1) {
			@ser = @key;
			$request->param('serial_num',@key);
			$request->param('display',"Queue") unless defined $request->param('display');
			
		} elsif(@key == 0) {
			@ser = (0);
		}
	}
	elsif (@ser > 1) { die "More than one serial_num: @ser\n" }
	elsif (defined $ser[0]) {
		$ser[0] =~ y/0-9//cd;
		$request->param( serial_num => $ser[0] );
	}
	@ser;
}

1;
