# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::database::config;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use vars qw(@ISA @EXPORT_OK);
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(get_confitems is_password is_an_area is_a_queue is_a_user read_config);

use Dbase::Help qw(DoSelect DoFn);
use Dbase::Globals qw(find_descr bignum list_descr);

use vars qw(%users %queues %pwcache);

{    # s. RT#429956:

	package RT::users;

	use Carp 'cluck';
	use Tie::Hash;
	use base 'Tie::StdHash';

	sub STORE {
		my $hash = shift;
		my ($key) = @_;
		cluck("Seltsamer User: $key") if $key !~ /^\w+\z/;
		$hash->SUPER::STORE(@_);
	}
}
tie %RT::users, 'RT::users';

BEGIN {
	no warnings 'once';
	*users = \%RT::users;
	*queues = \%RT::queues;
	*pwcache = \%RT::pwcache;
}

my %warned;
sub load_queue_acls {
	my @disp;
	
	list_descr("rt_acl",0,"",sub {
	    my($xx,$id,$name,$info) = @_;
	    $disp[$id] = $name;
	});

	DoSelect {
	    my ($user_id, $queue_id, $acl, $mail) = @_;
	    return unless is_a_queue($queue_id); #the queue doesn't exist
	    return unless is_a_user($user_id);

	    my $seq = 0;
	    while($acl > 0) {
		 	$queues{$queue_id}{acls}{$user_id}{$disp[$seq]} = $acl&1 if defined $disp[$seq];
		 	$acl >>= 1;
		 	$seq++;
	    }
		if($queues{$queue_id}{acls}{$user_id}{"display"} and defined $mail) {
			$queues{$queue_id}{dist_list} .= ", "
			    if $queues{$queue_id}{dist_list};
			$queues{$queue_id}{dist_list} .= $mail;
	    }
		if($queues{$queue_id}{acls}{$user_id}{"admin"} and defined $mail) {
			$queues{$queue_id}{adist_list} .= ", "
				if $queues{$queue_id}{adist_list};
			$queues{$queue_id}{adist_list} .= $mail;
		}
		if($users{$user_id}{name}) {
	    	$queues{$queue_id}{acls}{$users{$user_id}{name}} = $queues{$queue_id}{acls}{$user_id};
		} else {
	    	warn "User $user_id ist namenlos.\n" unless $warned{$user_id}++;
		}
	} "SELECT person.id, queue_acl.queue, queue_acl.acls, person.email FROM queue_acl,person WHERE person.id = queue_acl.person";
	1;
}

sub load_queue_areas {
    DoSelect {
		my($queue_id, $area) = @_;
        return unless is_a_queue($queue_id); #the queue doesn't exist
        $queues{$queue_id}{areas}{$area}=1;
    } "SELECT queue,name from queue_areas";
	1;
}         


sub load_user_info {
	my $admin_rt = bignum(1)<<find_descr("pwdomain","rt_admin");
	my $pop_rt = bignum(1)<<find_descr("pwdomain","pop");

	%users = ();
	my $res = DoSelect {
		my($user_id,$username,$mail,$fone,$zusatz,$pwuse,$name) = @_;
		$users{$user_id}{user_id}=$user_id;
		$users{$user_id}{name}=$username;
		$users{$user_id}{password}="";
		$users{$user_id}{email}=$mail;
		$users{$user_id}{phone}=$fone;
		$users{$user_id}{comments}=$zusatz;
		$users{$user_id}{admin_rt}=(($pwuse & $admin_rt) != 0);
		$users{$user_id}{pop_rt}=(($pwuse & $pop_rt) != 0);
		$users{$user_id}{real_name}=$name;
		$users{$user_id}{short_name}=$users{$user_id}{real_name};
		$users{$user_id}{short_name}=~ s/^(Herr|Frau)\s+//;

		$users{$username} = $users{$user_id} if defined $username;
	} "SELECT distinct person.id, person.user, person.email, person.fon, person.zusatzinfo, person.pwuse&($admin_rt|$pop_rt), person.name FROM person,queue_acl where person.id = queue_acl.person";
    warn "[load_user_info] Query4 had some problem: $res\n" if $res == 0;
}

sub is_password($$) {
    my ($user_id, $in_password) = @_;
	return undef if $user_id eq '' or not defined $users{$user_id};
    
    $user_id=$users{$user_id}{user_id}; ## normalize...
    my $password = $pwcache{$user_id};
	$pwcache{$user_id} = $password = DoFn("SELECT pass from person where person.id = $user_id") unless defined $password;
       
    if (defined($password) and $password eq $in_password) {
		return 1;
    } else {
		return 0;
    }
}

sub is_a_user {
    my ($in_user_id) = @_;
    return defined $users{$in_user_id};
}
    

sub load_queue_conf {
	my $res;
	my @disp;

	%queues = ();
	list_descr("rt_queue",0,"",sub {
	    my($xx,$id,$name,$info) = @_;
	    $disp[$id] = $name;
	});
	warn "Keine ACLs definiert: $res\n" unless @disp;

	$res = DoSelect {
		my($queue_id,$queue_name,$mail,$flags,$prio,$due,$fdue) = @_;
		$queues{$queue_id}{id}=$queue_id;
		$queues{$queue_id}{name}=$queue_name;
		$queues{$queue_id}{mail_alias}=$mail;
		$queues{$queue_id}{default_due}=$due;
		$queues{$queue_id}{default_fdue}=$fdue;
		$queues{$queue_id}{default_prio}=$prio;
		my $seq = 0;
		$flags = 0 unless $flags;
		while($flags > 0) {
			$queues{$queue_id}{$disp[$seq]} = $flags&1 if defined $disp[$seq];
			$flags >>= 1;
			$seq++;
		}

		$queues{$queue_name} = $queues{$queue_id};
	} "SELECT queue.id, queue.name, queue.email, flags,defprio,defdue,deffdue FROM queue";
    warn "Query5 had some problem: $res\n" if $res == 0;
}

sub is_an_area {
    my ($queue, $area) = @_;
    return exists $queues{$queue}{areas}{$area};
}

sub is_a_queue {
    my ($queue) = @_;
    return exists $queues{$queue};
}

{
	my( @confitem_ids, %name_of_confitem, $cache_time );

	sub get_confitems() {
		unless ( defined $cache_time && time - $cache_time < 42 ) {
			@confitem_ids = %name_of_confitem = ();
			DoSelect {
				my ( $id, $name, $kunde ) = @_;
				push @confitem_ids, $id;
				$name_of_confitem{$id} = ( defined $kunde && "$kunde | " ) . $name;
			} <<_;
	SELECT    confitem.id, confitem.name, kunde.name
	FROM      confitem
	LEFT JOIN kunde ON confitem.kunde = kunde.id
	ORDER BY  confitem.kunde IS NULL DESC, kunde.name, confitem.name
_
			$cache_time = time;
		}

		\@confitem_ids, \%name_of_confitem;
	}
}

sub read_config {
	load_user_info();
	load_queue_conf();
	load_queue_acls();
	load_queue_areas();      
}

1;
