# Webserver-Script fr das regulre RT-Webinterface

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;

package RT::Web;

use vars qw(%req %queues);

use strict;
use RT;
use RT::ui::web;
use RT::ui::web::support qw(get_default_query4user user_param);
use Fehler qw(ffehler);

RT::initialize();

use CGI qw(:standard);
use Dbase::Help qw(DoFree);
use noris::Ticket::API qw(clean_connection_pool);
use Umlaut qw(utf8modus);

sub handler($) {
  my($r) = @_;

  ffehler {
	$DB::apache2 = 1;

	my $remote_user;
	eval { $remote_user = $r->connection->user; $DB::apache2 = 0; };
	$remote_user = $r->user if $@;

	local $ENV{TICKET_API_USER} = $remote_user;

	# Heikel, vgl. Ticket #10044416, aber notwendig, vgl. #541406:
	local $ENV{TICKET_BACKENDS} = 'RT';

	$r->content_type("text/html; charset='utf-8'") if $DB::apache2;

	my $cgi = $CGI::Q = new CGI;

	# Der Zugriff auf CGI->{'.fieldnames'} ist freilich eigentlich nicht
	# vorgesehen, aber wie sollen wir sonst (ohne grere Verrenkungen)
	# rauskriegen, ob eine Checkbox nicht vorhanden oder nur nicht
	# angekreuzt war? Vgl. RT#435239.
	if ( my @missing = grep !exists $cgi->{'.fieldnames'}{$_}, user_param() ) {
		my $default_cgi = get_default_query4user($remote_user);
		if ( $cgi->param ) {
			$cgi->param( $_ => $default_cgi->param($_) ) for @missing;
		}
		else { $cgi = $CGI::Q = $default_cgi }
	}

	my $program = $cgi->url(-absolute=>1,-path_info=>1,-query=>1);
	utf8modus(\*STDOUT);

	my $res = RT::ui::web::activate( $cgi, $remote_user );
	DoFree();
	clean_connection_pool($remote_user);

	return $res;
  } sub {
	print "<h1>Fehler</h1><p>",join("<p>",@_);
	DoFree();
	clean_connection_pool();
  };
}
